/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.marker;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.tools.api.DiagramPlugin;
import org.eclipse.sirius.diagram.ui.business.api.query.DDiagramGraphicalQuery;
import org.eclipse.sirius.diagram.ui.internal.providers.SiriusMarkerNavigationProvider;
import org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditor;
import org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorUtil;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.session.SessionEditorInput;
import org.eclipse.sirius.ui.tools.api.project.ModelingProjectManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.validation.ValidationRule;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class SiriusMarkerNavigationProviderSpec
extends SiriusMarkerNavigationProvider {
    @Override
    protected void doGotoMarker(IMarker marker) {
        URI markedDiagramDescriptorURI;
        URI markedResource;
        String diagramDescriptorURI = marker.getAttribute("DIAGRAM_DESCRIPTOR_URI", null);
        String elementId = marker.getAttribute("elementId", null);
        if (diagramDescriptorURI == null || elementId == null || !(this.getEditor() instanceof SiriusDiagramEditor)) {
            return;
        }
        SiriusDiagramEditor defaultEditor = (SiriusDiagramEditor)this.getEditor();
        SiriusDiagramEditor targetEditor = this.switchToTargetEditor(defaultEditor, markedResource = URI.createPlatformResourceURI((String)marker.getResource().getFullPath().toString(), (boolean)true), markedDiagramDescriptorURI = URI.createURI((String)diagramDescriptorURI));
        if (targetEditor != null) {
            Map editPartRegistry = targetEditor.getDiagramGraphicalViewer().getEditPartRegistry();
            EObject targetView = targetEditor.getDiagram().eResource().getEObject(elementId);
            if (targetView == null) {
                return;
            }
            EditPart targetEditPart = (EditPart)editPartRegistry.get(targetView);
            if (targetEditPart != null) {
                SiriusDiagramEditorUtil.selectElementsInDiagram((IDiagramWorkbenchPart)targetEditor, Arrays.asList(targetEditPart));
            }
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)targetEditor);
        }
    }

    private SiriusDiagramEditor switchToTargetEditor(SiriusDiagramEditor defaultEditor, URI sessionResourceUri, URI markedDiagramDescriptorURI) {
        Optional<Diagram> optionalDiagram;
        SiriusDiagramEditor targetEditor = null;
        DRepresentationDescriptor markedDiagramDescriptor = (DRepresentationDescriptor)defaultEditor.getDiagram().eResource().getEObject(markedDiagramDescriptorURI.fragment());
        if (markedDiagramDescriptor == null) {
            markedDiagramDescriptor = (DRepresentationDescriptor)defaultEditor.getEditingDomain().getResourceSet().getEObject(markedDiagramDescriptorURI, true);
        }
        if ((optionalDiagram = this.getGMFDiagramFromDRepresentationDescriptor(markedDiagramDescriptor)).isPresent()) {
            Diagram markerDiagram = optionalDiagram.get();
            URI markerDiagramURI = EcoreUtil.getURI((EObject)markerDiagram);
            if (defaultEditor.getDiagram().equals(markerDiagram)) {
                targetEditor = defaultEditor;
            } else {
                Object editorInput = null;
                String editorName = markedDiagramDescriptor.getName();
                Session session = new EObjectQuery((EObject)markedDiagramDescriptor).getSession();
                editorInput = session != null ? new SessionEditorInput(markerDiagramURI, editorName, session) : new URIEditorInput(markerDiagramURI, editorName);
                SiriusDiagramEditor searchEditor = this.searchEditor((URIEditorInput)editorInput);
                targetEditor = searchEditor != null ? searchEditor : this.handleClosedEditorCase(defaultEditor, sessionResourceUri, markedDiagramDescriptorURI, markerDiagram, (URIEditorInput)editorInput);
            }
        }
        return targetEditor;
    }

    private SiriusDiagramEditor openEditor(SiriusDiagramEditor defaultEditor, URI markedDiagramDescriptorURI, Diagram markerDiagram, Session session) {
        DRepresentationDescriptor markedDiagramDescriptor;
        Optional<Diagram> optionDiagramToOpen;
        Diagram diagramToOpen = markerDiagram;
        if (session.getTransactionalEditingDomain() != null && session.getTransactionalEditingDomain().getResourceSet() != defaultEditor.getEditingDomain().getResourceSet() && (optionDiagramToOpen = this.getGMFDiagramFromDRepresentationDescriptor(markedDiagramDescriptor = (DRepresentationDescriptor)session.getTransactionalEditingDomain().getResourceSet().getEObject(markedDiagramDescriptorURI, true))).isPresent()) {
            diagramToOpen = optionDiagramToOpen.get();
        }
        if (diagramToOpen != null) {
            return (SiriusDiagramEditor)DialectUIManager.INSTANCE.openEditor(session, (DRepresentation)((DDiagram)diagramToOpen.getElement()), (IProgressMonitor)new NullProgressMonitor());
        }
        return null;
    }

    private SiriusDiagramEditor handleClosedEditorCase(SiriusDiagramEditor defaultEditor, URI sessionResourceUri, URI markedDiagramDescriptorURI, Diagram markerDiagram, URIEditorInput editorInput) {
        SiriusDiagramEditor targetEditor = null;
        Session session = this.getOrOpenTargetSession(sessionResourceUri);
        SiriusDiagramEditor openedEditor = null;
        if (session != null) {
            openedEditor = this.openEditor(defaultEditor, markedDiagramDescriptorURI, markerDiagram, session);
        }
        if (openedEditor != null) {
            targetEditor = openedEditor;
            if (defaultEditor instanceof DialectEditor && ((DialectEditor)defaultEditor).getRepresentation() == null) {
                defaultEditor.close(false);
            }
        } else {
            targetEditor = defaultEditor;
            targetEditor.setInput((IEditorInput)editorInput);
        }
        return targetEditor;
    }

    private Optional<Diagram> getGMFDiagramFromDRepresentationDescriptor(DRepresentationDescriptor markedDiagramDescriptor) {
        Optional<Diagram> optional = Optional.ofNullable(markedDiagramDescriptor).map(DRepresentationDescriptor::getRepresentation).filter(DDiagram.class::isInstance).map(dd -> {
            DDiagramGraphicalQuery representationQuery = new DDiagramGraphicalQuery((DDiagram)dd);
            return (Diagram)representationQuery.getAssociatedGMFDiagram().get();
        });
        return optional;
    }

    private Session getOrOpenTargetSession(URI sessionResourceUri) {
        Session session = SessionManager.INSTANCE.getExistingSession(sessionResourceUri);
        if (session == null) {
            ModelingProjectManager.INSTANCE.loadAndOpenRepresentationsFile(sessionResourceUri, true);
            try {
                Job.getJobManager().join((Object)"org.eclipse.sirius.representationsFile", (IProgressMonitor)new NullProgressMonitor());
            }
            catch (InterruptedException interruptedException) {}
            session = SessionManager.INSTANCE.getExistingSession(sessionResourceUri);
        }
        return session;
    }

    private SiriusDiagramEditor searchEditor(URIEditorInput editorInput) {
        SiriusDiagramEditor result = null;
        IEditorReference[] editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int i = 0;
        while (i < editorReferences.length && result == null) {
            try {
                URIEditorInput currentEditorInput;
                if (editorReferences[i].getEditor(false) instanceof SiriusDiagramEditor && editorReferences[i].getEditorInput() instanceof URIEditorInput && (currentEditorInput = (URIEditorInput)editorReferences[i].getEditorInput()).equals((Object)editorInput)) {
                    result = (SiriusDiagramEditor)editorReferences[i].getEditor(false);
                }
            }
            catch (PartInitException partInitException) {}
            ++i;
        }
        return result;
    }

    public static IMarker addMarker(IFile file, String elementId, String diagramDescriptorURI, String semanticURI, String location, String message, int statusSeverity) {
        IMarker marker = SiriusMarkerNavigationProvider.addMarker(file, elementId, location, message, statusSeverity);
        try {
            marker.setAttribute("DIAGRAM_DESCRIPTOR_URI", (Object)diagramDescriptorURI);
            marker.setAttribute("SEMANTIC_URI", (Object)semanticURI);
            marker.setAttribute("org.eclipse.ui.editorID", (Object)"org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
        }
        catch (CoreException e) {
            DiagramPlugin.getDefault().logError(Messages.SiriusMarkerNavigationProvider_validationMarkerCreationError, (Throwable)e);
        }
        return marker;
    }

    public static IMarker addValidationRuleMarker(ValidationRule validationRule, IFile file, String elementId, String diagramDescriptorUri, String semanticURI, String location, String message, int statusSeverity) {
        IMarker marker = SiriusMarkerNavigationProvider.addValidationRuleMarker(validationRule, file, elementId, location, message, statusSeverity);
        try {
            marker.setAttribute("DIAGRAM_DESCRIPTOR_URI", (Object)diagramDescriptorUri);
            marker.setAttribute("SEMANTIC_URI", (Object)semanticURI);
            marker.setAttribute("org.eclipse.ui.editorID", (Object)"org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
        }
        catch (CoreException e) {
            DiagramPlugin.getDefault().logError(Messages.SiriusMarkerNavigationProvider_validationMarkerCreationError, (Throwable)e);
        }
        return marker;
    }

    public static EObject resolveTargetSemanticElement(Diagram diagram) {
        EObject semanticDiagram = diagram.getElement();
        if (semanticDiagram instanceof DSemanticDiagram) {
            return ((DSemanticDiagram)semanticDiagram).getTarget();
        }
        return null;
    }

    public static DSemanticDiagram resolveSemanticElement(Diagram diagram) {
        EObject semanticDiagram = diagram.getElement();
        if (semanticDiagram instanceof DSemanticDiagram) {
            return (DSemanticDiagram)semanticDiagram;
        }
        return null;
    }
}

