/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.providers;

import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.sirius.diagram.tools.api.DiagramPlugin;
import org.eclipse.sirius.diagram.ui.internal.providers.AbstractModelMarkerNavigationProvider;
import org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorUtil;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.viewpoint.description.validation.ValidationRule;

public class SiriusMarkerNavigationProvider
extends AbstractModelMarkerNavigationProvider {
    public static final String MARKER_TYPE = "org.eclipse.sirius.diagram.ui.diagnostic";

    protected void doGotoMarker(IMarker marker) {
        String elementId = marker.getAttribute("elementId", null);
        if (elementId == null || !(this.getEditor() instanceof DiagramEditor)) {
            return;
        }
        DiagramEditor editor = (DiagramEditor)this.getEditor();
        Map editPartRegistry = editor.getDiagramGraphicalViewer().getEditPartRegistry();
        Diagram diagram = editor.getDiagram();
        if (diagram == null) {
            return;
        }
        EObject targetView = diagram.eResource().getEObject(elementId);
        if (targetView == null) {
            return;
        }
        EditPart targetEditPart = (EditPart)editPartRegistry.get(targetView);
        if (targetEditPart != null) {
            SiriusDiagramEditorUtil.selectElementsInDiagram((IDiagramWorkbenchPart)editor, Arrays.asList(targetEditPart));
        }
    }

    public static void deleteMarkers(IResource resource) {
        try {
            resource.deleteMarkers(MARKER_TYPE, true, 0);
        }
        catch (CoreException e) {
            DiagramPlugin.getDefault().logError("Failed to delete validation markers", (Throwable)e);
        }
    }

    public static IMarker addMarker(IFile file, String elementId, String location, String message, int statusSeverity) {
        IMarker marker = null;
        try {
            marker = file.createMarker(MARKER_TYPE);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("location", (Object)location);
            marker.setAttribute("elementId", (Object)elementId);
            int markerSeverity = 0;
            if (statusSeverity == 2) {
                markerSeverity = 1;
            } else if (statusSeverity == 4 || statusSeverity == 8) {
                markerSeverity = 2;
            }
            marker.setAttribute("severity", markerSeverity);
        }
        catch (CoreException e) {
            DiagramPlugin.getDefault().logError(Messages.SiriusMarkerNavigationProvider_validationMarkerCreationError, (Throwable)e);
        }
        return marker;
    }

    public static IMarker addValidationRuleMarker(ValidationRule validationRule, IFile file, String elementId, String location, String message, int statusSeverity) {
        IMarker marker = null;
        try {
            marker = file.createMarker(MARKER_TYPE);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("location", (Object)location);
            marker.setAttribute("rule", (Object)EcoreUtil.getURI((EObject)validationRule).toString());
            marker.setAttribute("elementId", (Object)elementId);
            int markerSeverity = 0;
            if (statusSeverity == 2) {
                markerSeverity = 1;
            } else if (statusSeverity == 4 || statusSeverity == 8) {
                markerSeverity = 2;
            }
            marker.setAttribute("severity", markerSeverity);
        }
        catch (CoreException e) {
            DiagramPlugin.getDefault().logError(Messages.SiriusMarkerNavigationProvider_validationMarkerCreationError, (Throwable)e);
        }
        return marker;
    }
}

