/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.edit.policies;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DragDropEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.business.api.resource.support.WorkspaceDragAndDropSupport;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.business.internal.metamodel.operations.DDiagramElementContainerWithInterpreterOperations;
import org.eclipse.sirius.diagram.description.DragAndDropTargetDescription;
import org.eclipse.sirius.diagram.description.tool.ContainerDropDescription;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactoryProvider;
import org.eclipse.sirius.diagram.ui.business.internal.command.AddLayoutDataToManageCommand;
import org.eclipse.sirius.diagram.ui.business.internal.query.RequestQuery;
import org.eclipse.sirius.diagram.ui.business.internal.view.RootLayoutData;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramBorderNodeEditPart;
import org.eclipse.sirius.diagram.ui.graphical.edit.internal.policies.validators.DragAndDropValidator;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDNodeContainerCompartmentEditPart;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.command.GMFCommandWrapper;
import org.eclipse.sirius.diagram.ui.tools.api.draw2d.ui.figures.FigureUtilities;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.internal.dnd.DragAndDropWrapper;
import org.eclipse.sirius.diagram.ui.tools.internal.util.EditPartQuery;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.tool.DragSource;
import org.eclipse.swt.graphics.Color;

public class SiriusContainerDropPolicy
extends DragDropEditPolicy {
    public static final String DROP_ELEMENTS_CMD_NAME = Messages.SiriusContainerDropPolicy_dropElementsCommandLabel;
    private static final Color GRAY = new Color(null, 200, 200, 200);
    private IFigure figure;
    private WeakReference<Request> weakLastRequest;
    private WeakReference<org.eclipse.gef.commands.Command> weakLastCommand;

    public void showTargetFeedback(Request request) {
        org.eclipse.gef.commands.Command c = null;
        if (this.weakLastRequest != null && request.equals(this.weakLastRequest.get()) && this.weakLastCommand != null) {
            c = (org.eclipse.gef.commands.Command)this.weakLastCommand.get();
        }
        if (c == null && (c = this.getCommand(request)) != null && !"drop".equals(request.getType())) {
            this.addCommandInWeakCache(request, c);
        }
        if (c != null && c.canExecute() && this.revertColor == null) {
            if (this.getHostFigure() instanceof BorderedNodeFigure) {
                Rectangle intersection;
                Rectangle bounds = this.getHostFigure().getBounds().getCopy();
                this.getHostFigure().translateToAbsolute((Translatable)bounds);
                IFigure rootFigure = ((AbstractGraphicalEditPart)this.getHost().getRoot()).getFigure();
                Point searchPoint = bounds.getCenter();
                if (!rootFigure.getBounds().contains(searchPoint) && !(intersection = rootFigure.getBounds().getIntersection(bounds)).isEmpty()) {
                    searchPoint = intersection.getCenter();
                }
                this.figure = rootFigure.findFigureAt(searchPoint);
                this.revertColor = this.figure.getBackgroundColor();
                this.opacity = this.figure.isOpaque();
                this.figure.setBackgroundColor(org.eclipse.draw2d.FigureUtilities.mixColors((Color)GRAY, (Color)this.revertColor));
                this.figure.setOpaque(true);
            } else {
                this.revertColor = this.getHostFigure().getBackgroundColor();
                this.opacity = this.getHostFigure().isOpaque();
                this.getHostFigure().setBackgroundColor(org.eclipse.draw2d.FigureUtilities.mixColors((Color)GRAY, (Color)this.revertColor));
                this.getHostFigure().setOpaque(true);
            }
        }
    }

    private void addCommandInWeakCache(Request request, org.eclipse.gef.commands.Command command) {
        this.weakLastRequest = new WeakReference<Request>(request);
        this.weakLastCommand = new WeakReference<org.eclipse.gef.commands.Command>(command);
    }

    public void eraseTargetFeedback(Request request) {
        if (this.revertColor != null) {
            if (this.getHostFigure() instanceof BorderedNodeFigure) {
                this.figure.setBackgroundColor(this.revertColor);
                this.figure.setOpaque(this.opacity);
                this.figure = null;
            } else {
                this.getHostFigure().setBackgroundColor(this.revertColor);
                this.getHostFigure().setOpaque(this.opacity);
            }
            this.revertColor = null;
        }
    }

    private IDiagramCommandFactoryProvider getIEMFCommandFactoryProvider() {
        DDiagramEditor diagramEditor = (DDiagramEditor)this.getHost().getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
        Object adapter = diagramEditor.getAdapter(IDiagramCommandFactoryProvider.class);
        IDiagramCommandFactoryProvider cmdFactoryProvider = (IDiagramCommandFactoryProvider)adapter;
        return cmdFactoryProvider;
    }

    protected org.eclipse.gef.commands.Command getDropCommand(final ChangeBoundsRequest request) {
        if (this.weakLastRequest != null && request.equals(this.weakLastRequest.get()) && this.weakLastCommand != null && this.weakLastCommand.get() != null) {
            return (org.eclipse.gef.commands.Command)this.weakLastCommand.get();
        }
        Object dropCommand = null;
        EditPart hostEditPart = this.getHost();
        if (hostEditPart instanceof org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart) {
            org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart hostGraphicalEditPart = (org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)hostEditPart;
            final TransactionalEditingDomain editingDomain = hostGraphicalEditPart.getEditingDomain();
            EObject hostSemanticElement = hostGraphicalEditPart.resolveSemanticElement();
            if (hostSemanticElement instanceof DragAndDropTarget) {
                final DragAndDropTarget targetDragAndDropTarget = (DragAndDropTarget)hostSemanticElement;
                final DragAndDropValidator validator = new DragAndDropValidator();
                validator.setTargetDragAndDropTarget(targetDragAndDropTarget);
                if (validator.isValid(request, hostGraphicalEditPart)) {
                    Point absoluteRequestLocation = request.getLocation().getCopy();
                    absoluteRequestLocation = this.computeSnap(request, hostGraphicalEditPart, absoluteRequestLocation);
                    GraphicalHelper.screen2logical((Point)absoluteRequestLocation, (GraphicalEditPart)hostGraphicalEditPart);
                    final Point locationRelativeToNewContainer = this.computeRelativeLocation(absoluteRequestLocation, false, new RequestQuery((Request)request).isDropOrCreationOfBorderNode() || validator.isConcerningOnlyBorderNodeFromView());
                    dropCommand = new org.eclipse.gef.commands.Command(DROP_ELEMENTS_CMD_NAME){
                        private org.eclipse.gef.commands.Command innerDropCommand;

                        public void execute() {
                            this.innerDropCommand = SiriusContainerDropPolicy.this.buildCommand(validator, request, targetDragAndDropTarget, locationRelativeToNewContainer, editingDomain);
                            if (this.innerDropCommand != null && this.innerDropCommand.canExecute()) {
                                this.innerDropCommand.execute();
                            }
                            SiriusContainerDropPolicy.this.weakLastRequest = null;
                            SiriusContainerDropPolicy.this.weakLastCommand = null;
                        }

                        public void undo() {
                            if (this.innerDropCommand != null) {
                                this.innerDropCommand.undo();
                            }
                        }

                        public void redo() {
                            if (this.innerDropCommand != null) {
                                this.innerDropCommand.redo();
                            }
                        }
                    };
                } else {
                    dropCommand = UnexecutableCommand.INSTANCE;
                }
            }
        }
        this.addCommandInWeakCache((Request)request, (org.eclipse.gef.commands.Command)dropCommand);
        return dropCommand;
    }

    private Point computeSnap(ChangeBoundsRequest request, org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart hostGraphicalEditPart, Point absoluteRequestLocation) {
        if (hostGraphicalEditPart != null) {
            EditPartQuery editPartQuery = new EditPartQuery((IGraphicalEditPart)hostGraphicalEditPart);
            return editPartQuery.getSnapLocation((Request)request, absoluteRequestLocation);
        }
        return absoluteRequestLocation;
    }

    private org.eclipse.gef.commands.Command buildCommand(DragAndDropValidator validator, ChangeBoundsRequest request, DragAndDropTarget targetDragAndDropTarget, Point adaptedRequestLocation, TransactionalEditingDomain editingDomain) {
        ICommandProxy result = null;
        Set<DragAndDropWrapper> elementsFromEclipseViewToDrop = validator.getElementsFromEclipseViewToDrop();
        Set<DDiagramElement> elementsFromDiagramToDrop = validator.getElementsFromDiagramToDrop();
        Set<IGraphicalEditPart> editPartsFromDiagramToDrop = validator.getEditPartsFromDiagramToDrop();
        IDiagramCommandFactoryProvider diagramFactoryProvider = this.getIEMFCommandFactoryProvider();
        IDiagramCommandFactory diagramCommandFactory = diagramFactoryProvider.getCommandFactory(editingDomain);
        DragAndDropTargetDescription dragDragAndDropDescription = validator.getDragDragAndDropDescription();
        EObject targetAbstractDNodeSemanticTarget = validator.getTargetAbstractDNodeSemanticTarget();
        CompoundCommand command = new CompoundCommand(DROP_ELEMENTS_CMD_NAME);
        for (DragAndDropWrapper elementFromEclipseViewToDrop : elementsFromEclipseViewToDrop) {
            if (!(elementFromEclipseViewToDrop.getObject() instanceof StructuredSelection)) continue;
            StructuredSelection structuredSelection = (StructuredSelection)elementFromEclipseViewToDrop.getObject();
            for (Object next : structuredSelection) {
                ContainerDropDescription dropTool;
                Session session;
                EObject droppedElementForDropTool = new WorkspaceDragAndDropSupport().convert(next, session = SessionManager.INSTANCE.getSession(targetAbstractDNodeSemanticTarget));
                Command buildDropInContainerCommandFromTool = diagramCommandFactory.buildDropInContainerCommandFromTool(targetDragAndDropTarget, droppedElementForDropTool, dropTool = DDiagramElementContainerWithInterpreterOperations.getBestDropDescription((DragAndDropTargetDescription)dragDragAndDropDescription, (EObject)droppedElementForDropTool, null, (EObject)targetAbstractDNodeSemanticTarget, (EObject)targetDragAndDropTarget, (DragSource)DragSource.PROJECT_EXPLORER_LITERAL, null));
                Command cmd = buildDropInContainerCommandFromTool;
                if (cmd == null || !cmd.canExecute()) continue;
                command.append(cmd);
            }
            RootLayoutData abstractLayoutData = new RootLayoutData(this.getHost(), adaptedRequestLocation, new Dimension(-1, -1));
            AddLayoutDataToManageCommand addLayoutDataToManageCommand = new AddLayoutDataToManageCommand(abstractLayoutData);
            if (addLayoutDataToManageCommand == null || !addLayoutDataToManageCommand.canExecute()) continue;
            command.append((Command)addLayoutDataToManageCommand);
        }
        for (DDiagramElement elementFromDiagramToDrop : elementsFromDiagramToDrop) {
            Command saveLayoutCommand;
            ContainerDropDescription dropTool;
            Command cmd = diagramCommandFactory.buildDropInContainerCommandFromTool(targetDragAndDropTarget, elementFromDiagramToDrop, dropTool = DDiagramElementContainerWithInterpreterOperations.getBestDropDescription((DragAndDropTargetDescription)dragDragAndDropDescription, (EObject)elementFromDiagramToDrop.getTarget(), (EObject)SiriusContainerDropPolicy.getSemanticContainer(elementFromDiagramToDrop), (EObject)targetAbstractDNodeSemanticTarget, (EObject)targetDragAndDropTarget, (DragSource)DragSource.DIAGRAM_LITERAL, (EObject)elementFromDiagramToDrop));
            if (cmd != null && cmd.canExecute()) {
                command.append(cmd);
            }
            if ((saveLayoutCommand = this.getSaveLayoutCommand(request, editPartsFromDiagramToDrop, editingDomain)) == null || !saveLayoutCommand.canExecute()) continue;
            command.append(saveLayoutCommand);
        }
        if (command != null && command.canExecute()) {
            result = new ICommandProxy((ICommand)new GMFCommandWrapper(editingDomain, (Command)command));
        }
        return result;
    }

    private static EObject getSemanticContainer(DDiagramElement diagramElement) {
        EObject semanticContainer = null;
        EObject current = diagramElement.eContainer();
        while (current != null && semanticContainer == null) {
            if (current instanceof DSemanticDecorator) {
                semanticContainer = ((DSemanticDecorator)current).getTarget();
            }
            current = current.eContainer();
        }
        return semanticContainer;
    }

    private Command getSaveLayoutCommand(ChangeBoundsRequest request, Iterable<IGraphicalEditPart> editPartsToDrop, TransactionalEditingDomain editingDomain) {
        CompoundCommand saveLayoutCommand = new CompoundCommand(Messages.SiriusContainerDropPolicy_saveEditPartLayoutCommandLabel);
        EditPartViewer viewer = this.getHost().getViewer();
        Point moveDelta = request.getMoveDelta().getCopy();
        boolean isConcernedBorderNode = new RequestQuery((Request)request).isDropOrCreationOfBorderNode();
        Map borderNodeLocationForDDiagramElement = null;
        Object requestData = request.getExtendedData().get("borderNodesRealLocation");
        if (requestData instanceof Map) {
            borderNodeLocationForDDiagramElement = (Map)requestData;
        }
        request.getExtendedData().put("borderNodesRealLocation", null);
        for (IGraphicalEditPart editPart : editPartsToDrop) {
            ShapeEditPart shapeEditPart;
            EObject adaptObject;
            if (!(editPart instanceof ShapeEditPart) || !((adaptObject = (shapeEditPart = (ShapeEditPart)editPart).resolveSemanticElement()) instanceof AbstractDNode)) continue;
            AbstractDNode abstractDNode = (AbstractDNode)adaptObject;
            Point absoluteLayoutConstraint = shapeEditPart.getFigure().getBounds().getTopLeft().getCopy();
            shapeEditPart.getFigure().translateToAbsolute((Translatable)absoluteLayoutConstraint);
            GraphicalHelper.screen2logical((Point)absoluteLayoutConstraint, (GraphicalEditPart)((IGraphicalEditPart)this.getHost()));
            Point scaledMoveDelta = moveDelta.getScaled(1.0 / GraphicalHelper.getZoom((EditPart)this.getHost()));
            absoluteLayoutConstraint.translate(scaledMoveDelta);
            boolean isBorderNode = editPart instanceof AbstractDiagramBorderNodeEditPart;
            if (isBorderNode && borderNodeLocationForDDiagramElement != null && borderNodeLocationForDDiagramElement.get(abstractDNode) != null) {
                Point borderNodeFeedbackLocation = ((Point)borderNodeLocationForDDiagramElement.get(abstractDNode)).getScaled(1.0 / GraphicalHelper.getZoom((EditPart)this.getHost()));
                Dimension deltaBetweenProposedAndRealLocation = borderNodeFeedbackLocation.getDifference(absoluteLayoutConstraint);
                scaledMoveDelta.translate(deltaBetweenProposedAndRealLocation.width, deltaBetweenProposedAndRealLocation.height);
                absoluteLayoutConstraint = borderNodeFeedbackLocation;
            }
            Point computedLayoutConstraint = this.computeRelativeLocation(absoluteLayoutConstraint, isBorderNode, isConcernedBorderNode);
            RootLayoutData abstractLayoutData = new RootLayoutData(abstractDNode, shapeEditPart, viewer, computedLayoutConstraint, scaledMoveDelta);
            AddLayoutDataToManageCommand addLayoutDataToManageCommand = new AddLayoutDataToManageCommand(abstractLayoutData);
            saveLayoutCommand.append((Command)addLayoutDataToManageCommand);
        }
        return saveLayoutCommand;
    }

    private Point computeRelativeLocation(Point absolutePointerLocation, boolean isBorderNode, boolean isConcernedBorderedNode) {
        if (absolutePointerLocation != null && this.getHost() instanceof IGraphicalEditPart) {
            Dimension difference;
            IFigure hostFigure = ((IGraphicalEditPart)this.getHost()).getFigure();
            if (this.getHost() instanceof DiagramEditPart) {
                difference = new Dimension(absolutePointerLocation.x, absolutePointerLocation.y);
            } else {
                Point topLeftHostLocation = hostFigure.getBounds().getTopLeft().getCopy();
                if (topLeftHostLocation.x == -1) {
                    topLeftHostLocation.setX(0);
                }
                hostFigure.translateToAbsolute((Translatable)topLeftHostLocation);
                GraphicalHelper.screen2logical((Point)topLeftHostLocation, (GraphicalEditPart)((IGraphicalEditPart)this.getHost()));
                difference = absolutePointerLocation.getDifference(topLeftHostLocation);
            }
            Point locationHint = new Point(difference.width, difference.height);
            if (hostFigure instanceof ResizableCompartmentFigure && this.getHost() instanceof AbstractDNodeContainerCompartmentEditPart && !isBorderNode) {
                Point scrollOffset = ((ResizableCompartmentFigure)hostFigure).getScrollPane().getViewport().getViewLocation();
                Point shiftFromMarginOffset = FigureUtilities.getShiftFromMarginOffset((ResizableCompartmentFigure)hostFigure, isConcernedBorderedNode, this.getHost());
                locationHint = new Point(locationHint.x + scrollOffset.x - shiftFromMarginOffset.x, locationHint.y + scrollOffset.y - shiftFromMarginOffset.y);
            }
            return locationHint;
        }
        return null;
    }
}

