/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.util.EventFinder;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation.ConnectionAnchorOperation;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation.ExecutionOperations;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation.SequenceEditPartsOperations;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.ExecutionEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.ISequenceEventEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy.ExecutionSemanticEditPolicy;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy.SequenceLaunchToolEditPolicy;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.RequestQuery;
import org.eclipse.sirius.diagram.sequence.util.Range;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNode2EditPart;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;

public abstract class AbstractSequenceBorderedEditPart
extends DNode2EditPart
implements ISequenceEventEditPart {
    public AbstractSequenceBorderedEditPart(View view) {
        super(view);
    }

    public void addNotify() {
        SequenceEditPartsOperations.registerDiagramElement((IGraphicalEditPart)this, (EObject)this.resolveDiagramElement());
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
        SequenceEditPartsOperations.unregisterDiagramElement((IGraphicalEditPart)this, (EObject)this.resolveDiagramElement());
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new ExecutionSemanticEditPolicy());
        ExecutionOperations.installExecutionAwareNodeCreationPolicy(this);
        this.installEditPolicy("launchTool", (EditPolicy)new SequenceLaunchToolEditPolicy());
    }

    protected NodeFigure createMainFigure() {
        NodeFigure figure = super.createMainFigure();
        ExecutionOperations.adjustFigureSlidableArea(figure);
        return figure;
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        ConnectionAnchor anchor = super.getSourceConnectionAnchor(request);
        if (new RequestQuery(request).isSequenceMessageCreation()) {
            anchor = ConnectionAnchorOperation.getSourceConnectionAnchor(this, request, anchor);
        }
        return anchor;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        boolean sequenceMessageCreation = new RequestQuery(request).isSequenceMessageCreation();
        if (sequenceMessageCreation && request instanceof DropRequest) {
            ConnectionAnchorOperation.matchRequestYLocationWithSourceAnchor((DropRequest)request);
        }
        ConnectionAnchor anchor = super.getTargetConnectionAnchor(request);
        if (sequenceMessageCreation) {
            anchor = ConnectionAnchorOperation.getTargetConnectionAnchor(this, request, anchor);
        }
        return anchor;
    }

    public EditPart getTargetEditPart(Request request) {
        HashSet retargetTypes = Sets.newHashSet((Object[])new String[]{"create child", "connection start", "connection end"});
        if (retargetTypes.contains(request.getType()) && request instanceof CreateRequest) {
            Map editPartRegistry;
            Object obj;
            CreateRequest createRequest = (CreateRequest)request;
            Point location = createRequest.getLocation().getCopy();
            GraphicalHelper.screen2logical((Point)location, (GraphicalEditPart)this);
            Range insertionPoint = new Range(location.y, location.y);
            ISequenceEvent sequenceEvent = this.getISequenceEvent();
            EventFinder eventFinder = new EventFinder(sequenceEvent, (Lifeline)sequenceEvent.getLifeline().get());
            ISequenceEvent mostSpecificSequenceEvent = eventFinder.findMostSpecificEvent(insertionPoint);
            if (mostSpecificSequenceEvent instanceof AbstractNodeEvent && !sequenceEvent.equals(mostSpecificSequenceEvent) && (obj = (editPartRegistry = this.getTopGraphicEditPart().getViewer().getEditPartRegistry()).get(mostSpecificSequenceEvent.getNotationView())) instanceof ExecutionEditPart) {
                ExecutionEditPart targetEditPart = (ExecutionEditPart)obj;
                return targetEditPart;
            }
        }
        return super.getTargetEditPart(request);
    }
}

