/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.actions.analysis;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.resource.AirdResource;
import org.eclipse.sirius.tools.api.command.semantic.RemoveSemanticResourceCommand;
import org.eclipse.sirius.viewpoint.DAnalysisSessionEObject;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class RemoveSemanticResourceAction
extends Action {
    private static final String DELIMITER = ", ";
    private Session session;
    private Collection<Resource> toRemove;

    public RemoveSemanticResourceAction(Collection<Resource> selection, Session session) {
        super(Messages.RemoveSemanticResourceAction_name);
        this.session = session;
        this.toRemove = new ArrayList<Resource>(selection);
    }

    public boolean isEnabled() {
        boolean res = super.isEnabled();
        res = res && this.session != null;
        res = res && !this.toRemove.isEmpty();
        return res;
    }

    private boolean isExternalDependency(Resource resource, IProject sourceProject) {
        String platformString = resource.getURI().toPlatformString(true);
        if (platformString != null) {
            IProject resourceProject = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformString)).getProject();
            return !sourceProject.equals((Object)resourceProject);
        }
        return true;
    }

    public void run() {
        Map<ErrorKind, Set<Resource>> errorKindToResource = this.checkAllResourcesAreRemovable();
        if (errorKindToResource.isEmpty()) {
            CompoundCommand compoundCommand = new CompoundCommand();
            for (Resource semanticResourceToRemove : this.toRemove) {
                compoundCommand.append((Command)new RemoveSemanticResourceCommand(this.session, semanticResourceToRemove, (IProgressMonitor)new NullProgressMonitor(), true));
            }
            TransactionalEditingDomain transDomain = this.session.getTransactionalEditingDomain();
            transDomain.getCommandStack().execute((Command)compoundCommand);
        } else {
            Set<Map.Entry<ErrorKind, Set<Resource>>> errorKindToResourceEntrySet = errorKindToResource.entrySet();
            String errorMessage = "";
            for (Map.Entry<ErrorKind, Set<Resource>> errorKindToResourceEntry : errorKindToResourceEntrySet) {
                switch (errorKindToResourceEntry.getKey()) {
                    case NOT_EXTERNAL_DEPENDENCY_FOR_MODELING_PROJECT: {
                        errorMessage = this.getErrorString(errorMessage, ErrorKind.NOT_EXTERNAL_DEPENDENCY_FOR_MODELING_PROJECT.getMessage(), errorKindToResourceEntry);
                        break;
                    }
                    case ACTIVE_REPRESENTATION: {
                        errorMessage = this.getErrorString(errorMessage, ErrorKind.ACTIVE_REPRESENTATION.getMessage(), errorKindToResourceEntry);
                        break;
                    }
                    case CONTROLLED_RESOURCE: {
                        errorMessage = this.getErrorString(errorMessage, ErrorKind.CONTROLLED_RESOURCE.getMessage(), errorKindToResourceEntry);
                        break;
                    }
                }
            }
            String finalErrorMessage = errorMessage;
            Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.RemoveSemanticResourceAction_Error_Removal_Title, (String)finalErrorMessage));
        }
    }

    private String getErrorString(String errorMessage, String sourceMessage, Map.Entry<ErrorKind, Set<Resource>> errorKindToResourceEntry) {
        String resultMessage = errorMessage;
        if (!resultMessage.isEmpty()) {
            resultMessage = String.valueOf(resultMessage) + "\n\n";
        }
        resultMessage = String.valueOf(resultMessage) + MessageFormat.format(sourceMessage, errorKindToResourceEntry.getValue().stream().map(r -> r.getURI().lastSegment()).collect(Collectors.joining(DELIMITER)));
        return resultMessage;
    }

    private Map<ErrorKind, Set<Resource>> checkAllResourcesAreRemovable() {
        HashMap<ErrorKind, Set<Resource>> errorKindToResource = new HashMap<ErrorKind, Set<Resource>>();
        Set dSemanticDecoratorsEResources = DialectManager.INSTANCE.getAllRepresentations(this.session).stream().filter(rep -> rep instanceof DSemanticDecorator).map(rep -> ((DSemanticDecorator)rep).getTarget() == null ? null : ((DSemanticDecorator)rep).getTarget().eResource()).collect(Collectors.toSet());
        for (Resource semanticResourceToRemove : this.toRemove) {
            IFile airdFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.session.getSessionResource().getURI().toPlatformString(true)));
            if (airdFile != null) {
                IProject project = airdFile.getProject();
                boolean executeRemoval = !ModelingProject.hasModelingProjectNature((IProject)project) || semanticResourceToRemove instanceof AirdResource;
                boolean bl = executeRemoval = executeRemoval || this.isExternalDependency(semanticResourceToRemove, airdFile.getProject());
                if (!executeRemoval) {
                    HashSet<Resource> notExternalResource = (HashSet<Resource>)errorKindToResource.get((Object)ErrorKind.NOT_EXTERNAL_DEPENDENCY_FOR_MODELING_PROJECT);
                    if (notExternalResource == null) {
                        notExternalResource = new HashSet<Resource>();
                        errorKindToResource.put(ErrorKind.NOT_EXTERNAL_DEPENDENCY_FOR_MODELING_PROJECT, notExternalResource);
                    }
                    notExternalResource.add(semanticResourceToRemove);
                }
            }
            if (!(semanticResourceToRemove instanceof AirdResource) && ((DAnalysisSessionEObject)this.session).getControlledResources().contains((Object)semanticResourceToRemove)) {
                HashSet<Resource> controlledResources = (HashSet<Resource>)errorKindToResource.get((Object)ErrorKind.CONTROLLED_RESOURCE);
                if (controlledResources == null) {
                    controlledResources = new HashSet<Resource>();
                    errorKindToResource.put(ErrorKind.CONTROLLED_RESOURCE, controlledResources);
                }
                controlledResources.add(semanticResourceToRemove);
            }
            if (semanticResourceToRemove instanceof AirdResource || !dSemanticDecoratorsEResources.contains(semanticResourceToRemove)) continue;
            HashSet<Resource> resourcesWithActiveRepresentations = (HashSet<Resource>)errorKindToResource.get((Object)ErrorKind.ACTIVE_REPRESENTATION);
            if (resourcesWithActiveRepresentations == null) {
                resourcesWithActiveRepresentations = new HashSet<Resource>();
                errorKindToResource.put(ErrorKind.ACTIVE_REPRESENTATION, resourcesWithActiveRepresentations);
            }
            resourcesWithActiveRepresentations.add(semanticResourceToRemove);
        }
        return errorKindToResource;
    }

    private static enum ErrorKind {
        CONTROLLED_RESOURCE(Messages.RemoveSemanticResourceAction_Controlled_Resources_Message),
        NOT_EXTERNAL_DEPENDENCY_FOR_MODELING_PROJECT(Messages.RemoveSemanticResourceAction_Not_External_Dependency_Message),
        ACTIVE_REPRESENTATION(Messages.RemoveSemanticResourceAction_Active_Representation_Message);

        private String message;

        private ErrorKind(String theMessage) {
            this.message = theMessage;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

