/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.tabbedproperties.sections;

import org.eclipse.emf.ecoretools.tabbedproperties.sections.AbstractTabbedPropertySection;
import org.eclipse.emf.ecoretools.tabbedproperties.utils.TextChangeListener;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractTextPropertySection
extends AbstractTabbedPropertySection {
    private Text text;
    private CLabel nameLabel;
    private TextChangeListener listener;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
    }

    protected void createWidgets(Composite composite) {
        this.text = this.getWidgetFactory().createText(composite, "", this.getStyle());
        if (this.getFeature() != null) {
            boolean isChangeable = this.getFeature().isChangeable();
            this.text.setEditable(isChangeable);
            this.text.setEnabled(isChangeable);
        }
        this.nameLabel = this.getWidgetFactory().createCLabel(composite, this.getLabelText());
    }

    protected void setSectionData(Composite composite) {
        FormData data = new FormData();
        data.left = new FormAttachment(0, this.getStandardLabelWidth(composite, new String[]{this.getLabelText()}));
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        data.bottom = new FormAttachment(100, 0);
        this.text.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.text, -5);
        data.top = new FormAttachment((Control)this.text, 0, 128);
        this.nameLabel.setLayoutData((Object)data);
    }

    protected void hookListeners() {
        this.listener = new TextChangeListener(){

            public void textChanged(Control control) {
                AbstractTextPropertySection.this.handleTextModified();
            }

            public void focusIn(Control control) {
                AbstractTextPropertySection.this.focusIn();
            }

            public void focusOut(Control control) {
                AbstractTextPropertySection.this.focusOut();
            }
        };
        this.listener.startListeningTo((Control)this.text);
        if ((this.getStyle() & 2) == 0) {
            this.listener.startListeningForEnter((Control)this.text);
        }
        this.text.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                AbstractTextPropertySection.this.verifyField(e);
            }
        });
    }

    public void refresh() {
        this.getText().setEnabled(!this.isReadOnly());
        this.getText().setText(this.getFeatureAsString());
    }

    protected void handleTextModified() {
        if (this.isTextValid()) {
            this.createCommand(this.getOldFeatureValue(), this.getNewFeatureValue(this.getText().getText()));
        } else {
            this.refresh();
        }
    }

    protected void focusIn() {
    }

    protected void focusOut() {
    }

    protected int getStyle() {
        return 4;
    }

    protected TextChangeListener getListener() {
        return this.listener;
    }

    protected Text getText() {
        return this.text;
    }

    public CLabel getNameLabel() {
        return this.nameLabel;
    }

    protected boolean isTextValid() {
        return true;
    }

    protected abstract String getFeatureAsString();

    protected abstract Object getNewFeatureValue(String var1);

    protected abstract Object getOldFeatureValue();

    protected abstract void verifyField(Event var1);
}

