/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.properties.internal.metadata;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecoretools.properties.internal.Messages;
import org.eclipse.emf.ecoretools.tabbedproperties.EMFRecordingChangeCommand;
import org.eclipse.emf.ecoretools.tabbedproperties.sections.AbstractTabbedPropertySection;
import org.eclipse.emf.ecoretools.tabbedproperties.utils.TextChangeListener;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class FractionDigitsSection
extends AbstractTabbedPropertySection {
    private boolean isRefreshing = false;
    private Text fractionTxt;
    private CLabel labelTxt;

    protected void createWidgets(Composite composite) {
        this.labelTxt = this.getWidgetFactory().createCLabel(composite, this.getLabelText());
        this.fractionTxt = this.getWidgetFactory().createText(composite, "");
    }

    protected void setSectionData(Composite composite) {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fractionTxt, -5);
        data.top = new FormAttachment(0, 4);
        this.labelTxt.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, this.getStandardLabelWidth(composite, new String[]{this.getLabelText()}));
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.labelTxt, 0, 0x1000000);
        this.fractionTxt.setLayoutData((Object)data);
    }

    protected void hookListeners() {
        TextChangeListener listener = new TextChangeListener(){

            public void textChanged(Control control) {
                FractionDigitsSection.this.handleTextModified();
            }
        };
        listener.startListeningTo((Control)this.fractionTxt);
        listener.startListeningForEnter((Control)this.fractionTxt);
    }

    protected void handleTextModified() {
        if (!this.isRefreshing) {
            try {
                if (this.fractionTxt.getText() == null || this.fractionTxt.getText().length() == 0) {
                    this.fractionTxt.setText("-1");
                }
                final int newFraction = Integer.parseInt(this.fractionTxt.getText());
                EditingDomain editingDomain = this.getEditingDomain();
                if (this.getEObjectList().size() == 1) {
                    int oldFraction = ExtendedMetaData.INSTANCE.getFractionDigitsFacet((EDataType)this.getEObject());
                    if (oldFraction != newFraction) {
                        editingDomain.getCommandStack().execute((Command)new EMFRecordingChangeCommand(this.getEObject().eResource()){

                            protected void doExecute() {
                                ExtendedMetaData.INSTANCE.setFractionDigitsFacet((EDataType)FractionDigitsSection.this.getEObject(), newFraction);
                            }
                        });
                    }
                } else {
                    CompoundCommand compoundCommand = new CompoundCommand();
                    for (final EObject nextObject : this.getEObjectList()) {
                        int oldFraction = ExtendedMetaData.INSTANCE.getFractionDigitsFacet((EDataType)nextObject);
                        if (oldFraction == newFraction) continue;
                        editingDomain.getCommandStack().execute((Command)new EMFRecordingChangeCommand(nextObject.eResource()){

                            protected void doExecute() {
                                ExtendedMetaData.INSTANCE.setFractionDigitsFacet((EDataType)nextObject, newFraction);
                            }
                        });
                    }
                    editingDomain.getCommandStack().execute((Command)compoundCommand);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.refresh();
            }
        }
    }

    public void refresh() {
        this.isRefreshing = true;
        this.fractionTxt.setText("" + ExtendedMetaData.INSTANCE.getFractionDigitsFacet((EDataType)this.getEObject()));
        this.isRefreshing = false;
    }

    protected EStructuralFeature getFeature() {
        return null;
    }

    protected String getLabelText() {
        return Messages.FractionDigitsSection_FractionDigits;
    }
}

