/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.diagram.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecoretools.diagram.navigator.EcoreAbstractNavigatorItem;
import org.eclipse.emf.ecoretools.diagram.navigator.EcoreNavigatorGroup;
import org.eclipse.emf.ecoretools.diagram.navigator.EcoreNavigatorItem;
import org.eclipse.emf.ecoretools.diagram.part.EcoreVisualIDRegistry;
import org.eclipse.emf.ecoretools.diagram.part.Messages;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

public class EcoreNavigatorContentProvider
implements ICommonContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Viewer myViewer;
    private AdapterFactoryEditingDomain myEditingDomain;
    private WorkspaceSynchronizer myWorkspaceSynchronizer;
    private Runnable myViewerRefreshRunnable;

    public EcoreNavigatorContentProvider() {
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        this.myEditingDomain = (AdapterFactoryEditingDomain)editingDomain;
        this.myEditingDomain.setResourceToReadOnlyMap((Map)new HashMap(){
            private static final long serialVersionUID = 1L;

            public Object get(Object key) {
                if (!this.containsKey(key)) {
                    this.put(key, Boolean.TRUE);
                }
                return super.get(key);
            }
        });
        this.myViewerRefreshRunnable = new Runnable(){

            public void run() {
                if (EcoreNavigatorContentProvider.this.myViewer != null) {
                    EcoreNavigatorContentProvider.this.myViewer.refresh();
                }
            }
        };
        this.myWorkspaceSynchronizer = new WorkspaceSynchronizer(editingDomain, new WorkspaceSynchronizer.Delegate(){

            public void dispose() {
            }

            public boolean handleResourceChanged(Resource resource) {
                for (Resource nextResource : EcoreNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (EcoreNavigatorContentProvider.this.myViewer != null) {
                    EcoreNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(EcoreNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }

            public boolean handleResourceDeleted(Resource resource) {
                for (Resource nextResource : EcoreNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (EcoreNavigatorContentProvider.this.myViewer != null) {
                    EcoreNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(EcoreNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }

            public boolean handleResourceMoved(Resource resource, URI newURI) {
                for (Resource nextResource : EcoreNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (EcoreNavigatorContentProvider.this.myViewer != null) {
                    EcoreNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(EcoreNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }
        });
    }

    public void dispose() {
        this.myWorkspaceSynchronizer.dispose();
        this.myWorkspaceSynchronizer = null;
        this.myViewerRefreshRunnable = null;
        for (Resource resource : this.myEditingDomain.getResourceSet().getResources()) {
            resource.unload();
        }
        ((TransactionalEditingDomain)this.myEditingDomain).dispose();
        this.myEditingDomain = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.myViewer = viewer;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public Object[] getChildren(Object parentElement) {
        View view;
        if (parentElement instanceof IFile) {
            IFile file = (IFile)parentElement;
            URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            Resource resource = this.myEditingDomain.getResourceSet().getResource(fileURI, true);
            ArrayList result = new ArrayList();
            result.addAll(this.createNavigatorItems(this.selectViewsByType((Collection)resource.getContents(), "EcoreTools"), file, false));
            return result.toArray();
        }
        if (parentElement instanceof EcoreNavigatorGroup) {
            EcoreNavigatorGroup group = (EcoreNavigatorGroup)((Object)parentElement);
            return group.getChildren();
        }
        if (parentElement instanceof EcoreNavigatorItem) {
            EcoreNavigatorItem navigatorItem = (EcoreNavigatorItem)((Object)parentElement);
            if (navigatorItem.isLeaf() || !this.isOwnView(navigatorItem.getView())) {
                return EMPTY_ARRAY;
            }
            return this.getViewChildren(navigatorItem.getView(), parentElement);
        }
        if (parentElement instanceof IAdaptable && (view = (View)((IAdaptable)parentElement).getAdapter(View.class)) != null) {
            return this.getViewChildren(view, parentElement);
        }
        return EMPTY_ARRAY;
    }

    private Object[] getViewChildren(View view, Object parentElement) {
        switch (EcoreVisualIDRegistry.getVisualID(view)) {
            case 79: {
                ArrayList<EcoreNavigatorGroup> result = new ArrayList<EcoreNavigatorGroup>();
                result.addAll(this.getForeignShortcuts((Diagram)view, parentElement));
                EcoreNavigatorGroup links = new EcoreNavigatorGroup(Messages.NavigatorGroupName_EPackage_79_links, "icons/linksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), 1001);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 1002);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 1003);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 1004);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 1005);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(view), 3001);
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(view), 3002);
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(view), 3003);
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                if (!links.isEmpty()) {
                    result.add(links);
                }
                return result.toArray();
            }
            case 1001: {
                ArrayList<EcoreNavigatorGroup> result = new ArrayList<EcoreNavigatorGroup>();
                EcoreNavigatorGroup incominglinks = new EcoreNavigatorGroup(Messages.NavigatorGroupName_EClass_1001_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                EcoreNavigatorGroup outgoinglinks = new EcoreNavigatorGroup(Messages.NavigatorGroupName_EClass_1001_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), 5001);
                connectedViews = this.getChildrenByType(connectedViews, 2001);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5002);
                connectedViews = this.getChildrenByType(connectedViews, 2002);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), 3001);
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), 3002);
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), 3002);
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), 3003);
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), 3003);
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 1002: {
                ArrayList<EcoreNavigatorGroup> result = new ArrayList<EcoreNavigatorGroup>();
                EcoreNavigatorGroup incominglinks = new EcoreNavigatorGroup(Messages.NavigatorGroupName_EPackage_1002_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), 5003);
                connectedViews = this.getChildrenByType(connectedViews, 2003);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5003);
                connectedViews = this.getChildrenByType(connectedViews, 2004);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5003);
                connectedViews = this.getChildrenByType(connectedViews, 2005);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), 3001);
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                return result.toArray();
            }
            case 1003: {
                ArrayList<EcoreNavigatorGroup> result = new ArrayList<EcoreNavigatorGroup>();
                EcoreNavigatorGroup incominglinks = new EcoreNavigatorGroup(Messages.NavigatorGroupName_EAnnotation_1003_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                EcoreNavigatorGroup outgoinglinks = new EcoreNavigatorGroup(Messages.NavigatorGroupName_EAnnotation_1003_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), 5007);
                connectedViews = this.getChildrenByType(connectedViews, 2007);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), 3001);
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), 3001);
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 1004: {
                ArrayList<EcoreNavigatorGroup> result = new ArrayList<EcoreNavigatorGroup>();
                EcoreNavigatorGroup incominglinks = new EcoreNavigatorGroup(Messages.NavigatorGroupName_EDataType_1004_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), 3001);
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), 3002);
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                return result.toArray();
            }
            case 1005: {
                ArrayList<EcoreNavigatorGroup> result = new ArrayList<EcoreNavigatorGroup>();
                EcoreNavigatorGroup incominglinks = new EcoreNavigatorGroup(Messages.NavigatorGroupName_EEnum_1005_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), 5008);
                connectedViews = this.getChildrenByType(connectedViews, 2006);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), 3001);
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), 3002);
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                return result.toArray();
            }
            case 2001: {
                ArrayList<EcoreNavigatorGroup> result = new ArrayList<EcoreNavigatorGroup>();
                EcoreNavigatorGroup incominglinks = new EcoreNavigatorGroup(Messages.NavigatorGroupName_EAttribute_2001_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), 3001);
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                return result.toArray();
            }
            case 2002: {
                ArrayList<EcoreNavigatorGroup> result = new ArrayList<EcoreNavigatorGroup>();
                EcoreNavigatorGroup incominglinks = new EcoreNavigatorGroup(Messages.NavigatorGroupName_EOperation_2002_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), 3001);
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                return result.toArray();
            }
            case 2003: {
                ArrayList<EcoreNavigatorGroup> result = new ArrayList<EcoreNavigatorGroup>();
                EcoreNavigatorGroup incominglinks = new EcoreNavigatorGroup(Messages.NavigatorGroupName_EClass_2003_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                EcoreNavigatorGroup outgoinglinks = new EcoreNavigatorGroup(Messages.NavigatorGroupName_EClass_2003_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), 5004);
                connectedViews = this.getChildrenByType(connectedViews, 2001);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5005);
                connectedViews = this.getChildrenByType(connectedViews, 2002);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), 3001);
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), 3002);
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), 3002);
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), 3003);
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), 3003);
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 2004: {
                ArrayList<EcoreNavigatorGroup> result = new ArrayList<EcoreNavigatorGroup>();
                EcoreNavigatorGroup incominglinks = new EcoreNavigatorGroup(Messages.NavigatorGroupName_EDataType_2004_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), 3001);
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), 3002);
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                return result.toArray();
            }
            case 2005: {
                ArrayList<EcoreNavigatorGroup> result = new ArrayList<EcoreNavigatorGroup>();
                EcoreNavigatorGroup incominglinks = new EcoreNavigatorGroup(Messages.NavigatorGroupName_EEnum_2005_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), 5006);
                connectedViews = this.getChildrenByType(connectedViews, 2006);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), 3001);
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), 3002);
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                return result.toArray();
            }
            case 2006: {
                ArrayList<EcoreNavigatorGroup> result = new ArrayList<EcoreNavigatorGroup>();
                EcoreNavigatorGroup incominglinks = new EcoreNavigatorGroup(Messages.NavigatorGroupName_EEnumLiteral_2006_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), 3001);
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                return result.toArray();
            }
            case 3001: {
                ArrayList<EcoreNavigatorGroup> result = new ArrayList<EcoreNavigatorGroup>();
                EcoreNavigatorGroup target = new EcoreNavigatorGroup(Messages.NavigatorGroupName_EAnnotationReferences_3001_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                EcoreNavigatorGroup source = new EcoreNavigatorGroup(Messages.NavigatorGroupName_EAnnotationReferences_3001_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), 1001);
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), 1002);
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), 1003);
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), 1004);
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), 1005);
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), 2001);
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), 2002);
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), 2003);
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), 2004);
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), 2005);
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), 2006);
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), 1003);
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
            case 3002: {
                ArrayList<EcoreNavigatorGroup> result = new ArrayList<EcoreNavigatorGroup>();
                EcoreNavigatorGroup target = new EcoreNavigatorGroup(Messages.NavigatorGroupName_EReference_3002_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                EcoreNavigatorGroup source = new EcoreNavigatorGroup(Messages.NavigatorGroupName_EReference_3002_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), 1001);
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), 1004);
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), 1005);
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), 2003);
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), 2004);
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), 2005);
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), 1001);
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), 2003);
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
            case 3003: {
                ArrayList<EcoreNavigatorGroup> result = new ArrayList<EcoreNavigatorGroup>();
                EcoreNavigatorGroup target = new EcoreNavigatorGroup(Messages.NavigatorGroupName_EClassESuperTypes_3003_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                EcoreNavigatorGroup source = new EcoreNavigatorGroup(Messages.NavigatorGroupName_EClassESuperTypes_3003_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), 1001);
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), 2003);
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), 1001);
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), 2003);
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
        }
        return EMPTY_ARRAY;
    }

    private Collection getLinksSourceByType(Collection edges, int visualID) {
        ArrayList<View> result = new ArrayList<View>();
        String type = EcoreVisualIDRegistry.getType(visualID);
        for (Edge nextEdge : edges) {
            View nextEdgeSource = nextEdge.getSource();
            if (!type.equals(nextEdgeSource.getType()) || !this.isOwnView(nextEdgeSource)) continue;
            result.add(nextEdgeSource);
        }
        return result;
    }

    private Collection getLinksTargetByType(Collection edges, int visualID) {
        ArrayList<View> result = new ArrayList<View>();
        String type = EcoreVisualIDRegistry.getType(visualID);
        for (Edge nextEdge : edges) {
            View nextEdgeTarget = nextEdge.getTarget();
            if (!type.equals(nextEdgeTarget.getType()) || !this.isOwnView(nextEdgeTarget)) continue;
            result.add(nextEdgeTarget);
        }
        return result;
    }

    private Collection getOutgoingLinksByType(Collection nodes, int visualID) {
        ArrayList result = new ArrayList();
        String type = EcoreVisualIDRegistry.getType(visualID);
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getSourceEdges(), type));
        }
        return result;
    }

    private Collection getIncomingLinksByType(Collection nodes, int visualID) {
        ArrayList result = new ArrayList();
        String type = EcoreVisualIDRegistry.getType(visualID);
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getTargetEdges(), type));
        }
        return result;
    }

    private Collection getChildrenByType(Collection nodes, int visualID) {
        ArrayList result = new ArrayList();
        String type = EcoreVisualIDRegistry.getType(visualID);
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getChildren(), type));
        }
        return result;
    }

    private Collection getDiagramLinksByType(Collection diagrams, int visualID) {
        ArrayList result = new ArrayList();
        String type = EcoreVisualIDRegistry.getType(visualID);
        for (Diagram nextDiagram : diagrams) {
            result.addAll(this.selectViewsByType((Collection)nextDiagram.getEdges(), type));
        }
        return result;
    }

    private Collection selectViewsByType(Collection views, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (View nextView : views) {
            if (!type.equals(nextView.getType()) || !this.isOwnView(nextView)) continue;
            result.add(nextView);
        }
        return result;
    }

    private boolean isOwnView(View view) {
        return "EcoreTools".equals(EcoreVisualIDRegistry.getModelID(view));
    }

    private Collection createNavigatorItems(Collection views, Object parent, boolean isLeafs) {
        ArrayList<EcoreNavigatorItem> result = new ArrayList<EcoreNavigatorItem>();
        Iterator it = views.iterator();
        while (it.hasNext()) {
            result.add(new EcoreNavigatorItem((View)it.next(), parent, isLeafs));
        }
        return result;
    }

    private Collection getForeignShortcuts(Diagram diagram, Object parent) {
        ArrayList<View> result = new ArrayList<View>();
        for (View nextView : diagram.getChildren()) {
            if (this.isOwnView(nextView) || nextView.getEAnnotation("Shortcut") == null) continue;
            result.add(nextView);
        }
        return this.createNavigatorItems(result, parent, false);
    }

    public Object getParent(Object element) {
        if (element instanceof EcoreAbstractNavigatorItem) {
            EcoreAbstractNavigatorItem abstractNavigatorItem = (EcoreAbstractNavigatorItem)((Object)element);
            return abstractNavigatorItem.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IFile || this.getChildren(element).length > 0;
    }
}

