/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.diagram.ui.outline.decorator;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecoretools.diagram.ui.outline.decorator.IMarkerReader;
import org.eclipse.emf.ecoretools.diagram.ui.outline.internal.Activator;
import org.eclipse.emf.ecoretools.diagram.ui.outline.internal.Messages;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;

public abstract class AbstractValidationMarkerReader
implements IMarkerReader {
    @Override
    public IStatus getStatus(EObject object) {
        MultiStatus status = new MultiStatus("org.eclipse.emf.ecoretools.diagram.ui.outline", 0, Messages.AbstractValidationMarkerReader_ValidationProblems, null);
        IMarker[] markers = this.getMarkers(object);
        int i = 0;
        while (i < markers.length) {
            IMarker marker = markers[i];
            IStatus markerStatus = this.getStatusForMarker(marker);
            if (markerStatus != null) {
                status.add(markerStatus);
            }
            ++i;
        }
        return status;
    }

    private IMarker[] getMarkers(EObject object) {
        ArrayList<IMarker> markerList = new ArrayList<IMarker>();
        ResourceSet set = object.eResource().getResourceSet();
        if (set != null) {
            ArrayList copiedResources = new ArrayList(set.getResources());
            for (Resource res : copiedResources) {
                IFile file = this.getFile(res);
                if (file == null) continue;
                String objectLocation = EMFCoreUtil.getQualifiedName((EObject)object, (boolean)true);
                try {
                    IMarker[] markers = file.findMarkers(this.getMarkerType(), true, 0);
                    int i = 0;
                    while (i < markers.length) {
                        IMarker marker = markers[i];
                        String locationAttribute = (String)marker.getAttribute("location");
                        if (locationAttribute != null && locationAttribute.equals(objectLocation)) {
                            markerList.add(marker);
                        } else if (locationAttribute != null && locationAttribute.startsWith(objectLocation)) {
                            markerList.add(marker);
                        }
                        ++i;
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
        return markerList.toArray(new IMarker[markerList.size()]);
    }

    private IStatus getStatusForMarker(IMarker marker) {
        Status result = null;
        try {
            Object severityAttribute = marker.getAttribute("severity");
            String message = (String)marker.getAttribute("message");
            if (severityAttribute != null && severityAttribute instanceof Integer) {
                if ((Integer)severityAttribute == 2) {
                    result = new Status(4, "org.eclipse.emf.ecoretools.diagram.ui.outline", 0, message, null);
                } else if ((Integer)severityAttribute == 1) {
                    result = new Status(2, "org.eclipse.emf.ecoretools.diagram.ui.outline", 0, message, null);
                }
            }
        }
        catch (CoreException ce) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecoretools.diagram.ui.outline", Messages.AbstractValidationMarkerReader_MarkerNotExist, (Throwable)ce));
        }
        return result;
    }

    private IFile getFile(Resource resource) {
        URI uri = resource.getURI();
        uri = resource.getResourceSet().getURIConverter().normalize(uri);
        String scheme = uri.scheme();
        if ("platform".equals(scheme) && uri.segmentCount() > 1 && "resource".equals(uri.segment(0))) {
            StringBuffer platformResourcePath = new StringBuffer();
            int j = 1;
            while (j < uri.segmentCount()) {
                platformResourcePath.append('/');
                platformResourcePath.append(uri.segment(j));
                ++j;
            }
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformResourcePath.toString()));
        }
        return null;
    }
}

