/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.diagram.edit.commands;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecoretools.diagram.Messages;
import org.eclipse.emf.ecoretools.diagram.edit.parts.EReferenceUtils;
import org.eclipse.emf.ecoretools.diagram.part.EcoreDiagramUpdater;
import org.eclipse.emf.ecoretools.diagram.part.EcoreLinkDescriptor;
import org.eclipse.emf.ecoretools.diagram.part.EcoreVisualIDRegistry;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetPropertyCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;

public class RestoreRelatedLinksCommand
extends AbstractTransactionalCommand {
    protected List<?> adapters;
    protected Diagram diagram;
    protected DiagramEditPart host;

    public RestoreRelatedLinksCommand(DiagramEditPart diagramEditPart, List<?> selection) {
        super(diagramEditPart.getEditingDomain(), Messages.RestoreRelatedLinksCommand_RestoreRelatedLinks, null);
        this.host = diagramEditPart;
        this.diagram = this.host.getDiagramView();
        this.adapters = selection;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        for (Object object : this.adapters) {
            if (object instanceof IAdaptable) {
                IAdaptable ad = (IAdaptable)object;
                View view = (View)ad.getAdapter(View.class);
                if (view == null) continue;
                this.refreshRelatedLinks(view);
                continue;
            }
            if (!(object instanceof View)) continue;
            this.refreshRelatedLinks((View)object);
        }
        return CommandResult.newOKCommandResult();
    }

    protected void createRelatedLinks(Collection<? extends EcoreLinkDescriptor> linkDescriptors, Map<EObject, View> domain2NotationMap) {
        this.mapModel((View)this.diagram, domain2NotationMap);
        for (EcoreLinkDescriptor ecoreLinkDescriptor : linkDescriptors) {
            EditPart sourceEditPart = this.getEditPart(ecoreLinkDescriptor.getSource(), domain2NotationMap);
            EditPart targetEditPart = this.getEditPart(ecoreLinkDescriptor.getDestination(), domain2NotationMap);
            if (sourceEditPart == null || targetEditPart == null) continue;
            CreateConnectionViewRequest.ConnectionViewDescriptor descriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor(ecoreLinkDescriptor.getSemanticAdapter(), null, -1, false, this.host.getDiagramPreferencesHint());
            CreateConnectionViewRequest ccr = new CreateConnectionViewRequest(descriptor);
            ccr.setType((Object)"connection start");
            ccr.setSourceEditPart(sourceEditPart);
            sourceEditPart.getCommand((Request)ccr);
            ccr.setTargetEditPart(targetEditPart);
            ccr.setType((Object)"connection end");
            Command cmd = targetEditPart.getCommand((Request)ccr);
            if (cmd == null || !cmd.canExecute()) continue;
            EReferenceUtils.executeCommand(cmd, (IGraphicalEditPart)this.host);
        }
    }

    protected EditPart getEditPart(EObject domainModelElement, Map<? extends EObject, ? extends View> domain2NotationMap) {
        View view = domain2NotationMap.get(domainModelElement);
        if (view != null) {
            return (EditPart)this.host.getViewer().getEditPartRegistry().get(view);
        }
        return null;
    }

    protected void refreshRelatedLinks(View notationView) {
        HashMap<EObject, View> domain2NotationMap = new HashMap<EObject, View>();
        Collection<? extends EcoreLinkDescriptor> linkDescriptors = this.getLinkDescriptorToProcess(notationView, domain2NotationMap);
        this.createRelatedLinks(linkDescriptors, domain2NotationMap);
    }

    protected Collection<? extends EcoreLinkDescriptor> getLinkDescriptorToProcess(View notationView, Map<EObject, View> domain2NotationMap) {
        Collection<? extends EcoreLinkDescriptor> linkDescriptors = this.collectPartRelatedLinks(notationView, domain2NotationMap);
        LinkedList<Edge> existingLinks = new LinkedList<Edge>();
        for (Object edge : notationView.getTargetEdges()) {
            if (!(edge instanceof Edge) || existingLinks.contains(edge)) continue;
            existingLinks.add((Edge)edge);
        }
        for (Object edge : notationView.getSourceEdges()) {
            if (!(edge instanceof Edge) || existingLinks.contains(edge)) continue;
            existingLinks.add((Edge)edge);
        }
        this.setViewVisible(existingLinks);
        Iterator linksIterator = existingLinks.iterator();
        while (linksIterator.hasNext()) {
            Edge nextDiagramLink = (Edge)linksIterator.next();
            int diagramLinkVisualID = EcoreVisualIDRegistry.getVisualID((View)nextDiagramLink);
            if (diagramLinkVisualID == -1) {
                if (nextDiagramLink.getSource() == null || nextDiagramLink.getTarget() == null) continue;
                linksIterator.remove();
                continue;
            }
            EObject diagramLinkObject = nextDiagramLink.getElement();
            EObject diagramLinkSrc = nextDiagramLink.getSource().getElement();
            EObject diagramLinkDst = nextDiagramLink.getTarget().getElement();
            Iterator<? extends EcoreLinkDescriptor> LinkDescriptorsIterator = linkDescriptors.iterator();
            while (LinkDescriptorsIterator.hasNext()) {
                EcoreLinkDescriptor nextLinkDescriptor = LinkDescriptorsIterator.next();
                if (diagramLinkObject != nextLinkDescriptor.getModelElement() || diagramLinkSrc != nextLinkDescriptor.getSource() || diagramLinkDst != nextLinkDescriptor.getDestination() || diagramLinkVisualID != nextLinkDescriptor.getVisualID()) continue;
                linksIterator.remove();
                LinkDescriptorsIterator.remove();
            }
        }
        return linkDescriptors;
    }

    protected void setViewVisible(Collection<? extends View> views) {
        for (View view : views) {
            SetPropertyCommand cmd;
            if (view.isVisible() || (cmd = new SetPropertyCommand(this.host.getEditingDomain(), Messages.RestoreRelatedLinksCommand_ShowView, (IAdaptable)new EObjectAdapter((EObject)view), Properties.ID_ISVISIBLE, (Object)Boolean.TRUE)) == null || !cmd.canExecute()) continue;
            EReferenceUtils.executeCommand((Command)new ICommandProxy((ICommand)cmd), (IGraphicalEditPart)this.host);
        }
    }

    protected Collection<? extends EcoreLinkDescriptor> collectPartRelatedLinks(View view, Map<EObject, View> domain2NotationMap) {
        LinkedList<EcoreLinkDescriptor> result = new LinkedList<EcoreLinkDescriptor>();
        switch (EcoreVisualIDRegistry.getVisualID(view)) {
            case 79: 
            case 1001: 
            case 1002: 
            case 1003: 
            case 1004: 
            case 1005: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 3002: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    List outgoingDescriptors = EcoreDiagramUpdater.getOutgoingLinks(view);
                    this.cleanAdd(result, outgoingDescriptors);
                    List incomingDescriptors = EcoreDiagramUpdater.getIncomingLinks(view);
                    this.cleanAdd(result, incomingDescriptors);
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
            }
        }
        return result;
    }

    private void cleanAdd(Collection<EcoreLinkDescriptor> result, List<?> descriptors) {
        for (Object object : descriptors) {
            EcoreLinkDescriptor descriptor;
            if (!(object instanceof EcoreLinkDescriptor) || this.cleanContains(result, descriptor = (EcoreLinkDescriptor)object)) continue;
            result.add(descriptor);
        }
    }

    private boolean cleanContains(Collection<? extends EcoreLinkDescriptor> result, EcoreLinkDescriptor eCoreLinkDescriptor) {
        for (EcoreLinkDescriptor ecoreLinkDescriptor : result) {
            EcoreLinkDescriptor descriptor;
            if (!(ecoreLinkDescriptor instanceof EcoreLinkDescriptor) || (descriptor = ecoreLinkDescriptor).getModelElement() != eCoreLinkDescriptor.getModelElement() || descriptor.getSource() != eCoreLinkDescriptor.getSource() || descriptor.getDestination() != eCoreLinkDescriptor.getDestination() || descriptor.getVisualID() != eCoreLinkDescriptor.getVisualID()) continue;
            return true;
        }
        return false;
    }

    protected void mapModel(View view, Map<EObject, View> domain2NotationMap) {
        if (!"EcoreTools".equals(EcoreVisualIDRegistry.getModelID(view))) {
            return;
        }
        switch (EcoreVisualIDRegistry.getVisualID(view)) {
            case 79: 
            case 1001: 
            case 1002: 
            case 1003: 
            case 1004: 
            case 1005: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 3002: {
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
            }
        }
        EList children = view.getChildren();
        for (View child : children) {
            this.mapModel(child, domain2NotationMap);
        }
        EList sourceEdges = view.getSourceEdges();
        for (View edge : sourceEdges) {
            this.mapModel(edge, domain2NotationMap);
        }
    }
}

