/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.tabbedproperties.internal.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public final class ColorRegistry {
    public static Color COLOR_ERROR = ColorRegistry.getInstance().get("255,128,128");
    public static Color COLOR_WARNING = ColorRegistry.getInstance().get("249,240,163");
    public static Color COLOR_INFO = ColorRegistry.getInstance().get("128,128,255");
    public static Color COLOR_BLACK = ColorRegistry.getInstance().get("0,0,0");
    public static Color COLOR_WHITE = ColorRegistry.getInstance().get("255,255,255");
    public static Color COLOR_RED = ColorRegistry.getInstance().get("255,0,0");
    public static Color COLOR_GREEN = ColorRegistry.getInstance().get("0,255,0");
    public static Color COLOR_BLUE = ColorRegistry.getInstance().get("0,0,255");
    public static Color COLOR_SOFT_GREY = ColorRegistry.getInstance().get("219,211,203");
    private static ColorRegistry _instance;
    protected Display _display;
    private Map<String, Color> _stringToColor = new HashMap<String, Color>(7);
    protected Runnable _displayRunnable = new Runnable(){

        @Override
        public void run() {
            ColorRegistry.this._clearCaches();
        }
    };

    public static ColorRegistry getInstance() {
        if (_instance == null) {
            _instance = new ColorRegistry();
        }
        return _instance;
    }

    private ColorRegistry() {
        this(Display.getCurrent());
    }

    private ColorRegistry(Display display) {
        Assert.isNotNull((Object)display);
        this._display = display;
        this.hookDisplayDispose();
    }

    private void hookDisplayDispose() {
        this._display.disposeExec(this._displayRunnable);
    }

    private void _clearCaches() {
        Collection<Color> colors = this._stringToColor.values();
        for (Color color : colors) {
            color.dispose();
        }
        this._stringToColor.clear();
    }

    public Color get(String symbolicName) {
        Assert.isNotNull((Object)symbolicName);
        if ("".equals(symbolicName)) {
            return new Color((Device)this._display, new RGB(0, 0, 0));
        }
        return this.get(StringConverter.asRGB((String)symbolicName));
    }

    public Color get(RGB rgb) {
        if (rgb == null) {
            return null;
        }
        String symbolicName = StringConverter.asString((RGB)rgb);
        Color result = this._stringToColor.get(symbolicName);
        if (result != null) {
            return result;
        }
        Color color = new Color((Device)this._display, rgb);
        this._stringToColor.put(symbolicName, color);
        return color;
    }
}

