/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ease.IHeaderParser;
import org.eclipse.ease.Logger;
import org.eclipse.ease.service.EngineDescription;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptService;

public class ScriptType {
    private static final String NAME = "name";
    private static final String DEFAULT_EXTENSION = "defaultExtension";
    private static final String BINDING = "binding";
    private static final String HEADER_PARSER = "headerParser";
    private static final String CONTENT_TYPE = "contentType";
    private final IConfigurationElement fConfigurationElement;

    public ScriptType(IConfigurationElement configurationElement) {
        this.fConfigurationElement = configurationElement;
    }

    public String getName() {
        return this.fConfigurationElement.getAttribute(NAME);
    }

    public String getDefaultExtension() {
        return this.fConfigurationElement.getAttribute(DEFAULT_EXTENSION);
    }

    public Collection<String> getContentTypes() {
        HashSet<String> result = new HashSet<String>();
        IConfigurationElement[] iConfigurationElementArray = this.fConfigurationElement.getChildren(BINDING);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement binding = iConfigurationElementArray[n2];
            result.add(binding.getAttribute(CONTENT_TYPE));
            ++n2;
        }
        return result;
    }

    public IHeaderParser getHeaderParser() {
        try {
            Object parser = this.fConfigurationElement.createExecutableExtension(HEADER_PARSER);
            if (parser instanceof IHeaderParser) {
                return (IHeaderParser)parser;
            }
        }
        catch (CoreException e) {
            Logger.logError("Could not instantiate header parser", e);
        }
        return null;
    }

    public List<EngineDescription> getEngines() {
        ArrayList<EngineDescription> engines = new ArrayList<EngineDescription>();
        IScriptService scriptService = ScriptService.getService();
        for (EngineDescription description : scriptService.getEngines()) {
            if (!description.getSupportedScriptTypes().contains(this)) continue;
            engines.add(description);
        }
        Collections.sort(engines, new Comparator<EngineDescription>(){

            @Override
            public int compare(EngineDescription o1, EngineDescription o2) {
                return o2.getPriority() - o1.getPriority();
            }
        });
        return engines;
    }
}

