/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.javascript.rhino;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.lang.javascript.rhino.BundleProxyClassLoader;
import org.eclipse.ease.lang.javascript.rhino.RhinoScriptEngine;

public class RhinoClassLoader
extends BundleProxyClassLoader {
    private static Map<IScriptEngine, URLClassLoader> REGISTERED_JARS = new HashMap<IScriptEngine, URLClassLoader>();

    public RhinoClassLoader() {
        super(Platform.getBundle((String)"org.mozilla.javascript"), RhinoClassLoader.class.getClassLoader());
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        Job currentJob = Job.getJobManager().currentJob();
        URLClassLoader classLoader = REGISTERED_JARS.get(currentJob);
        if (classLoader != null) {
            try {
                Class<?> clazz = classLoader.loadClass(name);
                if (clazz != null) {
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return super.findClass(name);
    }

    public static void registerURL(IScriptEngine engine, URL url) {
        if (!REGISTERED_JARS.containsKey(engine)) {
            REGISTERED_JARS.put(engine, URLClassLoader.newInstance(new URL[]{url}));
        } else {
            HashSet<URL> urls = new HashSet<URL>(Arrays.asList(REGISTERED_JARS.get(engine).getURLs()));
            urls.add(url);
            REGISTERED_JARS.put(engine, URLClassLoader.newInstance(urls.toArray(new URL[urls.size()])));
        }
    }

    public static void unregisterEngine(RhinoScriptEngine engine) {
        REGISTERED_JARS.remove((Object)engine);
    }
}

