/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.repository.impl;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ease.Logger;
import org.eclipse.ease.ui.Activator;
import org.eclipse.ease.ui.repository.IRepositoryFactory;
import org.eclipse.ease.ui.repository.IScript;
import org.eclipse.ease.ui.repository.IScriptLocation;
import org.eclipse.ease.ui.repository.IStorage;
import org.eclipse.ease.ui.repository.impl.RepositoryFactoryImpl;
import org.eclipse.ease.ui.scripts.repository.IRepositoryService;
import org.eclipse.ease.ui.scripts.repository.IScriptListener;
import org.eclipse.ease.ui.scripts.repository.impl.ParameterDelta;
import org.eclipse.ease.ui.scripts.repository.impl.ScriptRepositoryEvent;
import org.eclipse.ease.ui.scripts.repository.impl.UIIntegrationJob;
import org.eclipse.ease.ui.scripts.repository.impl.UpdateRepositoryJob;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.osgi.service.prefs.BackingStoreException;

public class RepositoryService
implements IRepositoryService {
    static final long UPDATE_URI_INTERVAL = 1000L;
    static final long UPDATE_SCRIPT_INTERVAL = 1000L;
    private static RepositoryService fInstance;
    private static final String CACHE_FILE_NAME = "script.repository";
    private static final long DEFAULT_DELAY = 0L;
    public static final long UPDATE_STREAM_INTERVAL = 0L;
    private IStorage fRepository = null;
    private final UpdateRepositoryJob fUpdateJob;
    private final Job fSaveJob = new Job("Save Script Repositories"){

        protected IStatus run(IProgressMonitor monitor) {
            IPath path = Activator.getDefault().getStateLocation().append(RepositoryService.CACHE_FILE_NAME);
            File file = path.toFile();
            ResourceSetImpl resSet = new ResourceSetImpl();
            Resource resource = resSet.createResource(URI.createFileURI((String)file.getAbsolutePath()));
            resource.getContents().add((Object)RepositoryService.this.fRepository);
            try {
                resource.save(Collections.emptyMap());
            }
            catch (IOException iOException) {
                Logger.logError((String)"Could not store script repositories");
            }
            return Status.OK_STATUS;
        }
    };
    private final ListenerList fListeners = new ListenerList();

    public static RepositoryService getInstance() {
        if (fInstance == null) {
            fInstance = new RepositoryService();
        }
        return fInstance;
    }

    private RepositoryService() {
        RepositoryFactoryImpl.init();
        IPath path = Activator.getDefault().getStateLocation().append(CACHE_FILE_NAME);
        File file = path.toFile();
        if (file != null) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.createResource(URI.createURI((String)file.toURI().toString()));
            try {
                resource.load(null);
                this.fRepository = (IStorage)resource.getContents().get(0);
            }
            catch (IOException iOException) {}
        }
        long updateDelay = 0L;
        if (this.fRepository == null) {
            this.fRepository = IRepositoryFactory.eINSTANCE.createStorage();
        } else {
            updateDelay = 0L;
        }
        new UIIntegrationJob(this);
        this.fUpdateJob = new UpdateRepositoryJob(this);
        this.fUpdateJob.schedule(updateDelay);
    }

    @Override
    public void update(boolean force) {
        if (force) {
            for (IScript script : this.getScripts()) {
                script.setTimestamp(0L);
            }
        }
        this.fUpdateJob.scheduleUpdate(0L);
    }

    @Override
    public void updateLocations() {
        for (IScriptLocation entry : this.getLocations()) {
            entry.setUpdatePending(true);
        }
        final IEclipsePreferences rootNode = InstanceScope.INSTANCE.getNode("org.eclipse.ease.ui");
        try {
            rootNode.accept(new IPreferenceNodeVisitor(){

                public boolean visit(IEclipsePreferences node) throws BackingStoreException {
                    if (rootNode.equals(node)) {
                        return true;
                    }
                    String storageLocation = node.get("location", "");
                    boolean found = false;
                    for (IScriptLocation location : RepositoryService.this.getLocations()) {
                        boolean recursive;
                        if (!location.getLocation().equals(storageLocation)) continue;
                        boolean defaultLocation = node.getBoolean("default", false);
                        if (defaultLocation != location.isDefault()) {
                            location.setDefault(defaultLocation);
                            RepositoryService.this.fUpdateJob.update(location);
                        }
                        if ((recursive = node.getBoolean("recursive", false)) != location.isRecursive()) {
                            location.setRecursive(recursive);
                            RepositoryService.this.fUpdateJob.update(location);
                        }
                        location.setUpdatePending(false);
                        found = true;
                        break;
                    }
                    if (!found) {
                        IScriptLocation location;
                        location = IRepositoryFactory.eINSTANCE.createScriptLocation();
                        location.setLocation(storageLocation);
                        location.setDefault(node.getBoolean("default", false));
                        location.setRecursive(node.getBoolean("recursive", false));
                        RepositoryService.this.fRepository.getEntries().add((Object)location);
                        RepositoryService.this.fUpdateJob.update(location);
                    }
                    return false;
                }
            });
            for (IScriptLocation entry : new HashSet<IScriptLocation>(this.getLocations())) {
                if (!entry.isUpdatePending()) continue;
                this.fRepository.getEntries().remove((Object)entry);
                this.fUpdateJob.update(entry);
            }
        }
        catch (BackingStoreException e) {
            Logger.logError((String)"Could not update script repository.", (Throwable)e);
        }
    }

    IStorage getRepository() {
        return this.fRepository;
    }

    @Override
    public IScript getScript(String name) {
        for (IScript script : this.getRepository().getScripts()) {
            if (!name.equals(script.getPath().toString())) continue;
            return script;
        }
        return null;
    }

    void save() {
        this.fSaveJob.cancel();
        this.fSaveJob.schedule(5000L);
    }

    private void notifyListeners(ScriptRepositoryEvent event) {
        Object[] objectArray = this.fListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IScriptListener)listener).notify(event);
            ++n2;
        }
    }

    @Override
    public Collection<IScript> getScripts() {
        return Collections.unmodifiableCollection(this.getRepository().getScripts());
    }

    @Override
    public void addScriptListener(IScriptListener listener) {
        this.fListeners.add((Object)listener);
    }

    @Override
    public void removeScriptListener(IScriptListener listener) {
        this.fListeners.remove((Object)listener);
    }

    @Override
    public Collection<IScriptLocation> getLocations() {
        return Collections.unmodifiableCollection(this.fRepository.getEntries());
    }

    void removeScript(IScript script) {
        for (IScriptLocation entry : this.fRepository.getEntries()) {
            if (entry.getScripts().remove((Object)script)) break;
        }
        this.notifyListeners(new ScriptRepositoryEvent(script, 4, null));
    }

    void updateScript(IScript script, Map<String, String> parameters) {
        HashMap<String, String> oldParameters = new HashMap<String, String>(script.getParameters());
        script.getScriptParameters().clear();
        script.getScriptParameters().putAll(parameters);
        HashMap<String, String> newParameters = new HashMap<String, String>(script.getParameters());
        if (!oldParameters.equals(newParameters)) {
            this.notifyListeners(new ScriptRepositoryEvent(script, 2, new ParameterDelta(oldParameters, newParameters)));
        }
        script.setUpdatePending(false);
    }

    void addScript(IScript script) {
        script.setUpdatePending(false);
        this.notifyListeners(new ScriptRepositoryEvent(script, 1, null));
    }

    @Override
    public IScriptLocation getDefaultLocation() {
        for (IScriptLocation entry : this.getLocations()) {
            if (!entry.isDefault()) continue;
            return entry;
        }
        return null;
    }
}

