/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.python;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.ease.AbstractCodeFactory;
import org.eclipse.ease.ICodeFactory;
import org.eclipse.ease.Logger;
import org.eclipse.ease.ScriptResult;
import org.eclipse.ease.lang.python.PythonHelper;
import org.eclipse.ease.modules.EnvironmentModule;
import org.eclipse.ease.modules.IEnvironment;
import org.eclipse.ease.modules.ModuleHelper;
import org.eclipse.ease.tools.StringTools;

public class PythonCodeFactory
extends AbstractCodeFactory {
    private static final List<String> RESERVED_KEYWORDS = Arrays.asList("and", "as", "assert", "break", "class", "continue", "def", "del", "elif", "else", "except", "exec", "finally", "for", "from", "global", "if", "import", "in", "is", "lambda", "not", "or", "pass", "print", "raise", "return", "try", "while", "with", "yield", "__import__", "abs", "all", "any", "ascii", "bin", "bool", "bytearray", "bytes", "callable", "chr", "classmethod", "compile", "complex", "delattr", "dict", "dir", "divmod", "enumerate", "eval", "exec", "filter", "float", "format", "frozenset", "getattr", "globals", "hasattr", "hash", "help", "hex", "id", "input", "int", "isinstance", "issubclass", "iter", "len", "list", "locals", "map", "max", "memoryview", "min", "next", "object", "oct", "open", "ord", "pow", "print", "property", "range", "repr", "reversed", "round", "set", "setattr", "slice", "sorted", "staticmethod", "str", "sum", "super", "tuple", "type", "vars", "zip");
    private static final List<Class<?>> PRIMITIVES = Arrays.asList(Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE, Character.TYPE);

    protected static String getPythonClassIdentifier(Class<?> cls) {
        if (PRIMITIVES.contains(cls)) {
            return String.format("gateway.jvm.%s", cls.getName());
        }
        return cls.getName();
    }

    private static String toSafeNameStatic(String name) {
        if (RESERVED_KEYWORDS.contains(name)) {
            return PythonCodeFactory.toSafeNameStatic(String.valueOf(name) + "_");
        }
        return name;
    }

    private static String indent(String code, String indentation) {
        if (code.isEmpty()) {
            return code;
        }
        return String.valueOf(indentation) + code.replaceAll("\n", "\n" + indentation).trim() + "\n";
    }

    protected static String buildArrayConversions(List<ICodeFactory.Parameter> parameters) {
        return parameters.stream().map(PythonCodeFactory::buildArrayConversion).collect(Collectors.joining(StringTools.LINE_DELIMITER));
    }

    protected static String buildArrayConversion(ICodeFactory.Parameter parameter) {
        StringBuilder builder = new StringBuilder();
        if (parameter.getClazz().isArray()) {
            String arrayType = PythonCodeFactory.getPythonClassIdentifier(parameter.getClazz().getComponentType());
            String variableName = PythonCodeFactory.toSafeNameStatic(parameter.getName());
            builder.append(String.format("if %s is not None:", variableName)).append(StringTools.LINE_DELIMITER);
            builder.append("    try:").append(StringTools.LINE_DELIMITER);
            builder.append(String.format("        tmp = gateway.new_array(%s, len(%s))", arrayType, variableName)).append(StringTools.LINE_DELIMITER);
            builder.append(String.format("        for index, value in enumerate(%s):", variableName)).append(StringTools.LINE_DELIMITER);
            builder.append("            tmp[index] = value").append(StringTools.LINE_DELIMITER);
            builder.append(String.format("        %s =  tmp", variableName)).append(StringTools.LINE_DELIMITER);
            builder.append("    except NameError:").append(StringTools.LINE_DELIMITER);
            builder.append("        pass").append(StringTools.LINE_DELIMITER);
        }
        return builder.toString();
    }

    private static String buildNumberConversions(List<ICodeFactory.Parameter> parameters) {
        StringBuilder builder = new StringBuilder();
        for (ICodeFactory.Parameter parameter : parameters) {
            if (!Double.TYPE.equals(parameter.getClazz()) && !Double.class.equals((Object)parameter.getClazz()) && !Float.TYPE.equals(parameter.getClazz()) && !Float.class.equals((Object)parameter.getClazz())) continue;
            builder.append(String.format("%s = float(%s)", parameter.getName(), parameter.getName()));
            builder.append(StringTools.LINE_DELIMITER);
        }
        return builder.toString();
    }

    protected String toSafeName(String name) {
        return PythonCodeFactory.toSafeNameStatic(name);
    }

    protected String createFieldWrapper(IEnvironment environment, String identifier, Field field) {
        StringBuilder pythonCode = new StringBuilder();
        pythonCode.append(String.format("import sys%n", new Object[0]));
        pythonCode.append(String.format("if \"py4j\" in sys.modules:%n", new Object[0]));
        pythonCode.append(String.format("    %s = py4j.java_gateway.get_field(%s, \"%s\")%n", field.getName(), identifier, field.getName()));
        pythonCode.append(String.format("else:%n", new Object[0]));
        pythonCode.append(String.format("    %s = %s.%s%n", field.getName(), identifier, field.getName()));
        return pythonCode.toString();
    }

    public String createFunctionWrapper(IEnvironment environment, String moduleVariable, Method method) {
        StringBuilder pythonCode = new StringBuilder();
        List parameters = ModuleHelper.getParameters((Method)method);
        StringBuilder methodSignature = new StringBuilder();
        StringBuilder methodCall = new StringBuilder();
        for (ICodeFactory.Parameter parameter : parameters) {
            methodSignature.append(", ").append(this.toSafeName(parameter.getName()));
            methodCall.append(", ").append(this.toSafeName(parameter.getName()));
            if (!parameter.isOptional()) continue;
            methodSignature.append(" = ").append(this.getDefaultValue(parameter));
        }
        if (methodSignature.length() > 2) {
            methodSignature.delete(0, 2);
            methodCall.delete(0, 2);
        }
        String body = this.buildMethodBody(parameters, method, moduleVariable, environment);
        for (String name : PythonCodeFactory.getMethodNames((Method)method)) {
            if (!this.isValidMethodName(name)) {
                Logger.error((String)"org.eclipse.ease.lang.python", (String)("The method name \"" + name + "\" from the module \"" + moduleVariable + "\" can not be wrapped because it's name is reserved"));
                continue;
            }
            if (name.isEmpty()) continue;
            pythonCode.append("def ").append(name).append('(').append((CharSequence)methodSignature).append("):\n");
            pythonCode.append(PythonCodeFactory.indent(body, "    "));
            pythonCode.append('\n');
            pythonCode.append(name).append(".__ease__ = True\n");
            pythonCode.append('\n');
        }
        return pythonCode.toString();
    }

    private String buildMethodBody(List<ICodeFactory.Parameter> parameters, Method method, String classIdentifier, IEnvironment environment) {
        StringBuilder body = new StringBuilder();
        String methodId = environment.registerMethod(method);
        if (ModuleHelper.isDeprecated((AccessibleObject)method)) {
            body.append(String.format("%s.printError(\"%s() is deprecated. Consider updating your code.\", True)%n", EnvironmentModule.getWrappedVariableName((Object)environment), method.getName()));
        }
        body.append(PythonCodeFactory.buildArrayConversions(parameters)).append(StringTools.LINE_DELIMITER);
        body.append(PythonCodeFactory.buildNumberConversions(parameters)).append(StringTools.LINE_DELIMITER);
        body.append(String.format("if not %s.hasMethodCallback(\"%s\"):%n", EnvironmentModule.getWrappedVariableName((Object)environment), methodId));
        if (Objects.equals(Void.TYPE, method.getReturnType())) {
            body.append(String.format("    %s.%s(%s)%n", classIdentifier, method.getName(), this.buildParameterList(parameters)));
            body.append(String.format("    return %s.VOID%n", ScriptResult.class.getName()));
        } else {
            body.append(String.format("    return %s.%s(%s)%n", classIdentifier, method.getName(), this.buildParameterList(parameters)));
        }
        body.append(StringTools.LINE_DELIMITER);
        body.append("else:").append(StringTools.LINE_DELIMITER);
        if (environment.getScriptEngine().getDescription().getID().startsWith("org.eclipse.ease.lang.python.py4j")) {
            body.append("    ").append("parameters_array = gateway.new_array(gateway.jvm.Object, ").append(parameters.size()).append(")").append(StringTools.LINE_DELIMITER);
            int index = 0;
            while (index < parameters.size()) {
                body.append("    if ").append(this.toSafeName(parameters.get(index).getName())).append(" != None:").append(StringTools.LINE_DELIMITER);
                body.append("        ").append("parameters_array[").append(index).append("] = ").append(this.toSafeName(parameters.get(index).getName())).append(StringTools.LINE_DELIMITER);
                ++index;
            }
            body.append("    ").append(EnvironmentModule.getWrappedVariableName((Object)environment)).append(".preMethodCallback(\"").append(methodId).append("\", parameters_array)").append(StringTools.LINE_DELIMITER);
        } else {
            body.append("    ").append(EnvironmentModule.getWrappedVariableName((Object)environment)).append(".preMethodCallback(\"").append(methodId).append("\"").append(parameters.isEmpty() ? "" : ", ").append(this.buildParameterList(parameters)).append(")").append(StringTools.LINE_DELIMITER);
        }
        body.append("    ").append("__result").append(" = ").append(classIdentifier).append(".").append(method.getName()).append("(").append(this.buildParameterList(parameters)).append(")").append(StringTools.LINE_DELIMITER);
        body.append("    ").append(EnvironmentModule.getWrappedVariableName((Object)environment)).append(".postMethodCallback(\"").append(methodId).append("\"").append(", ").append("__result").append(")").append(StringTools.LINE_DELIMITER);
        if (Objects.equals(Void.TYPE, method.getReturnType())) {
            body.append(String.format("    return %s.VOID%n", ScriptResult.class.getName()));
        } else {
            body.append(String.format("    return %s%n", "__result"));
        }
        return body.toString();
    }

    public String getSaveVariableName(String variableName) {
        return PythonHelper.getSaveName(variableName);
    }

    public String classInstantiation(Class<?> clazz, String[] parameters) {
        StringBuilder code = new StringBuilder();
        code.append(clazz.getCanonicalName());
        code.append('(');
        if (parameters != null) {
            String[] stringArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                String parameter = stringArray[n2];
                code.append(parameter);
                code.append(", ");
                ++n2;
            }
            if (parameters.length > 0) {
                code.delete(code.length() - 2, code.length());
            }
        }
        code.append(')');
        return code.toString();
    }

    public boolean isValidMethodName(String methodName) {
        return PythonHelper.isSaveName(methodName) && !RESERVED_KEYWORDS.contains(methodName);
    }

    protected String getNullString() {
        return "None";
    }

    protected String getTrueString() {
        return "True";
    }

    protected String getFalseString() {
        return "False";
    }

    protected String getSingleLineCommentToken() {
        return "# ";
    }

    protected String getMultiLineCommentStartToken() {
        return "\"\"\"";
    }

    protected String getMultiLineCommentEndToken() {
        return this.getMultiLineCommentStartToken();
    }

    protected Object getLanguageIdentifier() {
        return "Python";
    }

    public String createPep302WrapperCode(EnvironmentModule environment, Object instance, String identifier) {
        return this.createWrapper((IEnvironment)environment, instance, identifier, false, environment.getScriptEngine());
    }
}

