/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.groovy.interpreter;

import groovy.lang.GroovyShell;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ease.AbstractReplScriptEngine;
import org.eclipse.ease.Script;
import org.eclipse.ease.classloader.EaseClassLoader;
import org.eclipse.ease.lang.groovy.interpreter.MultiClassLoader;

public class GroovyScriptEngine
extends AbstractReplScriptEngine {
    private EaseClassLoader fClassloader;
    private GroovyShell fEngine;

    public GroovyScriptEngine() {
        super("Groovy");
    }

    public void terminateCurrent() {
    }

    protected void setupEngine() {
        this.fClassloader = new EaseClassLoader();
        this.fEngine = new GroovyShell((ClassLoader)new MultiClassLoader(new ClassLoader[]{this.fClassloader, GroovyScriptEngine.class.getClassLoader()}));
        this.setOutputStream(this.getOutputStream());
        this.setErrorStream(this.getErrorStream());
    }

    public void setOutputStream(OutputStream outputStream) {
        super.setOutputStream(outputStream);
        if (this.fEngine != null) {
            this.fEngine.setProperty("out", (Object)this.getOutputStream());
        }
    }

    public void setErrorStream(OutputStream errorStream) {
        super.setErrorStream(errorStream);
        if (this.fEngine != null) {
            this.fEngine.setProperty("err", (Object)this.getErrorStream());
        }
    }

    protected void teardownEngine() {
    }

    protected Object execute(Script script, Object reference, String fileName, boolean uiThread) throws Exception {
        InputStreamReader reader = null;
        Object result = null;
        try {
            reader = new InputStreamReader(script.getCodeStream());
            result = fileName == null || fileName.isEmpty() ? this.fEngine.evaluate((Reader)reader) : this.fEngine.evaluate((Reader)reader, fileName);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    protected Object internalGetVariable(String name) {
        return this.fEngine.getContext().getVariable(name);
    }

    protected Map<String, Object> internalGetVariables() {
        return this.fEngine.getContext().getVariables();
    }

    protected boolean internalHasVariable(String name) {
        return this.fEngine.getContext().hasVariable(name);
    }

    protected void internalSetVariable(String name, Object content) {
        this.fEngine.getContext().setVariable(name, content);
    }

    public void registerJar(URL url) {
        this.fClassloader.registerURL((Job)this, url);
    }
}

