/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.debugging.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.ease.Script;
import org.eclipse.ease.debugging.dispatcher.EventDispatchJob;
import org.eclipse.ease.debugging.dispatcher.IEventProcessor;
import org.eclipse.ease.debugging.events.IDebugEvent;
import org.eclipse.ease.debugging.events.debugger.ScriptReadyEvent;
import org.eclipse.ease.debugging.events.debugger.ThreadCreatedEvent;
import org.eclipse.ease.debugging.events.debugger.ThreadTerminatedEvent;
import org.eclipse.ease.debugging.events.model.BreakpointRequest;
import org.eclipse.ease.debugging.events.model.ResumeRequest;
import org.eclipse.ease.debugging.events.model.TerminateRequest;
import org.eclipse.ease.debugging.model.EaseDebugElement;
import org.eclipse.ease.debugging.model.EaseDebugTarget;
import org.eclipse.ease.debugging.model.EaseDebugThread;

public class EaseDebugProcess
extends EaseDebugElement
implements IProcess,
IEventProcessor {
    private final Map<String, String> fAttributes = new HashMap<String, String>();
    private final List<EaseDebugThread> fThreads = new ArrayList<EaseDebugThread>();

    public EaseDebugProcess(EaseDebugTarget target) {
        super(target);
    }

    public String getLabel() {
        return "virtual Script Process";
    }

    public IStreamsProxy getStreamsProxy() {
        return null;
    }

    public void setAttribute(String key, String value) {
        this.fAttributes.put(key, value);
    }

    public String getAttribute(String key) {
        return this.fAttributes.get(key);
    }

    public int getExitValue() throws DebugException {
        return 0;
    }

    public String toString() {
        return this.getLabel();
    }

    @Override
    public synchronized void handleEvent(IDebugEvent event) {
        EaseDebugThread debugThread;
        if (event instanceof ScriptReadyEvent) {
            EaseDebugThread debugThread2 = this.findDebugThread(((ScriptReadyEvent)event).getThread());
            if (debugThread2 == null) {
                debugThread2 = this.createDebugThread(((ScriptReadyEvent)event).getThread());
            } else {
                debugThread2.fireChangeEvent(512);
            }
            this.setDeferredBreakpoints(((ScriptReadyEvent)event).getScript());
            if (this.getDebugTarget().isSuspendOnScriptLoad()) {
                debugThread2.stepInto();
            } else if (((ScriptReadyEvent)event).isRoot() && this.getDebugTarget().isSuspendOnStartup()) {
                debugThread2.stepInto();
            } else if (!debugThread2.getState().equals((Object)EaseDebugElement.State.STEPPING)) {
                debugThread2.resume();
            }
        } else if (event instanceof ThreadCreatedEvent) {
            EaseDebugThread debugThread3 = this.findDebugThread(((ThreadCreatedEvent)event).getThread());
            if (debugThread3 == null) {
                debugThread3 = this.createDebugThread(((ThreadCreatedEvent)event).getThread());
            }
        } else if (event instanceof ThreadTerminatedEvent && (debugThread = this.findDebugThread(((ThreadTerminatedEvent)event).getThread())) != null) {
            debugThread.handleEvent(event);
        }
    }

    public EaseDebugThread createDebugThread(Object thread) {
        EaseDebugThread debugThread = new EaseDebugThread(this.getDebugTarget(), thread);
        this.fThreads.add(debugThread);
        debugThread.fireCreationEvent();
        return debugThread;
    }

    @Override
    public void setDispatcher(EventDispatchJob dispatcher) {
    }

    public EaseDebugThread findDebugThread(Object thread) {
        for (EaseDebugThread debugThread : this.fThreads) {
            if (!thread.equals(debugThread.getThread())) continue;
            return debugThread;
        }
        return null;
    }

    private void setDeferredBreakpoints(Script script) {
        Object file = script.getFile();
        if (file instanceof IResource) {
            IBreakpoint[] breakpoints;
            IBreakpoint[] iBreakpointArray = breakpoints = this.getDebugTarget().getBreakpoints(script);
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint breakpoint = iBreakpointArray[n2];
                if (file.equals(breakpoint.getMarker().getResource())) {
                    this.getDebugTarget().fireDispatchEvent(new BreakpointRequest(script, breakpoint, BreakpointRequest.Mode.ADD));
                }
                ++n2;
            }
        }
    }

    public EaseDebugThread[] getThreads() {
        return this.fThreads.toArray(new EaseDebugThread[this.fThreads.size()]);
    }

    @Override
    public boolean canTerminate() {
        return !this.isTerminated();
    }

    @Override
    public synchronized void terminate() {
        this.getDebugTarget().fireDispatchEvent(new TerminateRequest());
    }

    @Override
    public boolean isTerminated() {
        return EaseDebugElement.State.TERMINATED == this.getState();
    }

    public void setTerminated() {
        this.setState(EaseDebugElement.State.TERMINATED);
    }

    @Override
    public boolean canDisconnect() {
        return this.canTerminate();
    }

    @Override
    public synchronized void disconnect() {
        this.getDebugTarget().fireDispatchEvent(new BreakpointRequest(BreakpointRequest.Mode.REMOVE));
        EaseDebugThread[] easeDebugThreadArray = this.getThreads();
        int n = easeDebugThreadArray.length;
        int n2 = 0;
        while (n2 < n) {
            EaseDebugThread thread = easeDebugThreadArray[n2];
            if (thread.isSuspended()) {
                this.getDebugTarget().fireDispatchEvent(new ResumeRequest(32, thread.getThread()));
            }
            ++n2;
        }
        this.getDebugTarget().cleanupOnTermination();
    }

    @Override
    public boolean isDisconnected() {
        return this.isTerminated();
    }
}

