/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.view;

import java.util.HashSet;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.ease.IExecutionListener;
import org.eclipse.ease.IReplEngine;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Script;
import org.eclipse.ease.debugging.model.EaseDebugLastExecutionResult;
import org.eclipse.ease.debugging.model.EaseDebugTarget;
import org.eclipse.ease.debugging.model.EaseDebugVariable;
import org.eclipse.ease.ui.Messages;
import org.eclipse.ease.ui.debugging.model.AbstractEaseDebugModelPresentation;
import org.eclipse.ease.ui.view.IShellDropin;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;

public class VariablesDropin
implements IShellDropin,
IExecutionListener {
    private TreeViewer fVariablesTree = null;
    private IScriptEngine fEngine;

    @Override
    public void setScriptEngine(IScriptEngine engine) {
        if (this.fEngine != null) {
            this.fEngine.removeExecutionListener((IExecutionListener)this);
        }
        this.fEngine = engine;
        if (this.fEngine != null) {
            this.fEngine.addExecutionListener((IExecutionListener)this);
        }
        if (this.fVariablesTree != null) {
            this.fVariablesTree.setInput((Object)engine);
            Display.getDefault().asyncExec(() -> this.fVariablesTree.refresh());
        }
    }

    @Override
    public Composite createPartControl(IWorkbenchPartSite site, Composite parent) {
        Composite composite = new Composite(parent, 0);
        TreeColumnLayout treeColumnLayout = new TreeColumnLayout();
        composite.setLayout((Layout)treeColumnLayout);
        this.fVariablesTree = new TreeViewer(composite, 2048);
        Tree tree = this.fVariablesTree.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.fVariablesTree.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof EaseDebugVariable) {
                    return !((EaseDebugVariable)element).getName().startsWith("__EASE_");
                }
                return true;
            }
        }});
        this.fVariablesTree.setComparator(new ViewerComparator(){

            public int category(Object element) {
                return element instanceof EaseDebugLastExecutionResult ? 1 : 2;
            }
        });
        this.fVariablesTree.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element).length > 0;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof IReplEngine) {
                    EaseDebugTarget debugTarget = new EaseDebugTarget(null, false, false, false){

                        protected IBreakpoint[] getBreakpoints(Script script) {
                            return null;
                        }

                        public boolean supportsBreakpoint(IBreakpoint breakpoint) {
                            return false;
                        }
                    };
                    HashSet<EaseDebugVariable> variables = new HashSet<EaseDebugVariable>(((IReplEngine)inputElement).getDefinedVariables());
                    EaseDebugVariable lastScriptResult = ((IReplEngine)inputElement).getLastExecutionResult();
                    variables.add(lastScriptResult);
                    for (EaseDebugVariable entry : variables) {
                        entry.setParent((IDebugElement)debugTarget);
                    }
                    return variables.toArray();
                }
                return new Object[0];
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof EaseDebugVariable) {
                    return ((EaseDebugVariable)parentElement).getValue().getVariables();
                }
                return new Object[0];
            }
        });
        TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.fVariablesTree, 0);
        TreeColumn column = treeViewerColumn.getColumn();
        treeColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1));
        column.setText(Messages.VariablesDropin_name);
        treeViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){
            private final AbstractEaseDebugModelPresentation fDebugModelPresentation = new AbstractEaseDebugModelPresentation(){};

            public String getText(Object element) {
                if (element instanceof EaseDebugVariable) {
                    return ((EaseDebugVariable)element).getName();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                return this.fDebugModelPresentation.getImage(element);
            }
        });
        TreeViewerColumn treeViewerColumn2 = new TreeViewerColumn(this.fVariablesTree, 0);
        TreeColumn column2 = treeViewerColumn2.getColumn();
        treeColumnLayout.setColumnData((Widget)column2, (ColumnLayoutData)new ColumnWeightData(1));
        column2.setText(Messages.VariablesDropin_value);
        treeViewerColumn2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof EaseDebugVariable) {
                    return ((EaseDebugVariable)element).getValue().getValueString();
                }
                return super.getText(element);
            }
        });
        this.fVariablesTree.setInput((Object)this.fEngine);
        return composite;
    }

    @Override
    public String getTitle() {
        return Messages.VariablesDropin_variables;
    }

    public void notify(IScriptEngine engine, Script script, int status) {
        switch (status) {
            case 4: {
                Display.getDefault().asyncExec(() -> this.fVariablesTree.refresh());
                break;
            }
            case 2: {
                engine.removeExecutionListener((IExecutionListener)this);
            }
        }
    }
}

