/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.repository.impl;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ease.Logger;
import org.eclipse.ease.ui.scripts.repository.IRepositoryService;
import org.eclipse.ease.ui.scripts.repository.IScriptLocation;
import org.eclipse.ease.ui.scripts.repository.impl.InputStreamParser;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class PluginParser
extends InputStreamParser {
    public void parse(Object content, IScriptLocation location) {
        File root;
        Path path;
        if (content instanceof URI && (path = new Path(((URI)content).getPath())).segmentCount() >= 2 && "plugin".equals(path.segment(0)) && (root = this.getBundleLocation(path.segment(1))) != null) {
            Path rootPath = new Path(root.getAbsolutePath());
            IPath subFolder = path.removeFirstSegments(2);
            rootPath = rootPath.append(subFolder);
            if (root != null && root.exists()) {
                if (root.isDirectory()) {
                    this.parseFolder(rootPath.toFile(), (IPath)path, location);
                } else {
                    try {
                        this.parseJar(new ZipFile(root), path, location, root.lastModified());
                    }
                    catch (Exception e) {
                        Logger.error((String)"org.eclipse.ease.ui.scripts", (String)("Cannot parse plugin jar: " + root.getName()));
                    }
                }
            }
        }
    }

    private void parseJar(ZipFile file, Path path, IScriptLocation location, long lastModified) {
        IRepositoryService repositoryService = (IRepositoryService)PlatformUI.getWorkbench().getService(IRepositoryService.class);
        IPath pluginFolder = path.removeFirstSegments(2);
        Enumeration<? extends ZipEntry> elements = file.entries();
        while (elements.hasMoreElements()) {
            ZipEntry entry = elements.nextElement();
            if (entry.isDirectory()) continue;
            if (!pluginFolder.isEmpty()) {
                if (!pluginFolder.isPrefixOf((IPath)new Path(entry.getName()))) continue;
                repositoryService.updateLocation(location, "platform:" + path.removeLastSegments(path.segmentCount() - 2).append(entry.getName()), lastModified);
                continue;
            }
            repositoryService.updateLocation(location, "platform:" + path.append(entry.getName()), lastModified);
        }
    }

    private void parseFolder(File entry, IPath path, IScriptLocation location) {
        if (entry.isDirectory()) {
            File[] fileArray = entry.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isFile() || location.isRecursive()) {
                    this.parseFolder(child, path.append(child.getName()), location);
                }
                ++n2;
            }
        } else {
            IRepositoryService repositoryService = (IRepositoryService)PlatformUI.getWorkbench().getService(IRepositoryService.class);
            repositoryService.updateLocation(location, "platform:" + path.toString(), entry.lastModified());
        }
    }

    private File getBundleLocation(String pluginName) {
        Bundle bundle = Platform.getBundle((String)pluginName);
        try {
            if (bundle != null) {
                return FileLocator.getBundleFile((Bundle)bundle);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

