/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.dnd;

import org.eclipse.ease.ICodeFactory;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Logger;
import org.eclipse.ease.modules.EnvironmentModule;
import org.eclipse.ease.modules.IEnvironment;
import org.eclipse.ease.modules.ModuleHelper;
import org.eclipse.ease.service.ScriptService;
import org.eclipse.ease.ui.dnd.IShellDropHandler;

public abstract class AbstractModuleDropHandler
implements IShellDropHandler {
    protected Object loadModule(IScriptEngine scriptEngine, String moduleID, boolean force) {
        IEnvironment environment = IEnvironment.getEnvironment((IScriptEngine)scriptEngine);
        if (environment != null) {
            if (force || environment.getModule(moduleID) == null) {
                if (ModuleHelper.resolveName((String)moduleID) != null) {
                    ICodeFactory codeFactory = ScriptService.getCodeFactory((IScriptEngine)scriptEngine);
                    try {
                        String functionCall = codeFactory.createFunctionCall(EnvironmentModule.class.getMethod("loadModule", String.class, Boolean.TYPE), new Object[]{moduleID, false});
                        return scriptEngine.executeSync((Object)functionCall);
                    }
                    catch (NoSuchMethodException e) {
                        Logger.error((String)"org.eclipse.ease.ui", (String)"Method loadModule() not found", (Throwable)e);
                    }
                    catch (SecurityException e) {
                        Logger.error((String)"org.eclipse.ease.ui", (String)"Method loadModule() not accessible", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        Logger.error((String)"org.eclipse.ease.ui", (String)"Script execution interrupted", (Throwable)e);
                    }
                } else {
                    Logger.error((String)"org.eclipse.ease.ui", (String)("Module \"" + moduleID + "\" cannot be found"));
                }
            } else {
                return environment.getModule(moduleID);
            }
        }
        return null;
    }
}

