/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.modules.ui;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.ui.modules.ui.ModulesContentProvider;
import org.eclipse.ease.ui.modules.ui.ModulesDragListener;
import org.eclipse.ease.ui.modules.ui.ModulesLabelProvider;
import org.eclipse.ease.ui.tools.DecoratedLabelProvider;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ModulesComposite
extends Composite {
    private final TreeViewer treeViewer = new TreeViewer((Composite)this, 0);

    public ModulesComposite(Composite parent, int style, boolean modulesOnly) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout(256));
        this.treeViewer.getTree().setLayout((Layout)new FillLayout(256));
        DecoratedLabelProvider labelProvider = new DecoratedLabelProvider(new ModulesLabelProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.treeViewer.setContentProvider((IContentProvider)new ModulesContentProvider(modulesOnly));
        this.treeViewer.setComparator(new ViewerComparator(){

            public int category(Object element) {
                if (element instanceof IPath) {
                    return 1;
                }
                if (element instanceof ModuleDefinition) {
                    return 2;
                }
                if (element instanceof Field) {
                    return 2;
                }
                if (element instanceof Method) {
                    return 3;
                }
                return 4;
            }
        });
        this.treeViewer.addDragSupport(3, new Transfer[]{LocalSelectionTransfer.getTransfer(), TextTransfer.getInstance()}, (DragSourceListener)new ModulesDragListener(this.treeViewer));
    }

    public void dispose() {
        super.dispose();
    }

    public void setInput(Object input) {
        this.treeViewer.setInput(input);
    }

    public void refresh() {
        this.treeViewer.refresh();
    }

    public void addFilter(ViewerFilter filter) {
        this.treeViewer.addFilter(filter);
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }
}

