/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.unittest.components;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class TestSuiteModel
implements IResourceChangeListener {
    public static final String CODE_LOCATION_TESTSUITE_SETUP = "TestSuite Setup";
    public static final String CODE_LOCATION_TESTSUITE_TEARDOWN = "TestSuite Teardown";
    public static final String CODE_LOCATION_TESTFILE_SETUP = "TestFile Setup";
    public static final String CODE_LOCATION_TESTFILE_TEARDOWN = "TestFile Teardown";
    public static final String CODE_LOCATION_TEST_SETUP = "Test Setup";
    public static final String CODE_LOCATION_TEST_TEARDOWN = "Test Teardown";
    public static final String FLAG_MAX_THREADS = "max threads";
    public static final String FLAG_STOP_SUITE_ON_FAILURE = "stop suite on failure";
    public static final String FLAG_PROMOTE_ERRORS_TO_FAILURES = "promote errors to failures";
    public static final String FLAG_EXECUTE_TEARDOWN_ON_FAILURE = "execute teardown on failure";
    private static final String XML_NODE_ROOT = "testsuite";
    private static final String XML_NODE_TESTFILES = "testfiles";
    private static final String XML_NODE_TESTFILE = "testfile";
    private static final String XML_NODE_VARIABLES = "variables";
    private static final String XML_NODE_VARIABLE = "variable";
    private static final String XML_NODE_CODE_FRAGMENTS = "codeFragments";
    private static final String XML_NODE_CODE_FRAGMENT = "codeFragment";
    private static final String XML_NODE_FLAGS = "flags";
    private static final String XML_NODE_FLAG = "flag";
    private static final String XML_NODE_DESCRIPTION = "description";
    private static final String XML_ATTRIBUTE_NAME = "name";
    private static final String XML_ATTRIBUTE_DESCRIPTION = "description";
    private final Collection<String> fTestFiles = new HashSet<String>();
    private final Map<String, String> fFlags = new HashMap<String, String>();
    private final List<Variable> fVariables = new ArrayList<Variable>();
    private final Map<String, String> fCodeFragments = new HashMap<String, String>();
    private final IFile fFile;
    private String fDescription = null;
    private boolean fDirty;

    public TestSuiteModel(IFile file) throws IOException, CoreException {
        this.fFile = file;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        this.fDirty = true;
        this.reload();
    }

    public TestSuiteModel() {
        this.fFile = null;
        this.fDirty = false;
        this.setFlag(FLAG_MAX_THREADS, 1);
        this.setFlag(FLAG_PROMOTE_ERRORS_TO_FAILURES, false);
        this.setFlag(FLAG_STOP_SUITE_ON_FAILURE, false);
        this.setFlag(FLAG_EXECUTE_TEARDOWN_ON_FAILURE, true);
    }

    public void close() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public boolean getFlag(String flagID, boolean defaultValue) {
        String value = this.fFlags.get(flagID);
        return value != null ? Boolean.parseBoolean(value) : defaultValue;
    }

    public int getFlag(String flagID, int defaultValue) {
        String value = this.fFlags.get(flagID);
        try {
            return value != null ? Integer.parseInt(value) : defaultValue;
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public void setFlag(String flagID, String content) {
        this.fFlags.put(flagID, content);
        this.fDirty = true;
    }

    public void setFlag(String flagID, boolean content) {
        this.setFlag(flagID, Boolean.toString(content));
    }

    public void setFlag(String flagID, int content) {
        this.setFlag(flagID, Integer.toString(content));
    }

    public Collection<String> getTestFiles() {
        return this.fTestFiles;
    }

    public void load(String text) {
        this.fTestFiles.clear();
        this.fVariables.clear();
        this.fCodeFragments.clear();
        this.fFlags.clear();
        try {
            IMemento descriptionNode;
            IMemento flagsNode;
            IMemento codeFragmentsNode;
            IMemento variablesNode;
            int n;
            XMLMemento memento = XMLMemento.createReadRoot((Reader)new StringReader(text));
            IMemento testsNode = memento.getChild(XML_NODE_TESTFILES);
            if (testsNode != null) {
                IMemento[] iMementoArray = testsNode.getChildren(XML_NODE_TESTFILE);
                n = iMementoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento node = iMementoArray[n2];
                    this.fTestFiles.add(node.getTextData());
                    ++n2;
                }
            }
            if ((variablesNode = memento.getChild(XML_NODE_VARIABLES)) != null) {
                IMemento[] iMementoArray = variablesNode.getChildren(XML_NODE_VARIABLE);
                int n3 = iMementoArray.length;
                n = 0;
                while (n < n3) {
                    IMemento node = iMementoArray[n];
                    this.fVariables.add(new Variable(node.getString(XML_ATTRIBUTE_NAME), node.getTextData(), node.getString("description")));
                    ++n;
                }
            }
            if ((codeFragmentsNode = memento.getChild(XML_NODE_CODE_FRAGMENTS)) != null) {
                IMemento[] iMementoArray = codeFragmentsNode.getChildren(XML_NODE_CODE_FRAGMENT);
                int n4 = iMementoArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    IMemento node = iMementoArray[n5];
                    this.fCodeFragments.put(node.getString(XML_ATTRIBUTE_NAME), node.getTextData());
                    ++n5;
                }
            }
            if ((flagsNode = memento.getChild(XML_NODE_FLAGS)) != null) {
                IMemento[] iMementoArray = flagsNode.getChildren(XML_NODE_FLAG);
                int n6 = iMementoArray.length;
                int n7 = 0;
                while (n7 < n6) {
                    IMemento node = iMementoArray[n7];
                    this.setFlag(node.getString(XML_ATTRIBUTE_NAME), node.getTextData());
                    ++n7;
                }
            }
            this.fDescription = (descriptionNode = memento.getChild("description")) != null ? descriptionNode.getTextData() : "";
            this.fDirty = false;
        }
        catch (WorkbenchException workbenchException) {}
    }

    public XMLMemento toMemento() {
        XMLMemento memento = XMLMemento.createWriteRoot((String)XML_NODE_ROOT);
        IMemento testsNode = memento.createChild(XML_NODE_TESTFILES);
        for (String fileLocation : this.getTestFiles()) {
            testsNode.createChild(XML_NODE_TESTFILE).putTextData(fileLocation);
        }
        IMemento variablesNode = memento.createChild(XML_NODE_VARIABLES);
        for (Variable variable : this.getVariables()) {
            IMemento node = variablesNode.createChild(XML_NODE_VARIABLE);
            node.putString(XML_ATTRIBUTE_NAME, variable.getName());
            node.putString("description", variable.getDescription());
            node.putTextData(variable.getContent());
        }
        IMemento codesNode = memento.createChild(XML_NODE_CODE_FRAGMENTS);
        for (Map.Entry entry : this.fCodeFragments.entrySet()) {
            IMemento node = codesNode.createChild(XML_NODE_CODE_FRAGMENT);
            node.putString(XML_ATTRIBUTE_NAME, (String)entry.getKey());
            node.putTextData((String)entry.getValue());
        }
        IMemento iMemento = memento.createChild(XML_NODE_FLAGS);
        for (Map.Entry<String, String> entry : this.fFlags.entrySet()) {
            IMemento node = iMemento.createChild(XML_NODE_FLAG);
            node.putString(XML_ATTRIBUTE_NAME, entry.getKey());
            node.putTextData(entry.getValue());
        }
        memento.createChild("description").putTextData(this.getDescription());
        return memento;
    }

    public void addTestFile(String fileLocation) {
        this.fTestFiles.add(fileLocation);
        this.fDirty = true;
    }

    public IFile getFile() {
        return this.fFile;
    }

    public List<Variable> getVariables() {
        return this.fVariables;
    }

    public void addVariable(String identifier, String content, String description) {
        this.fVariables.add(new Variable(identifier, content, description));
        this.fDirty = true;
    }

    public String getCodeFragment(String identifier) {
        return this.fCodeFragments.containsKey(identifier) ? this.fCodeFragments.get(identifier) : "";
    }

    public void setCodeFragment(String identifier, String code) {
        if (code == null || code.isEmpty()) {
            this.fCodeFragments.remove(identifier);
        } else {
            this.fCodeFragments.put(identifier, code);
        }
        this.fDirty = true;
    }

    public void setDescription(String description) {
        this.fDescription = description;
        this.fDirty = true;
    }

    public String getDescription() {
        return this.fDescription != null ? this.fDescription : "";
    }

    public void removeVariable(Variable variable) {
        this.fVariables.remove(variable);
    }

    public void reload() throws IOException, CoreException {
        if (this.isDirty()) {
            this.load(ResourceTools.toString((InputStream)this.fFile.getContents()));
        }
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            event.getDelta().accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    IResource resource = delta.getResource();
                    if (resource instanceof IContainer) {
                        return TestSuiteModel.this.fFile.getFullPath().toString().startsWith(resource.getFullPath().toString());
                    }
                    if (resource.equals((Object)TestSuiteModel.this.fFile)) {
                        TestSuiteModel.this.fDirty = true;
                    }
                    return false;
                }
            });
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, String> getCodeFragments() {
        return this.fCodeFragments;
    }

    public class Variable {
        private String fDescription;
        private String fContent;
        private String fName;

        public Variable(String identifier, String content, String description) {
            this.fName = identifier;
            this.fContent = content;
            this.fDescription = description != null ? description : "";
        }

        public String getContent() {
            return this.fContent;
        }

        public String getDescription() {
            return this.fDescription;
        }

        public String getName() {
            return this.fName;
        }

        public void setName(String name) {
            this.fName = name;
        }

        public void setDescription(String description) {
            this.fDescription = description;
        }

        public void setContent(String content) {
            this.fContent = content;
        }
    }
}

