/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.rcp;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dirigible.repository.api.ContentTypeHelper;
import org.eclipse.dirigible.repository.ext.fs.FileSystemUtils;
import org.eclipse.dirigible.repository.rcp.RCPBaseException;
import org.eclipse.dirigible.repository.rcp.RCPFile;
import org.eclipse.dirigible.repository.rcp.RCPFolder;
import org.eclipse.dirigible.repository.rcp.RCPObject;
import org.eclipse.dirigible.repository.rcp.RCPRepository;
import org.eclipse.dirigible.repository.rcp.RCPWorkspaceMapper;

public class RCPRepositoryDAO {
    static final int OBJECT_TYPE_FOLDER = 0;
    static final int OBJECT_TYPE_DOCUMENT = 1;
    static final int OBJECT_TYPE_BINARY = 2;
    private RCPRepository repository;

    RCPRepositoryDAO(RCPRepository repository) {
        this.repository = repository;
    }

    public RCPRepository getRepository() {
        return this.repository;
    }

    public void createFile(String path, byte[] content, boolean isBinary, String contentType) throws RCPBaseException {
        try {
            String workspacePath = RCPWorkspaceMapper.getMappedName(path);
            FileSystemUtils.saveFile((String)workspacePath, (byte[])content);
        }
        catch (IOException e) {
            throw new RCPBaseException(e);
        }
    }

    public void checkInitialized() {
    }

    public void setFileContent(RCPFile rcpFile, byte[] content) {
        try {
            String workspacePath = RCPWorkspaceMapper.getMappedName(rcpFile.getPath());
            FileSystemUtils.saveFile((String)workspacePath, (byte[])content);
        }
        catch (IOException e) {
            throw new RCPBaseException(e);
        }
    }

    public byte[] getFileContent(RCPFile rcpFile) {
        try {
            String workspacePath = RCPWorkspaceMapper.getMappedName(rcpFile.getPath());
            return FileSystemUtils.loadFile((String)workspacePath);
        }
        catch (IOException e) {
            throw new RCPBaseException(e);
        }
    }

    public void renameFile(String path, String newPath) {
        try {
            String workspacePathOld = RCPWorkspaceMapper.getMappedName(path);
            String workspacePathNew = RCPWorkspaceMapper.getMappedName(newPath);
            FileSystemUtils.moveFile((String)workspacePathOld, (String)workspacePathNew);
        }
        catch (IOException e) {
            throw new RCPBaseException(e);
        }
    }

    public void removeFileByPath(String path) {
        try {
            String workspacePath = RCPWorkspaceMapper.getMappedName(path);
            FileSystemUtils.removeFile((String)workspacePath);
        }
        catch (IOException e) {
            throw new RCPBaseException(e);
        }
    }

    public void removeFolderByPath(String path) {
        try {
            String workspacePath = RCPWorkspaceMapper.getMappedName(path);
            FileSystemUtils.removeFile((String)workspacePath);
        }
        catch (IOException e) {
            throw new RCPBaseException(e);
        }
    }

    public void createFolder(String normalizePath) {
        try {
            String workspacePath = RCPWorkspaceMapper.getMappedName(normalizePath);
            FileSystemUtils.createFolder((String)workspacePath);
        }
        catch (IOException e) {
            throw new RCPBaseException(e);
        }
    }

    public void renameFolder(String path, String newPath) {
        try {
            String workspacePathOld = RCPWorkspaceMapper.getMappedName(path);
            String workspacePathNew = RCPWorkspaceMapper.getMappedName(newPath);
            FileSystemUtils.moveFile((String)workspacePathOld, (String)workspacePathNew);
        }
        catch (IOException e) {
            throw new RCPBaseException(e);
        }
    }

    public RCPObject getObjectByPath(String path) {
        RCPObject rcpObject = null;
        try {
            String workspacePath = RCPWorkspaceMapper.getMappedName(path);
            File objectFile = new File(workspacePath);
            if (!objectFile.exists() && ContentTypeHelper.getExtension((String)workspacePath).isEmpty()) {
                FileSystemUtils.createFolder((String)workspacePath);
            }
            if (objectFile.isFile()) {
                String contentType = ContentTypeHelper.getContentType((String)FileSystemUtils.getExtension((String)workspacePath));
                rcpObject = new RCPFile(this.repository, ContentTypeHelper.isBinary((String)contentType), contentType);
            } else {
                rcpObject = new RCPFolder(this.repository);
            }
            rcpObject.setName(objectFile.getName());
            rcpObject.setPath(workspacePath);
            rcpObject.setCreatedBy(FileSystemUtils.getOwner((String)workspacePath));
            rcpObject.setCreatedAt(FileSystemUtils.getModifiedAt((String)workspacePath));
            rcpObject.setModifiedBy(FileSystemUtils.getOwner((String)workspacePath));
            rcpObject.setModifiedAt(FileSystemUtils.getModifiedAt((String)workspacePath));
        }
        catch (IOException e) {
            throw new RCPBaseException(e);
        }
        return rcpObject;
    }

    public List<RCPObject> getChildrenByFolder(String path) {
        ArrayList<RCPObject> rcpObjects = new ArrayList<RCPObject>();
        try {
            File[] children;
            String workspacePath = RCPWorkspaceMapper.getMappedName(path);
            File objectFile = new File(workspacePath);
            if (objectFile.isDirectory() && (children = objectFile.listFiles()) != null) {
                File[] fileArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    rcpObjects.add(this.getObjectByPath(file.getCanonicalPath()));
                    ++n2;
                }
            }
        }
        catch (IOException e) {
            throw new RCPBaseException(e);
        }
        return rcpObjects;
    }
}

