/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.lifecycle;

import java.lang.reflect.Field;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.lifecycle.RemoteAdapter;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.internal.util.ActiveKeysUtil;
import org.eclipse.rap.rwt.internal.util.MnemonicUtil;
import org.eclipse.rap.rwt.remote.JsonMapping;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.ControlRemoteAdapter;
import org.eclipse.swt.internal.widgets.ControlUtil;
import org.eclipse.swt.internal.widgets.IControlAdapter;
import org.eclipse.swt.internal.widgets.MarkupUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ControlLCAUtil {
    private static final String PROP_PARENT = "parent";
    private static final String PROP_CHILDREN = "children";
    private static final String PROP_BOUNDS = "bounds";
    private static final String PROP_TAB_INDEX = "tabIndex";
    private static final String PROP_TOOLTIP_TEXT = "toolTip";
    private static final String PROP_MENU = "menu";
    private static final String PROP_VISIBLE = "visibility";
    private static final String PROP_ENABLED = "enabled";
    private static final String PROP_FOREGROUND = "foreground";
    private static final String PROP_BACKGROUND = "background";
    private static final String PROP_BACKGROUND_IMAGE = "backgroundImage";
    private static final String PROP_FONT = "font";
    private static final String PROP_CURSOR = "cursor";
    private static final String PROP_ACTIVATE_LISTENER = "Activate";
    private static final String PROP_DEACTIVATE_LISTENER = "Deactivate";
    private static final String PROP_FOCUS_IN_LISTENER = "FocusIn";
    private static final String PROP_FOCUS_OUT_LISTENER = "FocusOut";
    private static final String PROP_MOUSE_DOWN_LISTENER = "MouseDown";
    private static final String PROP_MOUSE_DOUBLE_CLICK_LISTENER = "MouseDoubleClick";
    private static final String PROP_MOUSE_UP_LISTENER = "MouseUp";
    private static final String PROP_KEY_LISTENER = "KeyDown";
    private static final String PROP_TRAVERSE_LISTENER = "Traverse";
    private static final String PROP_MENU_DETECT_LISTENER = "MenuDetect";
    private static final String PROP_HELP_LISTENER = "Help";
    private static final String CURSOR_UPARROW = "rwt-resources/resource/widget/rap/cursors/up_arrow.cur";

    private ControlLCAUtil() {
    }

    public static void preserveValues(Control control) {
        ControlLCAUtil.preserveParent(control);
        ControlLCAUtil.preserveChildren(control);
        ControlLCAUtil.preserveBounds(control);
        ControlLCAUtil.preserveTabIndex(control);
        ControlLCAUtil.preserveToolTipText(control);
        ControlLCAUtil.preserveMenu(control);
        ControlLCAUtil.preserveVisible(control);
        ControlLCAUtil.preserveEnabled(control);
        ControlLCAUtil.preserveForeground(control);
        ControlLCAUtil.preserveBackground(control);
        ControlLCAUtil.preserveBackgroundImage(control);
        ControlLCAUtil.preserveFont(control);
        ControlLCAUtil.preserveCursor(control);
        ControlLCAUtil.preserveData(control);
        ActiveKeysUtil.preserveActiveKeys(control);
        ActiveKeysUtil.preserveCancelKeys(control);
        ControlLCAUtil.preserveListenActivate(control);
        ControlLCAUtil.preserveListenMouse(control);
        ControlLCAUtil.preserveListenFocus(control);
        ControlLCAUtil.preserveListenKey(control);
        ControlLCAUtil.preserveListenTraverse(control);
        ControlLCAUtil.preserveListenMenuDetect(control);
        ControlLCAUtil.preserveListenHelp(control);
    }

    public static void renderChanges(Control control) {
        ControlLCAUtil.renderChildren(control);
        ControlLCAUtil.renderBounds(control);
        ControlLCAUtil.renderTabIndex(control);
        ControlLCAUtil.renderToolTipText(control);
        ControlLCAUtil.renderMenu(control);
        ControlLCAUtil.renderVisible(control);
        ControlLCAUtil.renderEnabled(control);
        ControlLCAUtil.renderForeground(control);
        ControlLCAUtil.renderBackground(control);
        ControlLCAUtil.renderBackgroundImage(control);
        ControlLCAUtil.renderFont(control);
        ControlLCAUtil.renderCursor(control);
        ControlLCAUtil.renderData(control);
        ActiveKeysUtil.renderActiveKeys(control);
        ActiveKeysUtil.renderCancelKeys(control);
        ControlLCAUtil.renderListenActivate(control);
        ControlLCAUtil.renderListenMouse(control);
        ControlLCAUtil.renderListenFocus(control);
        ControlLCAUtil.renderListenKey(control);
        ControlLCAUtil.renderListenTraverse(control);
        ControlLCAUtil.renderListenMenuDetect(control);
        ControlLCAUtil.renderListenHelp(control);
    }

    private static void preserveParent(Control control) {
        Composite parent = control.getParent();
        if (parent != null) {
            ControlLCAUtil.getRemoteAdapter(control).preserveParent(parent);
        }
    }

    public static void renderParent(Control control) {
        Composite preserved;
        ControlRemoteAdapter remoteAdapter = ControlLCAUtil.getRemoteAdapter(control);
        Composite actual = control.getParent();
        if (remoteAdapter.isInitialized() && actual != null && WidgetLCAUtil.changed((Widget)control, actual, preserved = remoteAdapter.getPreservedParent(), null)) {
            RemoteObjectFactory.getRemoteObject(control).set(PROP_PARENT, WidgetUtil.getId(actual));
        }
    }

    private static void preserveChildren(Control control) {
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            ControlLCAUtil.getRemoteAdapter(control).preserveChildren(composite.getChildren());
        }
    }

    private static void renderChildren(Control control) {
        Control[] preserved;
        Composite composite;
        Control[] actual;
        if (control instanceof Composite && WidgetLCAUtil.changed((Widget)control, actual = (composite = (Composite)control).getChildren(), preserved = ControlLCAUtil.getRemoteAdapter(control).getPreservedChildren(), null)) {
            RemoteObjectFactory.getRemoteObject(control).set(PROP_CHILDREN, ControlLCAUtil.getIdsAsJson(actual));
        }
    }

    private static void preserveBounds(Control control) {
        Rectangle bounds = ControlUtil.getControlAdapter(control).getBounds();
        ControlLCAUtil.getRemoteAdapter(control).preserveBounds(bounds);
    }

    private static void renderBounds(Control control) {
        Rectangle preserved;
        Rectangle actual = ControlUtil.getControlAdapter(control).getBounds();
        if (WidgetLCAUtil.changed((Widget)control, actual, preserved = ControlLCAUtil.getRemoteAdapter(control).getPreservedBounds(), null)) {
            RemoteObjectFactory.getRemoteObject(control).set(PROP_BOUNDS, JsonMapping.toJson(actual));
        }
    }

    private static void preserveTabIndex(Control control) {
        ControlLCAUtil.getRemoteAdapter(control).preserveTabIndex(ControlLCAUtil.getTabIndex(control));
    }

    private static void renderTabIndex(Control control) {
        if (control instanceof Shell) {
            ControlLCAUtil.resetTabIndices((Shell)control);
            ControlLCAUtil.computeTabIndices((Shell)control, 1);
        }
        ControlRemoteAdapter remoteAdapter = ControlLCAUtil.getRemoteAdapter(control);
        if (ControlLCAUtil.takesFocus(control)) {
            int actual = ControlLCAUtil.getTabIndex(control);
            int preserved = remoteAdapter.getPreservedTabIndex();
            if (!remoteAdapter.isInitialized() || actual != preserved) {
                RemoteObjectFactory.getRemoteObject(control).set(PROP_TAB_INDEX, actual);
            }
        }
    }

    private static void preserveToolTipText(Control control) {
        ControlLCAUtil.getRemoteAdapter(control).preserveToolTipText(control.getToolTipText());
    }

    private static void renderToolTipText(Control control) {
        WidgetLCAUtil.renderToolTipMarkupEnabled(control);
        String actual = control.getToolTipText();
        String preserved = ControlLCAUtil.getRemoteAdapter(control).getPreservedToolTipText();
        if (WidgetLCAUtil.changed((Widget)control, actual, preserved, null)) {
            String text;
            String string = text = actual == null ? "" : actual;
            if (!MarkupUtil.isToolTipMarkupEnabledFor(control)) {
                text = MnemonicUtil.removeAmpersandControlCharacters(text);
            }
            RemoteObjectFactory.getRemoteObject(control).set(PROP_TOOLTIP_TEXT, text);
        }
    }

    private static void preserveMenu(Control control) {
        ControlLCAUtil.getRemoteAdapter(control).preserveMenu(control.getMenu());
    }

    private static void renderMenu(Control control) {
        Menu preserved;
        Menu actual = control.getMenu();
        if (WidgetLCAUtil.changed((Widget)control, actual, preserved = ControlLCAUtil.getRemoteAdapter(control).getPreservedMenu(), null)) {
            String actualMenuId = actual == null ? null : WidgetUtil.getId(actual);
            RemoteObjectFactory.getRemoteObject(control).set(PROP_MENU, actualMenuId);
        }
    }

    private static void preserveVisible(Control control) {
        ControlLCAUtil.getRemoteAdapter(control).preserveVisible(ControlLCAUtil.getVisible(control));
    }

    private static void renderVisible(Control control) {
        boolean defaultValue;
        boolean actual = ControlLCAUtil.getVisible(control);
        boolean preserved = ControlLCAUtil.getRemoteAdapter(control).getPreservedVisible();
        boolean bl = defaultValue = !(control instanceof Shell);
        if (WidgetLCAUtil.changed((Widget)control, actual, preserved, defaultValue)) {
            RemoteObjectFactory.getRemoteObject(control).set(PROP_VISIBLE, actual);
        }
    }

    private static void preserveEnabled(Control control) {
        ControlLCAUtil.getRemoteAdapter(control).preserveEnabled(control.getEnabled());
    }

    private static void renderEnabled(Control control) {
        boolean preserved;
        boolean actual = control.getEnabled();
        if (WidgetLCAUtil.changed((Widget)control, actual, preserved = ControlLCAUtil.getRemoteAdapter(control).getPreservedEnabled(), true)) {
            RemoteObjectFactory.getRemoteObject(control).set(PROP_ENABLED, actual);
        }
    }

    private static void preserveForeground(Control control) {
        IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
        ControlLCAUtil.getRemoteAdapter(control).preserveForeground(controlAdapter.getUserForeground());
    }

    private static void renderForeground(Control control) {
        Color preserved;
        IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
        Color actual = controlAdapter.getUserForeground();
        if (WidgetLCAUtil.changed((Widget)control, actual, preserved = ControlLCAUtil.getRemoteAdapter(control).getPreservedForeground(), null)) {
            RemoteObjectFactory.getRemoteObject(control).set(PROP_FOREGROUND, JsonMapping.toJson(actual));
        }
    }

    private static void preserveBackground(Control control) {
        ControlRemoteAdapter adapter = ControlLCAUtil.getRemoteAdapter(control);
        IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
        adapter.preserveBackground(controlAdapter.getUserBackground());
        adapter.preserveBackgroundTransparency(controlAdapter.getBackgroundTransparency());
    }

    private static void renderBackground(Control control) {
        IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
        Color actualBackground = controlAdapter.getUserBackground();
        boolean actualTransparency = controlAdapter.getBackgroundTransparency();
        ControlRemoteAdapter remoteAdapter = ControlLCAUtil.getRemoteAdapter(control);
        boolean colorChanged = WidgetLCAUtil.changed((Widget)control, actualBackground, remoteAdapter.getPreservedBackground(), null);
        boolean transparencyChanged = WidgetLCAUtil.changed((Widget)control, actualTransparency, remoteAdapter.getPreservedBackgroundTransparency(), false);
        if (transparencyChanged || colorChanged) {
            JsonValue color = actualTransparency && actualBackground == null ? JsonMapping.toJson(new RGB(0, 0, 0), 0) : JsonMapping.toJson(actualBackground, actualTransparency ? 0 : 255);
            RemoteObjectFactory.getRemoteObject(control).set(PROP_BACKGROUND, color);
        }
    }

    private static void preserveBackgroundImage(Control control) {
        IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
        Image image = controlAdapter.getUserBackgroundImage();
        ControlLCAUtil.getRemoteAdapter(control).preserveBackgroundImage(image);
    }

    private static void renderBackgroundImage(Control control) {
        Image preserved;
        IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
        Image actual = controlAdapter.getUserBackgroundImage();
        if (WidgetLCAUtil.changed((Widget)control, actual, preserved = ControlLCAUtil.getRemoteAdapter(control).getPreservedBackgroundImage(), null)) {
            RemoteObjectFactory.getRemoteObject(control).set(PROP_BACKGROUND_IMAGE, JsonMapping.toJson(actual));
        }
    }

    private static void preserveFont(Control control) {
        IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
        ControlLCAUtil.getRemoteAdapter(control).preserveFont(controlAdapter.getUserFont());
    }

    private static void renderFont(Control control) {
        Font preserved;
        IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
        Font actual = controlAdapter.getUserFont();
        if (WidgetLCAUtil.changed((Widget)control, actual, preserved = ControlLCAUtil.getRemoteAdapter(control).getPreservedFont(), null)) {
            RemoteObjectFactory.getRemoteObject(control).set(PROP_FONT, JsonMapping.toJson(actual));
        }
    }

    private static void preserveCursor(Control control) {
        ControlLCAUtil.getRemoteAdapter(control).preserveCursor(control.getCursor());
    }

    private static void renderCursor(Control control) {
        Cursor preserved;
        Cursor actual = control.getCursor();
        if (WidgetLCAUtil.changed((Widget)control, actual, preserved = ControlLCAUtil.getRemoteAdapter(control).getPreservedCursor(), null)) {
            RemoteObjectFactory.getRemoteObject(control).set(PROP_CURSOR, ControlLCAUtil.getQxCursor(actual));
        }
    }

    private static void preserveData(Control control) {
        WidgetLCAUtil.preserveData(control);
    }

    private static void renderData(Control control) {
        WidgetLCAUtil.renderData(control);
    }

    private static void preserveListenActivate(Control control) {
        if (!(control instanceof Shell)) {
            WidgetLCAUtil.preserveListener(control, 26);
            WidgetLCAUtil.preserveListener(control, 27);
        }
    }

    private static void renderListenActivate(Control control) {
        if (!(control instanceof Shell)) {
            WidgetLCAUtil.renderListener(control, 26, PROP_ACTIVATE_LISTENER);
            WidgetLCAUtil.renderListener(control, 27, PROP_DEACTIVATE_LISTENER);
        }
    }

    private static void preserveListenMouse(Control control) {
        WidgetLCAUtil.preserveListener(control, 3);
        WidgetLCAUtil.preserveListener(control, 4);
        WidgetLCAUtil.preserveListener(control, 8);
    }

    private static void renderListenMouse(Control control) {
        WidgetLCAUtil.renderListener(control, 3, PROP_MOUSE_DOWN_LISTENER);
        WidgetLCAUtil.renderListener(control, 4, PROP_MOUSE_UP_LISTENER);
        WidgetLCAUtil.renderListener(control, 8, PROP_MOUSE_DOUBLE_CLICK_LISTENER);
    }

    private static void preserveListenFocus(Control control) {
        if ((control.getStyle() & 0x80000) == 0) {
            WidgetLCAUtil.preserveListener(control, 15);
            WidgetLCAUtil.preserveListener(control, 16);
        }
    }

    private static void renderListenFocus(Control control) {
        if ((control.getStyle() & 0x80000) == 0) {
            WidgetLCAUtil.renderListener(control, 15, PROP_FOCUS_IN_LISTENER);
            WidgetLCAUtil.renderListener(control, 16, PROP_FOCUS_OUT_LISTENER);
        }
    }

    private static void preserveListenKey(Control control) {
        WidgetLCAUtil.preserveListener((Widget)control, 1, ControlLCAUtil.hasKeyListener(control));
    }

    private static void renderListenKey(Control control) {
        WidgetLCAUtil.renderListener((Widget)control, 1, PROP_KEY_LISTENER, ControlLCAUtil.hasKeyListener(control));
    }

    private static void preserveListenTraverse(Control control) {
        WidgetLCAUtil.preserveListener(control, 31);
    }

    private static void renderListenTraverse(Control control) {
        WidgetLCAUtil.renderListener(control, 31, PROP_TRAVERSE_LISTENER);
    }

    private static void preserveListenMenuDetect(Control control) {
        WidgetLCAUtil.preserveListener(control, 35);
    }

    private static void renderListenMenuDetect(Control control) {
        WidgetLCAUtil.renderListener(control, 35, PROP_MENU_DETECT_LISTENER);
    }

    private static void preserveListenHelp(Control control) {
        WidgetLCAUtil.preserveListener(control, 28);
    }

    private static void renderListenHelp(Control control) {
        WidgetLCAUtil.renderListener(control, 28, PROP_HELP_LISTENER);
    }

    private static boolean getVisible(Control control) {
        Rectangle bounds = ControlUtil.getControlAdapter(control).getBounds();
        return control.getVisible() && bounds.width > 0 && bounds.height > 0;
    }

    private static boolean takesFocus(Control control) {
        boolean result = true;
        result &= (control.getStyle() & 0x80000) == 0;
        result &= control.getClass() != Composite.class;
        return result &= control.getClass() != SashForm.class;
    }

    private static int getTabIndex(Control control) {
        int result = -1;
        if (ControlLCAUtil.takesFocus(control)) {
            result = ControlUtil.getControlAdapter(control).getTabIndex();
        }
        return result;
    }

    private static void resetTabIndices(Composite composite) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            ControlUtil.getControlAdapter(control).setTabIndex(-1);
            if (control instanceof Composite) {
                ControlLCAUtil.resetTabIndices((Composite)control);
            }
            ++n2;
        }
    }

    private static int computeTabIndices(Composite composite, int startIndex) {
        int result = startIndex;
        Control[] controlArray = composite.getTabList();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
            controlAdapter.setTabIndex(result);
            result += control instanceof Link ? 300 : 1;
            if (control instanceof Composite) {
                result = ControlLCAUtil.computeTabIndices((Composite)control, result);
            }
            ++n2;
        }
        return result;
    }

    private static JsonValue getIdsAsJson(Control[] controls) {
        String[] controlIds = new String[controls.length];
        int i = 0;
        while (i < controls.length) {
            controlIds[i] = WidgetUtil.getId(controls[i]);
            ++i;
        }
        return controlIds.length == 0 ? JsonValue.NULL : JsonUtil.createJsonArray(controlIds);
    }

    private static String getQxCursor(Cursor newValue) {
        String result = null;
        if (newValue != null) {
            int value = 0;
            try {
                Class<Cursor> cursorClass = Cursor.class;
                Field field = cursorClass.getDeclaredField("value");
                field.setAccessible(true);
                value = field.getInt(newValue);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            switch (value) {
                case 0: {
                    result = "default";
                    break;
                }
                case 1: {
                    result = "wait";
                    break;
                }
                case 3: {
                    result = "progress";
                    break;
                }
                case 2: {
                    result = "crosshair";
                    break;
                }
                case 4: {
                    result = "help";
                    break;
                }
                case 5: {
                    result = "move";
                    break;
                }
                case 7: {
                    result = "row-resize";
                    break;
                }
                case 9: {
                    result = "col-resize";
                    break;
                }
                case 10: {
                    result = "n-resize";
                    break;
                }
                case 11: {
                    result = "s-resize";
                    break;
                }
                case 12: {
                    result = "e-resize";
                    break;
                }
                case 13: {
                    result = "w-resize";
                    break;
                }
                case 6: 
                case 14: {
                    result = "ne-resize";
                    break;
                }
                case 15: {
                    result = "se-resize";
                    break;
                }
                case 16: {
                    result = "sw-resize";
                    break;
                }
                case 8: 
                case 17: {
                    result = "nw-resize";
                    break;
                }
                case 19: {
                    result = "text";
                    break;
                }
                case 21: {
                    result = "pointer";
                    break;
                }
                case 20: {
                    result = "not-allowed";
                    break;
                }
                case 18: {
                    result = CURSOR_UPARROW;
                }
            }
        }
        return result;
    }

    private static boolean hasKeyListener(Control control) {
        return EventLCAUtil.isListening(control, 2) || EventLCAUtil.isListening(control, 1);
    }

    private static ControlRemoteAdapter getRemoteAdapter(Control control) {
        return (ControlRemoteAdapter)control.getAdapter(RemoteAdapter.class);
    }
}

