/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.authenticator;

import java.security.Principal;
import org.apache.catalina.Cluster;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.ha.CatalinaCluster;
import org.apache.catalina.ha.ClusterManager;
import org.apache.catalina.ha.authenticator.ClusterSingleSignOnListener;
import org.apache.catalina.ha.authenticator.SingleSignOnMessage;
import org.apache.catalina.ha.session.SerializablePrincipal;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.tomcat.util.ExceptionUtils;

public class ClusterSingleSignOn
extends SingleSignOn {
    protected static final String info = "org.apache.catalina.ha.authenticator.ClusterSingleSignOn";
    protected int messageNumber = 0;
    private ClusterSingleSignOnListener clusterSSOListener = null;
    private CatalinaCluster cluster = null;

    @Override
    public String getInfo() {
        return info;
    }

    public CatalinaCluster getCluster() {
        return this.cluster;
    }

    public void setCluster(CatalinaCluster cluster) {
        this.cluster = cluster;
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        this.clusterSSOListener = new ClusterSingleSignOnListener();
        this.clusterSSOListener.setClusterSSO(this);
        try {
            Container host;
            Cluster cluster = this.getCluster();
            if (cluster == null && (host = this.getContainer()) != null && host instanceof Host) {
                cluster = host.getCluster();
                if (cluster != null && cluster instanceof CatalinaCluster) {
                    this.setCluster((CatalinaCluster)cluster);
                    this.getCluster().addClusterListener(this.clusterSSOListener);
                } else {
                    Container engine = host.getParent();
                    if (engine != null && engine instanceof Engine) {
                        cluster = engine.getCluster();
                        if (cluster != null && cluster instanceof CatalinaCluster) {
                            this.setCluster((CatalinaCluster)cluster);
                            this.getCluster().addClusterListener(this.clusterSSOListener);
                        }
                    } else {
                        cluster = null;
                    }
                }
            }
            if (cluster == null) {
                throw new LifecycleException("There is no Cluster for ClusterSingleSignOn");
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            throw new LifecycleException("ClusterSingleSignOn exception during clusterLoad " + t);
        }
        super.startInternal();
    }

    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        super.stopInternal();
        if (this.getCluster() != null) {
            this.getCluster().removeClusterListener(this.clusterSSOListener);
        }
    }

    @Override
    protected void associate(String ssoId, Session session) {
        if (this.cluster != null) {
            ++this.messageNumber;
            SingleSignOnMessage msg = new SingleSignOnMessage(this.cluster.getLocalMember(), ssoId, session.getId());
            Manager mgr = session.getManager();
            if (mgr != null && mgr instanceof ClusterManager) {
                msg.setContextName(((ClusterManager)mgr).getName());
            }
            msg.setAction(1);
            this.cluster.send(msg);
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug("SingleSignOnMessage Send with action " + msg.getAction());
            }
        }
        this.associateLocal(ssoId, session);
    }

    protected void associateLocal(String ssoId, Session session) {
        super.associate(ssoId, session);
    }

    @Override
    protected void deregister(String ssoId, Session session) {
        if (this.cluster != null) {
            ++this.messageNumber;
            SingleSignOnMessage msg = new SingleSignOnMessage(this.cluster.getLocalMember(), ssoId, session.getId());
            Manager mgr = session.getManager();
            if (mgr != null && mgr instanceof ClusterManager) {
                msg.setContextName(((ClusterManager)mgr).getName());
            }
            msg.setAction(2);
            this.cluster.send(msg);
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug("SingleSignOnMessage Send with action " + msg.getAction());
            }
        }
        this.deregisterLocal(ssoId, session);
    }

    protected void deregisterLocal(String ssoId, Session session) {
        super.deregister(ssoId, session);
    }

    @Override
    protected void deregister(String ssoId) {
        if (this.cluster != null) {
            ++this.messageNumber;
            SingleSignOnMessage msg = new SingleSignOnMessage(this.cluster.getLocalMember(), ssoId, null);
            msg.setAction(3);
            this.cluster.send(msg);
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug("SingleSignOnMessage Send with action " + msg.getAction());
            }
        }
        this.deregisterLocal(ssoId);
    }

    protected void deregisterLocal(String ssoId) {
        super.deregister(ssoId);
    }

    @Override
    protected void register(String ssoId, Principal principal, String authType, String username, String password) {
        if (this.cluster != null) {
            ++this.messageNumber;
            SingleSignOnMessage msg = new SingleSignOnMessage(this.cluster.getLocalMember(), ssoId, null);
            msg.setAction(4);
            msg.setAuthType(authType);
            msg.setUsername(username);
            msg.setPassword(password);
            SerializablePrincipal sp = null;
            if (principal instanceof GenericPrincipal) {
                sp = SerializablePrincipal.createPrincipal((GenericPrincipal)principal);
                msg.setPrincipal(sp);
            }
            this.cluster.send(msg);
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug("SingleSignOnMessage Send with action " + msg.getAction());
            }
        }
        this.registerLocal(ssoId, principal, authType, username, password);
    }

    protected void registerLocal(String ssoId, Principal principal, String authType, String username, String password) {
        super.register(ssoId, principal, authType, username, password);
    }

    @Override
    protected void update(String ssoId, Principal principal, String authType, String username, String password) {
        if (this.cluster != null) {
            ++this.messageNumber;
            SingleSignOnMessage msg = new SingleSignOnMessage(this.cluster.getLocalMember(), ssoId, null);
            msg.setAction(5);
            msg.setAuthType(authType);
            msg.setUsername(username);
            msg.setPassword(password);
            SerializablePrincipal sp = null;
            if (principal instanceof GenericPrincipal) {
                sp = SerializablePrincipal.createPrincipal((GenericPrincipal)principal);
                msg.setPrincipal(sp);
            }
            this.cluster.send(msg);
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug("SingleSignOnMessage Send with action " + msg.getAction());
            }
        }
        this.updateLocal(ssoId, principal, authType, username, password);
    }

    protected void updateLocal(String ssoId, Principal principal, String authType, String username, String password) {
        super.update(ssoId, principal, authType, username, password);
    }

    @Override
    protected void removeSession(String ssoId, Session session) {
        if (this.cluster != null) {
            ++this.messageNumber;
            SingleSignOnMessage msg = new SingleSignOnMessage(this.cluster.getLocalMember(), ssoId, session.getId());
            Manager mgr = session.getManager();
            if (mgr != null && mgr instanceof ClusterManager) {
                msg.setContextName(((ClusterManager)mgr).getName());
            }
            msg.setAction(6);
            this.cluster.send(msg);
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug("SingleSignOnMessage Send with action " + msg.getAction());
            }
        }
        this.removeSessionLocal(ssoId, session);
    }

    protected void removeSessionLocal(String ssoId, Session session) {
        super.removeSession(ssoId, session);
    }
}

