/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.ext.indexing;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.logging.Logger;

public class RepositoryMemoryIndexer {
    private static final String FIELD_PATH = "path";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_CONTENT = "content";
    private static final Logger logger = Logger.getLogger(RepositoryMemoryIndexer.class);
    private static Directory directory = new RAMDirectory();
    private static List<String> indexedResources = new ArrayList<String>();
    private static Date lastIndexed = new Date();

    private RepositoryMemoryIndexer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void indexRepository(IRepository repository) throws IOException {
        try {
            Directory directory = RepositoryMemoryIndexer.directory;
            synchronized (directory) {
                logger.debug("entering: indexRepository(IRepository repository)");
                StandardAnalyzer analyzer = new StandardAnalyzer(Version.LUCENE_35);
                IndexWriterConfig config = null;
                IndexWriter iwriter = null;
                try {
                    config = new IndexWriterConfig(Version.LUCENE_35, (Analyzer)analyzer);
                    iwriter = new IndexWriter(RepositoryMemoryIndexer.directory, config);
                    ICollection collection = repository.getRoot();
                    RepositoryMemoryIndexer.indexCollection(iwriter, collection);
                    lastIndexed = new Date();
                }
                finally {
                    if (iwriter != null) {
                        iwriter.close();
                    }
                }
                logger.debug("exiting: indexRepository(IRepository repository)");
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearIndex() throws IOException {
        try {
            Directory directory = RepositoryMemoryIndexer.directory;
            synchronized (directory) {
                logger.debug("entering: clearIndex()");
                StandardAnalyzer analyzer = new StandardAnalyzer(Version.LUCENE_35);
                IndexWriterConfig config = null;
                IndexWriter iwriter = null;
                try {
                    config = new IndexWriterConfig(Version.LUCENE_35, (Analyzer)analyzer);
                    iwriter = new IndexWriter(RepositoryMemoryIndexer.directory, config);
                    iwriter.deleteAll();
                }
                finally {
                    if (iwriter != null) {
                        iwriter.close();
                    }
                }
                logger.debug("exiting: clearIndex()");
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> search(String term) throws IOException {
        ArrayList<String> docs = new ArrayList<String>();
        try {
            Directory directory = RepositoryMemoryIndexer.directory;
            synchronized (directory) {
                logger.debug("entering: search(String term)");
                StandardAnalyzer analyzer = new StandardAnalyzer(Version.LUCENE_35);
                IndexSearcher isearcher = null;
                IndexReader ireader = null;
                try {
                    ScoreDoc[] hits;
                    ireader = IndexReader.open((Directory)RepositoryMemoryIndexer.directory);
                    isearcher = new IndexSearcher(ireader);
                    QueryParser parser = new QueryParser(Version.LUCENE_35, FIELD_CONTENT, (Analyzer)analyzer);
                    Query query = parser.parse(term);
                    ScoreDoc[] scoreDocArray = hits = isearcher.search((Query)query, null, (int)100).scoreDocs;
                    int n = hits.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ScoreDoc hit = scoreDocArray[n2];
                        Document hitDoc = isearcher.doc(hit.doc);
                        docs.add(hitDoc.get(FIELD_PATH));
                        ++n2;
                    }
                }
                finally {
                    if (isearcher != null) {
                        isearcher.close();
                    }
                    if (ireader != null) {
                        ireader.close();
                    }
                }
                logger.debug("exiting: search(String term)");
            }
        }
        catch (ParseException e) {
            logger.debug(e.getMessage());
        }
        return docs;
    }

    private static void indexCollection(IndexWriter iwriter, ICollection collection) throws IOException {
        logger.debug("entering: indexCollection(IndexWriter iwriter, ICollection collection)");
        List resources = collection.getResources();
        for (IResource resource : resources) {
            RepositoryMemoryIndexer.indexResource(iwriter, resource);
        }
        List collections = collection.getCollections();
        for (ICollection child : collections) {
            RepositoryMemoryIndexer.indexCollection(iwriter, child);
        }
        logger.debug("exiting: indexCollection(IndexWriter iwriter, ICollection collection)");
    }

    private static void indexResource(IndexWriter iwriter, IResource resource) throws CorruptIndexException, IOException {
        logger.debug("entering: indexResource(IndexWriter iwriter, IResource resource)");
        if (!resource.isBinary()) {
            if (!indexedResources.contains(resource.getPath())) {
                logger.debug("Indexing resource: " + resource.getPath());
                Document doc = RepositoryMemoryIndexer.createDocument(resource);
                iwriter.addDocument(doc);
                iwriter.commit();
                logger.debug("Resource: " + resource.getPath() + " indexed successfully");
                indexedResources.add(resource.getPath());
            } else if (lastIndexed != null && resource.getInformation().getModifiedAt() != null && lastIndexed.before(resource.getInformation().getModifiedAt())) {
                logger.debug("Updating index for resource: " + resource.getPath());
                Document doc = RepositoryMemoryIndexer.createDocument(resource);
                Term term = new Term(FIELD_PATH, resource.getPath());
                iwriter.updateDocument(term, doc);
                iwriter.commit();
                logger.debug("For resource: " + resource.getPath() + " index updated successfully");
            } else {
                logger.debug("Skip indexing for unmodified resource: " + resource.getPath());
            }
        } else {
            logger.debug("Skip indexing for binary resource: " + resource.getPath());
        }
        logger.debug("exiting: indexResource(IndexWriter iwriter, IResource resource)");
    }

    private static Document createDocument(IResource resource) throws UnsupportedEncodingException, IOException {
        Document doc = new Document();
        String text = new String(resource.getContent(), "UTF-8");
        doc.add((Fieldable)new Field(FIELD_CONTENT, text, Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field(FIELD_NAME, resource.getName(), Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field(FIELD_PATH, resource.getPath(), Field.Store.YES, Field.Index.ANALYZED));
        return doc;
    }
}

