/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.metrics;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.repository.api.ContentTypeHelper;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.metrics.AccessLogLocationsDAO;
import org.eclipse.dirigible.runtime.metrics.AccessLogLocationsSynchronizer;
import org.eclipse.dirigible.runtime.metrics.AccessLogRecord;
import org.eclipse.dirigible.runtime.metrics.AccessLogRecordDAO;
import org.eclipse.dirigible.runtime.registry.PathUtils;

public class AccessLogServlet
extends HttpServlet {
    private static final long serialVersionUID = 5004610851206076344L;
    private static final Logger logger = Logger.getLogger(AccessLogServlet.class);
    private static final String LOCATIONS = "/locations";
    private static final String ALL = "/all";
    private static final Gson GSON = new GsonBuilder().setDateFormat("yyyy-MM-dd hh:mm:ss").create();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        logger.debug("entering AccessLogServlet doGet...");
        String paramHitsPerPattern = request.getParameter("hitsPerPattern");
        String paramHitsPerProject = request.getParameter("hitsPerProject");
        String paramHitsPerURI = request.getParameter("hitsPerURI");
        String paramRTimePerPattern = request.getParameter("rtimePerPattern");
        String paramRTimePerProject = request.getParameter("rtimePerProject");
        String paramRTimePerURI = request.getParameter("rtimePerURI");
        String paramHitsByURI = request.getParameter("hitsByURI");
        String paramSeries = request.getParameter("series");
        String path = PathUtils.extractPath((HttpServletRequest)request);
        logger.debug("path=" + path);
        if (LOCATIONS.endsWith(path)) {
            this.listLocations(response);
        } else if (paramHitsPerPattern != null) {
            this.hitsPerPattern(response, paramSeries);
        } else if (paramHitsPerProject != null) {
            this.hitsPerProject(response, paramSeries);
        } else if (paramHitsPerURI != null) {
            this.hitsPerURI(response, paramSeries);
        } else if (paramRTimePerPattern != null) {
            this.responseTimePerPattern(response, paramSeries);
        } else if (paramRTimePerProject != null) {
            this.responseTimePerProject(response, paramSeries);
        } else if (paramRTimePerURI != null) {
            this.responseTimePerURI(response, paramSeries);
        } else if (paramHitsByURI != null) {
            this.hitsByURI(response);
        } else {
            this.listLog(response);
        }
        response.getWriter().flush();
        response.getWriter().close();
        logger.debug("existing AccessLogServlet doGet");
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        logger.debug("entering AccessLogServlet doPost...");
        String path = PathUtils.extractPath((HttpServletRequest)request);
        logger.debug("path=" + path);
        if (path != null) {
            try {
                logger.debug("inserting: " + path);
                AccessLogLocationsDAO.insertLocation(path);
                response.getWriter().print("Added: " + path);
                response.getWriter().flush();
            }
            catch (SQLException e) {
                this.handleException(response, e);
            }
        }
        logger.debug("existing AccessLogServlet doPost");
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        logger.debug("entering AccessLogServlet doDelete...");
        String path = PathUtils.extractPath((HttpServletRequest)request);
        logger.debug("path=" + path);
        if (path != null) {
            if (!path.endsWith(ALL)) {
                logger.debug("removing access location: " + path);
                try {
                    AccessLogLocationsDAO.deleteLocation(path);
                    response.getWriter().print("Removed: " + path);
                }
                catch (SQLException e) {
                    this.handleException(response, e);
                }
            } else {
                logger.debug("removing all access locations");
                try {
                    AccessLogLocationsDAO.deleteAllLocations();
                    response.getWriter().print("Removed All");
                }
                catch (SQLException e) {
                    this.handleException(response, e);
                }
            }
            response.getWriter().flush();
        }
        logger.debug("existing AccessLogServlet doDelete");
    }

    private void listLocations(HttpServletResponse response) throws IOException {
        logger.debug("listing registered access locations");
        try {
            AccessLogLocationsDAO.refreshLocations();
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        List<String> locations = AccessLogLocationsSynchronizer.getAccessLogLocations();
        this.sendJson(response, locations);
    }

    private void hitsPerPattern(HttpServletResponse response, String paramSeries) throws IOException {
        try {
            AccessLogRecordDAO accessLogRecordDAO = new AccessLogRecordDAO();
            Collection<Object> result = paramSeries != null ? accessLogRecordDAO.getLastRecordsByPatternSeries() : accessLogRecordDAO.getLastRecordsByPattern();
            this.sendJson(response, result);
        }
        catch (SQLException e) {
            this.handleException(response, e);
        }
    }

    private void hitsPerProject(HttpServletResponse response, String paramSeries) throws IOException {
        try {
            AccessLogRecordDAO accessLogRecordDAO = new AccessLogRecordDAO();
            Collection<Object> result = paramSeries != null ? accessLogRecordDAO.getLastRecordsByProjectSeries() : accessLogRecordDAO.getLastRecordsByProject();
            this.sendJson(response, result);
        }
        catch (SQLException e) {
            this.handleException(response, e);
        }
    }

    private void hitsPerURI(HttpServletResponse response, String paramSeries) throws IOException {
        try {
            AccessLogRecordDAO accessLogRecordDAO = new AccessLogRecordDAO();
            Collection<Object> result = paramSeries != null ? accessLogRecordDAO.getLastRecordsByURISeries() : accessLogRecordDAO.getLastRecordsByURI();
            this.sendJson(response, result);
        }
        catch (SQLException e) {
            this.handleException(response, e);
        }
    }

    private void responseTimePerPattern(HttpServletResponse response, String paramSeries) throws IOException {
        try {
            AccessLogRecordDAO accessLogRecordDAO = new AccessLogRecordDAO();
            Collection<Object> result = paramSeries != null ? accessLogRecordDAO.getResponseTimeRecordsByPatternSeries() : accessLogRecordDAO.getResponseTimeRecordsByPattern();
            this.sendJson(response, result);
        }
        catch (SQLException e) {
            this.handleException(response, e);
        }
    }

    private void responseTimePerProject(HttpServletResponse response, String paramSeries) throws IOException {
        try {
            AccessLogRecordDAO accessLogRecordDAO = new AccessLogRecordDAO();
            Collection<Object> result = paramSeries != null ? accessLogRecordDAO.getResponseTimeRecordsByProjectSeries() : accessLogRecordDAO.getResponseTimeRecordsByProject();
            this.sendJson(response, result);
        }
        catch (SQLException e) {
            this.handleException(response, e);
        }
    }

    private void responseTimePerURI(HttpServletResponse response, String paramSeries) throws IOException {
        try {
            AccessLogRecordDAO accessLogRecordDAO = new AccessLogRecordDAO();
            Collection<Object> result = paramSeries != null ? accessLogRecordDAO.getResponseTimeRecordsByURISeries() : accessLogRecordDAO.getResponseTimeRecordsByURI();
            this.sendJson(response, result);
        }
        catch (SQLException e) {
            this.handleException(response, e);
        }
    }

    private void hitsByURI(HttpServletResponse response) throws IOException {
        try {
            AccessLogRecordDAO accessLogRecordDAO = new AccessLogRecordDAO();
            List<List<Object>> records = accessLogRecordDAO.getHitsByURI();
            this.sendJson(response, records);
        }
        catch (SQLException e) {
            this.handleException(response, e);
        }
    }

    private void listLog(HttpServletResponse response) throws IOException {
        logger.debug("printing the access log");
        try {
            AccessLogRecord[] records = AccessLogRecordDAO.getAccessLogRecords();
            this.sendJson(response, records);
        }
        catch (SQLException e) {
            this.handleException(response, e);
        }
    }

    private void sendJson(HttpServletResponse response, Object content) throws IOException {
        String json = GSON.toJson(content);
        response.setContentType(ContentTypeHelper.getContentType((String)"json"));
        response.getWriter().print(json);
    }

    private void handleException(HttpServletResponse response, Exception e) throws IOException {
        logger.error(e.getMessage(), (Throwable)e);
        response.getWriter().print(e.getMessage());
        response.setStatus(500);
    }
}

