/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.content;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.content.ContentImporterServlet;
import org.eclipse.dirigible.runtime.task.IRunnableTask;
import org.eclipse.dirigible.runtime.task.TaskManagerShort;

public class ContentInitializerServlet
extends HttpServlet {
    private static final String INIT_FLAG_FILE_NAME = "/db/dirigible/default.content";
    private static final String CONTENT_FILE_NAME = "/content.zip";
    private static final long serialVersionUID = 6468050094756163896L;
    private static final Logger logger = Logger.getLogger(ContentInitializerServlet.class);
    private static final String PATH_REGISTY_ROOT_TARGET = "/db";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void registerInitRegister() {
        TaskManagerShort.getInstance().registerRunnableTask((IRunnableTask)new ContentInitializerRegister(this));
        logger.info("Content Initializer Register has been registered");
    }

    public boolean initDefaultContent(HttpServletRequest request) throws ServletException {
        ContentImporterServlet contentImporterServlet = new ContentImporterServlet();
        try {
            IRepository repository = contentImporterServlet.getRepository(request);
            if (repository == null) {
                return false;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        try {
            IResource resource = contentImporterServlet.getRepository(request).getResource(INIT_FLAG_FILE_NAME);
            if (!resource.exists()) {
                logger.info("Initializing default content...");
                contentImporterServlet.importZipAndUpdate(((Object)((Object)this)).getClass().getResourceAsStream(CONTENT_FILE_NAME), PATH_REGISTY_ROOT_TARGET, request);
                logger.info("Default content initialized.");
            } else {
                logger.info("Post import actions...");
                contentImporterServlet.postImport(request);
                logger.info("Post import actions done.");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.initDefaultContent(req);
    }

    class ContentInitializerRegister
    implements IRunnableTask {
        ContentInitializerServlet contentInitializerServlet;

        ContentInitializerRegister(ContentInitializerServlet contentInitializerServlet2) {
            this.contentInitializerServlet = contentInitializerServlet2;
        }

        public String getName() {
            return "Content Initializer Register";
        }

        public void start() {
            boolean ok = false;
            try {
                ok = ContentInitializerServlet.this.initDefaultContent(null);
            }
            catch (ServletException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            if (ok) {
                TaskManagerShort.getInstance().unregisterRunnableTask((IRunnableTask)this);
                logger.info("Content Initializer Register has been un-registered");
            }
        }
    }
}

