/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.tracwiki.core.token;

import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElementProcessor;
import org.eclipse.mylyn.wikitext.tracwiki.core.TracWikiLanguage;

public class WikiWordReplacementToken
extends PatternBasedElement {
    private static final Pattern replacementPattern = Pattern.compile("\\W");

    protected String getPattern(int groupOffset) {
        return "(?<![a-zA-Z])(!)?([A-Z][a-z]+([A-Z][a-z]+)+)";
    }

    protected int getPatternGroupCount() {
        return 2;
    }

    protected PatternBasedElementProcessor newProcessor() {
        return new WikiWordProcessor();
    }

    private class WikiWordProcessor
    extends PatternBasedElementProcessor {
        private WikiWordProcessor() {
        }

        public void emit() {
            String escaped = this.group(1);
            String word = this.group(2);
            TracWikiLanguage twikiLanguage = (TracWikiLanguage)this.markupLanguage;
            if (escaped != null || !twikiLanguage.isAutoLinking()) {
                this.builder.characters(word);
            } else {
                String target = replacementPattern.matcher(word).replaceAll("");
                boolean exists = twikiLanguage.computeInternalLinkExists(target);
                String internalHref = twikiLanguage.toInternalHref(target);
                if (!exists) {
                    this.builder.characters(word);
                    this.builder.link(internalHref, "?");
                } else {
                    this.builder.link(internalHref, word);
                }
            }
        }
    }
}

