/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.diff.IElementRelativeDifference;
import org.eclipse.emf.diffmerge.api.diff.IMergeableDifference;
import org.eclipse.emf.diffmerge.api.diff.IPresenceDifference;
import org.eclipse.emf.diffmerge.api.diff.IReferenceValuePresence;
import org.eclipse.emf.diffmerge.impl.helpers.AbstractExpensiveOperation;
import org.eclipse.emf.diffmerge.structures.common.FHashMap;
import org.eclipse.emf.diffmerge.structures.common.FHashSet;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.util.DelegatingLabelProvider;
import org.eclipse.emf.diffmerge.ui.util.DiffMergeLabelProvider;
import org.eclipse.emf.diffmerge.ui.viewers.ComparisonResourceManager;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MergeImpactViewer
extends Viewer {
    private ImpactInput _input = null;
    protected final ComparisonResourceManager _resourceManager;
    protected SashForm _control;
    protected TreeViewer _upperViewer;
    protected TreeViewer _lowerViewer;

    public MergeImpactViewer(Composite parent_p, ComparisonResourceManager resourceManager_p) {
        this._resourceManager = resourceManager_p;
        this.createControls(parent_p);
    }

    protected void createControls(Composite parent_p) {
        this._control = new SashForm(parent_p, 512);
        this._control.setLayoutData((Object)new GridData(4, 4, true, true));
        Group upperWrapper = new Group((Composite)this._control, 0);
        upperWrapper.setText(Messages.MergeImpactViewer_Required);
        upperWrapper.setLayout((Layout)new GridLayout());
        this._upperViewer = new TreeViewer((Composite)upperWrapper);
        this._upperViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        Group lowerWrapper = new Group((Composite)this._control, 0);
        lowerWrapper.setText(Messages.MergeImpactViewer_Implied);
        lowerWrapper.setLayout((Layout)new GridLayout());
        this._lowerViewer = new TreeViewer((Composite)lowerWrapper);
        this._lowerViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.setupViewers();
    }

    public Control getControl() {
        return this._control;
    }

    public ImpactInput getInput() {
        return this._input;
    }

    public ISelection getSelection() {
        return null;
    }

    protected Shell getShell() {
        return this.getControl().getShell();
    }

    protected void inputChanged(Object input_p, Object oldInput_p) {
        this._upperViewer.setInput(input_p);
        this._lowerViewer.setInput(input_p);
        this._upperViewer.expandAll();
        this._lowerViewer.expandAll();
    }

    protected boolean isConflicting(IDifference difference_p) {
        boolean result = false;
        if (this.getInput() != null && this.getInput().isThreeWay() && difference_p instanceof IPresenceDifference) {
            IPresenceDifference presence = (IPresenceDifference)difference_p;
            result = !presence.isAlignedWithAncestor() && presence.getPresenceRole() == this.getInput().getDestination();
        }
        return result;
    }

    protected boolean isConflicting(IMatch match_p) {
        Object[] lowerChildren;
        Object[] upperChildren;
        Object[] objectArray = upperChildren = ((ITreeContentProvider)this._upperViewer.getContentProvider()).getChildren((Object)match_p);
        int n = upperChildren.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (child instanceof IDifference && this.isConflicting((IDifference)child)) {
                return true;
            }
            ++n2;
        }
        Object[] objectArray2 = lowerChildren = ((ITreeContentProvider)this._lowerViewer.getContentProvider()).getChildren((Object)match_p);
        int n3 = lowerChildren.length;
        n = 0;
        while (n < n3) {
            Object child = objectArray2[n];
            if (child instanceof IDifference && this.isConflicting((IDifference)child)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void refresh() {
        this._upperViewer.refresh();
        this._lowerViewer.refresh();
    }

    public void setDelegateLabelProvider(ILabelProvider labelProvider_p) {
        ((DelegatingLabelProvider)this._upperViewer.getLabelProvider()).setDelegate(labelProvider_p);
    }

    public void setInput(Object input_p) {
        if (input_p instanceof ImpactInput) {
            ImpactInput oldInput = this.getInput();
            this._input = (ImpactInput)input_p;
            if (!this._input.isComputed()) {
                this._input.compute(null);
            }
            this.inputChanged(this._input, oldInput);
        }
    }

    public void setSelection(ISelection selection_p, boolean reveal_p) {
    }

    protected void setupViewers() {
        this._upperViewer.setContentProvider((IContentProvider)new MergeImpactContentProvider(true));
        this._lowerViewer.setContentProvider((IContentProvider)new MergeImpactContentProvider(false));
        MergeImpactLabelProvider lp = new MergeImpactLabelProvider();
        this._upperViewer.setLabelProvider((IBaseLabelProvider)lp);
        this._lowerViewer.setLabelProvider((IBaseLabelProvider)lp);
        ViewerComparator sorter = new ViewerComparator();
        this._upperViewer.setComparator(sorter);
        this._lowerViewer.setComparator(sorter);
    }

    public static class ImpactInput {
        private final boolean _sideIsLeft;
        private final EMFDiffNode _context_p;
        private final Collection<IDifference> _toMerge;
        private boolean _isComputed;
        protected final EMap<IMatch, Collection<IDifference>> _implicitImpact;
        protected final EMap<IMatch, Collection<IDifference>> _explicitImpact;

        public ImpactInput(Collection<? extends IDifference> toMerge_p, boolean toLeft_p, EMFDiffNode context_p) {
            this._toMerge = new FHashSet(toMerge_p, null);
            this._sideIsLeft = toLeft_p;
            this._context_p = context_p;
            this._isComputed = false;
            this._explicitImpact = new FHashMap();
            this._implicitImpact = new FHashMap();
        }

        public void compute(IProgressMonitor monitor_p) {
            ComputationOperation op = new ComputationOperation();
            op.run(monitor_p);
            this._isComputed = true;
        }

        public EMFDiffNode getContext() {
            return this._context_p;
        }

        public Role getDestination() {
            return this._context_p.getRoleForSide(this._sideIsLeft);
        }

        public Collection<IDifference> getDifferencesToMerge() {
            return this._toMerge;
        }

        public EMap<IMatch, Collection<IDifference>> getImpact(boolean explicit_p) {
            return ECollections.unmodifiableEMap(explicit_p ? this._explicitImpact : this._implicitImpact);
        }

        public boolean isComputed() {
            return this._isComputed;
        }

        public boolean isOnTheLeft() {
            return this._sideIsLeft;
        }

        public boolean isThreeWay() {
            return this._context_p.getActualComparison().isThreeWay();
        }

        protected class ComputationOperation
        extends AbstractExpensiveOperation {
            protected ComputationOperation() {
            }

            public String getOperationName() {
                return Messages.MergeImpactViewer_ComputationName;
            }

            public IStatus run() {
                Collection<IDifference> toMerge = ImpactInput.this.getDifferencesToMerge();
                for (IDifference anyToMerge : toMerge) {
                    if (!(anyToMerge instanceof IMergeableDifference)) continue;
                    IMergeableDifference difference = (IMergeableDifference)anyToMerge;
                    this.registerDifference((IDifference)difference, true);
                    for (IDifference required : difference.getRequiresDependencies(ImpactInput.this.getDestination())) {
                        if (required.isMerged() || toMerge.contains(required)) continue;
                        this.registerDifference(required, false);
                    }
                    for (IDifference implied : difference.getImpliesDependencies(ImpactInput.this.getDestination())) {
                        if (implied.isMerged() || toMerge.contains(implied)) continue;
                        this.registerDifference(implied, false);
                    }
                    this.checkProgress();
                    this.getMonitor().worked(1);
                }
                return Status.OK_STATUS;
            }

            protected int getWorkAmount() {
                return ImpactInput.this.getDifferencesToMerge().size();
            }

            protected void registerDifference(IDifference difference_p, boolean explicit_p) {
                IMatch match = null;
                if (difference_p instanceof IElementRelativeDifference) {
                    IReferenceValuePresence presence;
                    IElementRelativeDifference elementDifference = (IElementRelativeDifference)difference_p;
                    if (elementDifference instanceof IReferenceValuePresence && (presence = (IReferenceValuePresence)elementDifference).isOwnership()) {
                        match = presence.getValueMatch();
                    }
                    if (match == null) {
                        match = elementDifference.getElementMatch();
                    }
                }
                if (match != null) {
                    EMap<IMatch, Collection<IDifference>> map = explicit_p ? ImpactInput.this._explicitImpact : ImpactInput.this._implicitImpact;
                    Collection differences = (Collection)map.get((Object)match);
                    if (differences == null) {
                        differences = new FHashSet();
                        map.put((Object)match, (Object)differences);
                    }
                    differences.add(difference_p);
                }
            }
        }
    }

    protected static class MergeImpactContentProvider
    implements ITreeContentProvider {
        private final boolean _isOnExplicit;
        private ImpactInput _input;

        public MergeImpactContentProvider(boolean explicit_p) {
            this._isOnExplicit = explicit_p;
            this._input = null;
        }

        public void dispose() {
            this._input = null;
        }

        public Object[] getChildren(Object parentElement_p) {
            Collection subDifferences;
            Object[] result = new Object[]{};
            if (parentElement_p instanceof IMatch && (subDifferences = (Collection)this.getImpact().get(parentElement_p)) != null) {
                ArrayList<IDifference> filteredDifferences = new ArrayList<IDifference>(subDifferences.size());
                for (IDifference difference : subDifferences) {
                    if (this.isMoveOfAdded(difference)) continue;
                    filteredDifferences.add(difference);
                }
                result = filteredDifferences.toArray();
            }
            return result;
        }

        private boolean isMoveOfAdded(IDifference difference_p) {
            IReferenceValuePresence valuePresence;
            boolean result = false;
            if (difference_p instanceof IReferenceValuePresence && (valuePresence = (IReferenceValuePresence)difference_p).isOwnership()) {
                IMatch valueMatch = valuePresence.getValueMatch();
                result = valueMatch != null && valueMatch.getElementPresenceDifference() != null;
            }
            return result;
        }

        public Object[] getElements(Object inputElement_p) {
            Object[] result = inputElement_p instanceof ImpactInput ? ((ImpactInput)inputElement_p).getImpact(this._isOnExplicit).keySet().toArray() : new Object[]{};
            return result;
        }

        private EMap<IMatch, Collection<IDifference>> getImpact() {
            EMap<IMatch, Collection<IDifference>> result = ECollections.emptyEMap();
            if (this._input != null) {
                result = this._input.getImpact(this._isOnExplicit);
            }
            return result;
        }

        public Object getParent(Object element_p) {
            return null;
        }

        public boolean hasChildren(Object element_p) {
            return this.getChildren(element_p).length > 0;
        }

        public void inputChanged(Viewer viewer_p, Object oldInput_p, Object newInput_p) {
            if (newInput_p instanceof ImpactInput) {
                this._input = (ImpactInput)newInput_p;
            }
        }
    }

    protected class MergeImpactLabelProvider
    extends DelegatingLabelProvider {
        public MergeImpactLabelProvider() {
            super((ILabelProvider)DiffMergeLabelProvider.getInstance());
        }

        public DiffMergeLabelProvider getDelegate() {
            return (DiffMergeLabelProvider)super.getDelegate();
        }

        @Override
        public Color getForeground(Object element_p) {
            EMFDiffMergeUIPlugin.DifferenceColorKind result = element_p instanceof IDifference && MergeImpactViewer.this.isConflicting((IDifference)element_p) ? EMFDiffMergeUIPlugin.DifferenceColorKind.CONFLICT : (MergeImpactViewer.this.getInput().isOnTheLeft() ? EMFDiffMergeUIPlugin.DifferenceColorKind.LEFT : EMFDiffMergeUIPlugin.DifferenceColorKind.RIGHT);
            return MergeImpactViewer.this.getInput().getContext().getDifferenceColor(result);
        }

        @Override
        public Image getImage(Object element_p) {
            Image result = null;
            if (element_p instanceof IMatch) {
                IMatch match = (IMatch)element_p;
                result = this.getDelegate().getMatchImage(match, MergeImpactViewer.this.getInput().getDestination());
                if (result != null && MergeImpactViewer.this.isConflicting(match)) {
                    result = MergeImpactViewer.this._resourceManager.getOverlayVersion(result, EMFDiffMergeUIPlugin.ImageID.CONFLICT_STAT);
                }
            } else if (element_p instanceof IDifference) {
                IDifference difference = (IDifference)element_p;
                Role destination = MergeImpactViewer.this.getInput().getDestination();
                result = this.getDelegate().getDifferenceImage(difference, destination);
                if (MergeImpactViewer.this.isConflicting(difference)) {
                    EMFDiffMergeUIPlugin.ImageID overlay = MergeImpactViewer.this.getInput().isOnTheLeft() ? EMFDiffMergeUIPlugin.ImageID.OUT_STAT : EMFDiffMergeUIPlugin.ImageID.INC_STAT;
                    result = MergeImpactViewer.this._resourceManager.getOverlayVersion(result, overlay);
                }
            }
            return result;
        }

        @Override
        public String getText(Object element_p) {
            String result = null;
            if (element_p instanceof IMatch) {
                IMatch match = (IMatch)element_p;
                result = this.getDelegate().getMatchText(match, MergeImpactViewer.this.getInput().getDestination(), null);
            } else if (element_p instanceof IDifference) {
                Role destination = MergeImpactViewer.this.getInput().getDestination();
                result = this.getDelegate().getDifferenceText((IDifference)element_p, destination, null);
            } else {
                result = this.getDelegate().getText(element_p);
            }
            return result;
        }
    }
}

