/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.sirius;

import java.util.List;
import org.eclipse.emf.diffmerge.api.config.IConfigurablePolicy;
import org.eclipse.emf.diffmerge.api.scopes.IModelScope;
import org.eclipse.emf.diffmerge.gmf.GMFMatchPolicy;
import org.eclipse.emf.diffmerge.impl.policies.ConfigurableMatchPolicy;
import org.eclipse.emf.diffmerge.structures.common.comparable.ComparableTreeMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.description.AnnotationEntry;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class SiriusMatchPolicy
extends GMFMatchPolicy {
    public SiriusMatchPolicy() {
    }

    public SiriusMatchPolicy(SiriusMatchPolicy policy_p) {
        this();
        this.update((IConfigurablePolicy)policy_p);
    }

    public SiriusMatchPolicy clone() throws CloneNotSupportedException {
        return new SiriusMatchPolicy(this);
    }

    protected String getAnnotationEntrySemanticID(AnnotationEntry element_p, IModelScope scope_p) {
        String result = null;
        if (this.getContainer((EObject)element_p, scope_p) instanceof DDiagram && element_p.getSource() != null) {
            result = this.getContainerRelativeID((EObject)element_p, scope_p, "ANNOTATION:" + element_p.getSource(), null);
        }
        return result;
    }

    public List<ConfigurableMatchPolicy.FineGrainedMatchCriterion> getAvailableFineGrainedCriteria() {
        List result = super.getAvailableFineGrainedCriteria();
        result.add(0, CRITERION_SEMANTICS_DEFAULTCONTENTS);
        return result;
    }

    protected String getDDiagramElementSemanticID(DDiagramElement element_p, IModelScope scope_p) {
        String result = null;
        if (this.useFineGrainedCriterion(CRITERION_SEMANTICS_DIAGRAMS_VIEWBYELEMENT)) {
            DDiagram diagram = element_p.getParentDiagram();
            EObject represented = element_p.getTarget();
            if (diagram != null && represented != null) {
                String representedID;
                String typeID = element_p.eClass().getName();
                String diagramID = this.getMatchID((EObject)diagram, scope_p);
                if (diagramID != null && (representedID = this.getMatchID(represented, scope_p)) != null) {
                    ComparableTreeMap map = new ComparableTreeMap();
                    map.put("SEMANTIC_TYPE", typeID);
                    map.put("SEMANTIC_DIAGRAM", diagramID);
                    map.put("SEMANTIC_ELEMENT", representedID);
                    result = map.toString();
                }
            }
        }
        return result;
    }

    protected String getDViewSemanticID(DView element_p, IModelScope scope_p) {
        String result = null;
        if (this.useFineGrainedCriterion(CRITERION_SEMANTICS_DEFAULTCONTENTS)) {
            String vpName;
            Viewpoint vp = element_p.getViewpoint();
            String string = vpName = vp == null ? null : vp.getName();
            if (vpName != null) {
                result = this.getContainerRelativeID((EObject)element_p, scope_p, vpName, null);
            }
        }
        return result;
    }

    protected String getName(EObject element_p, IModelScope scope_p) {
        String result = null;
        if (element_p instanceof DView) {
            Viewpoint viewpoint = ((DView)element_p).getViewpoint();
            if (viewpoint != null) {
                result = viewpoint.getName();
            }
        } else if (element_p instanceof DRepresentationDescriptor) {
            result = ((DRepresentationDescriptor)element_p).getName();
        } else if (element_p instanceof DRepresentation) {
            result = ((DRepresentation)element_p).getName();
        } else if (element_p instanceof AnnotationEntry) {
            AnnotationEntry annotation = (AnnotationEntry)element_p;
            if (this.getContainer(element_p, scope_p) instanceof DDiagram && annotation.getSource() != null) {
                result = "ANNOTATION_" + annotation.getSource();
            }
        }
        if (result == null) {
            result = super.getName(element_p, scope_p);
        }
        return result;
    }

    protected String getSemanticID(EObject element_p, IModelScope scope_p) {
        String result = null;
        if (element_p instanceof DView) {
            result = this.getDViewSemanticID((DView)element_p, scope_p);
        } else if (element_p instanceof DDiagramElement) {
            result = this.getDDiagramElementSemanticID((DDiagramElement)element_p, scope_p);
        } else if (element_p instanceof AnnotationEntry) {
            result = this.getAnnotationEntrySemanticID((AnnotationEntry)element_p, scope_p);
        }
        if (result == null) {
            result = super.getSemanticID(element_p, scope_p);
        }
        return result;
    }

    protected boolean isDiscriminatingContainment(EObject element_p, EReference containment_p) {
        return super.isDiscriminatingContainment(element_p, containment_p) || containment_p == DiagramPackage.eINSTANCE.getDDiagramElement_GraphicalFilters();
    }
}

