/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.diagrams.sirius.extensions;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternInstanceMarker;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IModelEnvironment;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IModelOperation;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.AbstractIdentifiedElement;
import org.eclipse.emf.diffmerge.patterns.core.operations.AbstractModelOperation;
import org.eclipse.emf.diffmerge.patterns.diagrams.sirius.operations.SiriusCreatePatternAndInstanceOperation;
import org.eclipse.emf.diffmerge.patterns.support.environment.DefaultModelEnvironment;
import org.eclipse.emf.diffmerge.patterns.support.resources.DefaultPatternsXMIResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSiriusModelEnvironment
implements IModelEnvironment {
    private TransactionalEditingDomain _patternCatalogCommonEditingDomain;
    private static String CATALOG_COMMON_EDITING_DOMAIN_ID_END = "Catalogs_Common_Editing_Domain";

    public AbstractSiriusModelEnvironment() {
        ResourceSetImpl rset = new ResourceSetImpl();
        this._patternCatalogCommonEditingDomain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain((ResourceSet)rset);
        String edID = "org.eclipse.emf.diffmerge.patterns.diagrams.sirius." + CATALOG_COMMON_EDITING_DOMAIN_ID_END;
        this._patternCatalogCommonEditingDomain.setID(edID);
    }

    public void abortOperation() {
        throw new OperationCanceledException();
    }

    protected Object adaptContext(Object context_p) {
        Object context = context_p;
        if (context instanceof Collection) {
            context = ((Collection)context).iterator().next();
        }
        if (context instanceof EditPart) {
            context = ((EditPart)context).getModel();
        }
        if (context instanceof ResourceSet && !((ResourceSet)context).getResources().isEmpty()) {
            context = ((ResourceSet)context).getResources().get(0);
        }
        if (context instanceof Resource && !((Resource)context).getContents().isEmpty()) {
            context = ((Resource)context).getContents().get(0);
        }
        return context;
    }

    public void asyncExecute(IModelOperation<?> operation_p) {
        if (operation_p instanceof AbstractModelOperation) {
            ((AbstractModelOperation)operation_p).setModelEnvironment((IModelEnvironment)this);
        }
        IModelEnvironment.ModelAccessJob job = new IModelEnvironment.ModelAccessJob(operation_p);
        job.schedule();
    }

    public Resource createPatternCatalogResource(URI uri) {
        return new DefaultPatternsXMIResource(uri);
    }

    public <E> E execute(IModelOperation<E> operation_p) {
        if (operation_p instanceof AbstractModelOperation) {
            Object context = null;
            EditingDomain domain = null;
            if (operation_p instanceof SiriusCreatePatternAndInstanceOperation) {
                SiriusCreatePatternAndInstanceOperation sop = (SiriusCreatePatternAndInstanceOperation)operation_p;
                context = this.adaptContext(sop.getPatternSideContext());
            } else {
                AbstractModelOperation op = (AbstractModelOperation)operation_p;
                op.setModelEnvironment((IModelEnvironment)this);
                context = this.adaptContext(op.getTargetContext());
            }
            if (context instanceof EditingDomain) {
                domain = (EditingDomain)context;
            }
            if (domain == null) {
                domain = context instanceof IPatternInstanceMarker ? AdapterFactoryEditingDomain.getEditingDomainFor((Object)context) : (context instanceof AbstractIdentifiedElement ? this.getEditingDomain((EObject)((AbstractIdentifiedElement)context)) : AdapterFactoryEditingDomain.getEditingDomainFor((Object)context));
            }
            if (domain instanceof TransactionalEditingDomain) {
                OperationWithResultCommand<E> cmd = new OperationWithResultCommand<E>(domain.getResourceSet(), operation_p);
                domain.getCommandStack().execute(cmd);
                return cmd.getOperationResult();
            }
        }
        return null;
    }

    public TransactionalEditingDomain getCommonCatalogEditingDomain() {
        return this._patternCatalogCommonEditingDomain;
    }

    public ECrossReferenceAdapter getInverseCrossReferencer(EObject element_p) {
        Session session;
        ECrossReferenceAdapter result = null;
        if (element_p != null && (session = SessionManager.INSTANCE.getSession(element_p)) != null) {
            result = session.getSemanticCrossReferencer();
        }
        return result;
    }

    public Collection<? extends Class<?>> getOverridenClasses() {
        ArrayList<Class<DefaultModelEnvironment>> lst = new ArrayList<Class<DefaultModelEnvironment>>();
        lst.add(DefaultModelEnvironment.class);
        return lst;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OperationWithResultCommand<E>
    extends ChangeCommand {
        private IModelOperation<E> _operation;
        private E _result;

        protected OperationWithResultCommand(ResourceSet recordSet_p, IModelOperation<E> operation_p) {
            super((Notifier)recordSet_p);
            this._result = null;
            this._operation = operation_p;
        }

        protected void doExecute() {
            this._result = this._operation.run(null);
        }

        public E getOperationResult() {
            return this._result;
        }
    }
}

