/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.connector.git.ext;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.internal.revision.LocalFileRevision;
import org.eclipse.emf.diffmerge.connector.git.EMFDiffMergeGitConnectorPlugin;
import org.eclipse.emf.diffmerge.connector.git.Messages;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.team.core.history.IFileRevision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GitHelper {
    public static final GitHelper INSTANCE = new GitHelper();
    private static final String REMOTE_SCHEME = "remote";
    private static final String INDEX_SCHEME = "index";
    private static final String COMMIT_SCHEME = "commit";
    private static final String SCHEME_SEP = ":/";

    protected GitHelper() {
    }

    public Collection<String> getGitSchemes() {
        return Arrays.asList(this.getSchemeCommit(), this.getSchemeIndex(), this.getSchemeRemote());
    }

    public Repository getRepository(IPath path_p) {
        if (RepositoryMapping.getMapping((IPath)path_p) != null) {
            return RepositoryMapping.getMapping((IPath)path_p).getRepository();
        }
        Repository[] repositoryArray = Activator.getDefault().getRepositoryCache().getAllRepositories();
        int n = repositoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            Repository repo = repositoryArray[n2];
            Path fullPath = new Path(repo.getWorkTree().toString().concat(path_p.makeAbsolute().toString()));
            if (fullPath.toFile().exists()) {
                return repo;
            }
            ++n2;
        }
        EMFDiffMergeGitConnectorPlugin.getDefault().getLog().log((IStatus)new Status(4, EMFDiffMergeGitConnectorPlugin.getDefault().getPluginId(), "Cannot find Git repository for resource at: " + path_p));
        return null;
    }

    public Repository getRepository(IFileRevision revision_p) {
        if (revision_p != null) {
            Path revisionPath = new Path(revision_p.getURI().toString());
            if (!revisionPath.isAbsolute()) {
                return this.getRepository((IPath)revisionPath);
            }
            if (revision_p instanceof LocalFileRevision) {
                IFile file = ((LocalFileRevision)revision_p).getFile();
                return this.getRepository(file.getFullPath());
            }
            EMFDiffMergeGitConnectorPlugin.getDefault().getLog().log((IStatus)new Status(4, EMFDiffMergeGitConnectorPlugin.getDefault().getPluginId(), String.format(Messages.GitHelper_NoRepoFound, revisionPath)));
        }
        return null;
    }

    public String getSchemeCommit() {
        return COMMIT_SCHEME;
    }

    public String getSchemeIndex() {
        return INDEX_SCHEME;
    }

    public String getSchemeRemote() {
        return REMOTE_SCHEME;
    }

    public String getSchemeSeparator() {
        return SCHEME_SEP;
    }

    public boolean isConflicting(IFileRevision revision_p) throws NoWorkTreeException, CorruptObjectException, IOException {
        boolean result = false;
        Repository repo = this.getRepository(revision_p);
        if (repo != null) {
            result = this.isConflicting(repo, revision_p);
        }
        return result;
    }

    public boolean isConflicting(Repository repository_p, IFileRevision revision_p) throws NoWorkTreeException, CorruptObjectException, IOException {
        Path revisionPath = new Path(revision_p.getURI().toString());
        if (!revisionPath.isAbsolute()) {
            return this.isConflicting(repository_p, revisionPath.toString());
        }
        if (revision_p instanceof LocalFileRevision) {
            IFile file = ((LocalFileRevision)revision_p).getFile();
            return this.isConflicting(repository_p, file.getFullPath().makeRelative().toString());
        }
        EMFDiffMergeGitConnectorPlugin.getDefault().getLog().log((IStatus)new Status(4, EMFDiffMergeGitConnectorPlugin.getDefault().getPluginId(), String.format(Messages.GitHelper_NoConflictInfoFound, revisionPath)));
        return false;
    }

    public boolean isConflicting(Repository repository_p, String path_p) throws NoWorkTreeException, CorruptObjectException, IOException {
        return repository_p.readDirCache().getEntry(path_p).getStage() > 0;
    }
}

