/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.connector.git.ext;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.internal.storage.GitFileRevision;
import org.eclipse.emf.diffmerge.connector.git.EMFDiffMergeGitConnectorPlugin;
import org.eclipse.emf.diffmerge.connector.git.ext.AbstractGitURIConverter;
import org.eclipse.emf.diffmerge.connector.git.ext.GitHelper;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.team.core.history.IFileRevision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGitConflictURIConverter
extends AbstractGitURIConverter {
    protected final int _conflictRole;

    public AbstractGitConflictURIConverter(Repository repository_p, int conflictRole_p) {
        super(repository_p);
        this._conflictRole = conflictRole_p;
    }

    public AbstractGitConflictURIConverter(List<URIHandler> uriHandlers_p, List<ContentHandler> contentHandlers_p, Repository repository_p, int conflictRole_p) {
        super(uriHandlers_p, contentHandlers_p, repository_p);
        this._conflictRole = conflictRole_p;
    }

    @Override
    protected IFileRevision getGitFileRevision(String gitPath) {
        try {
            if (GitHelper.INSTANCE.isConflicting(this.getRepository(), gitPath)) {
                return GitFileRevision.inIndex((Repository)this.getRepository(), (String)gitPath, (int)this._conflictRole);
            }
        }
        catch (IOException e) {
            EMFDiffMergeGitConnectorPlugin.getDefault().getLog().log((IStatus)new Status(4, EMFDiffMergeGitConnectorPlugin.getDefault().getPluginId(), e.getMessage(), (Throwable)e));
        }
        return GitFileRevision.inIndex((Repository)this.getRepository(), (String)gitPath);
    }
}

