/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.ITemplatePatternBasedSpecification;
import org.eclipse.emf.diffmerge.patterns.ui.wizards.AbstractPatternPage;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeWizardPage<T extends ITemplatePatternBasedSpecification>
extends AbstractPatternPage<T>
implements AbstractPatternPage.IPageValidatedListener {
    private final List<AbstractPatternPage<? extends T>> _subPages;
    private final List<AbstractPatternPage<?>> _warningPages;

    public CompositeWizardPage(String pageName_p, String title_p, String defaultMessage_p, T data_p, boolean isBlocking_p, List<? extends AbstractPatternPage<? extends T>> pages_p) {
        super(pageName_p, title_p, defaultMessage_p, data_p, isBlocking_p);
        this._subPages = new ArrayList<AbstractPatternPage<T>>(pages_p);
        this._warningPages = new ArrayList();
    }

    public void createControl(Composite parent_p) {
        TabFolder tabFolder = new TabFolder(parent_p, 0);
        this.setControl((Control)tabFolder);
        tabFolder.setLayout((Layout)new GridLayout());
        this.setDefaultMessage();
        for (AbstractPatternPage<? extends T> abstractPatternPage : this._subPages) {
            TabItem item = new TabItem(tabFolder, 0);
            item.setText(abstractPatternPage.getTitle());
            Composite itemComposite = new Composite((Composite)tabFolder, 0);
            GridData itemData = new GridData(4, 4, true, true);
            itemData.heightHint = 130;
            itemComposite.setLayoutData((Object)itemData);
            itemComposite.setLayout((Layout)new FillLayout());
            item.setControl((Control)itemComposite);
            abstractPatternPage.addValidationListener(this);
            abstractPatternPage.createControl(itemComposite);
        }
    }

    @Override
    protected String getValidationMessage() {
        for (AbstractPatternPage<T> page : this._subPages) {
            String msg = page.getValidationMessage();
            if (msg == null) continue;
            return msg;
        }
        return null;
    }

    @Override
    public void messageUpdated(AbstractPatternPage<?> page_p, String newMessage_p, int newType_p) {
        boolean firstWarningPageChanged = false;
        if (newType_p == 1 || newType_p == 0) {
            firstWarningPageChanged = this._warningPages.indexOf(page_p) == 0;
            this._warningPages.remove(page_p);
        } else if (newType_p == 2) {
            firstWarningPageChanged = this._warningPages.isEmpty();
            if (!this._warningPages.contains(page_p)) {
                this._warningPages.add(page_p);
            }
        }
        if (firstWarningPageChanged) {
            if (!this._warningPages.isEmpty()) {
                AbstractPatternPage<?> warningPage = this._warningPages.get(0);
                this.setMessage(warningPage.getMessage(), 2);
            } else {
                this.setDefaultMessage();
            }
        }
    }

    @Override
    public void pageValidated(AbstractPatternPage<?> page_p, String validationMessage_p) {
        this.validate();
    }

    public void setWizard(IWizard wizard_p) {
        super.setWizard(wizard_p);
        for (AbstractPatternPage<? extends T> abstractPatternPage : this._subPages) {
            abstractPatternPage.setWizard(wizard_p);
        }
    }

    @Override
    public final void validate() {
        super.validate();
        if (this.getErrorMessage() == null && !this._warningPages.isEmpty()) {
            AbstractPatternPage<?> warningPage = this._warningPages.get(0);
            this.setMessage(warningPage.getMessage(), 2);
        }
    }
}

