/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.diffmerge.patterns.core.api.IPattern;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternApplication;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternRole;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IAtomicLocation;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.ICompositeLocation;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IElementMappingLocation;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IElementRelativeLocation;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.ILocation;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IReferenceLocation;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IResourceLocation;
import org.eclipse.emf.diffmerge.patterns.core.api.status.IPatternConformityStatus;
import org.eclipse.emf.diffmerge.patterns.core.util.LocationsUtil;
import org.eclipse.emf.diffmerge.patterns.core.util.ModelsUtil;
import org.eclipse.emf.diffmerge.patterns.core.util.locations.BasicCompositeLocation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicPatternApplication
implements IPatternApplication {
    private final IPattern _pattern;
    private final Map<IPatternRole, ILocation> _roleToLocation;
    private final Object _scopeElement;

    public BasicPatternApplication(IPattern pattern_p) {
        this(pattern_p, null);
    }

    public BasicPatternApplication(IPattern pattern_p, Object scopeElement_p) {
        this._pattern = pattern_p;
        this._roleToLocation = new HashMap<IPatternRole, ILocation>();
        this._scopeElement = scopeElement_p;
    }

    public void addLocation(IPatternRole role_p, ILocation location_p) {
        ILocation existing = this._roleToLocation.get(role_p);
        if (existing instanceof ICompositeLocation) {
            ((ICompositeLocation)existing).getOwnedLocations().addAll(location_p.getAtomicContents());
        } else if (location_p instanceof ICompositeLocation && existing != null) {
            ICompositeLocation composite = (ICompositeLocation)location_p;
            ArrayList<IAtomicLocation> contentsCopy = new ArrayList<IAtomicLocation>(composite.getOwnedLocations());
            composite.getOwnedLocations().clear();
            composite.getOwnedLocations().addAll(existing.getAtomicContents());
            composite.getOwnedLocations().addAll(contentsCopy);
            this.setLocation(role_p, composite);
        } else if (existing instanceof IAtomicLocation && location_p instanceof IAtomicLocation) {
            BasicCompositeLocation composite = new BasicCompositeLocation();
            composite.getOwnedLocations().add((IAtomicLocation)existing);
            composite.getOwnedLocations().add((IAtomicLocation)location_p);
            this.setLocation(role_p, composite);
        } else {
            this.setLocation(role_p, location_p);
        }
    }

    @Override
    public IPatternConformityStatus checkConformance(List<EStructuralFeature> ignoredFeatures_p) {
        return this._pattern.checkConformance(this, ignoredFeatures_p);
    }

    public List<IPatternRole> getAdditionRolesOf(EObject element_p) {
        ArrayList<IPatternRole> result = new ArrayList<IPatternRole>();
        block0: for (IPatternRole iPatternRole : this.getPattern().getRoles()) {
            ILocation location = this.getLocation(iPatternRole);
            if (location == null) continue;
            for (IAtomicLocation iAtomicLocation : location.getAtomicContents()) {
                EObject element;
                if (!(iAtomicLocation instanceof IReferenceLocation) || (element = ((IElementRelativeLocation)iAtomicLocation).getElement()) != element_p) continue;
                result.add(iPatternRole);
                continue block0;
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public ILocation getLocation(IPatternRole role_p) {
        return this._roleToLocation.get(role_p);
    }

    public Collection<ILocation> getLocations() {
        ModelsUtil.ROrderedSet<ILocation> result = new ModelsUtil.ROrderedSet<ILocation>();
        for (ILocation loc : this._roleToLocation.values()) {
            if (loc == null) continue;
            result.add(loc);
        }
        return Collections.unmodifiableCollection(result);
    }

    public List<IPatternRole> getMergeRolesOf(EObject element_p) {
        ArrayList<IPatternRole> result = new ArrayList<IPatternRole>();
        for (IPatternRole iPatternRole : this.getPattern().getRoles()) {
            List<EObject> mergeTargets;
            ILocation location = this.getLocation(iPatternRole);
            if (location == null || !(mergeTargets = LocationsUtil.getMergeTargets(location)).contains(element_p)) continue;
            result.add(iPatternRole);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public IPattern getPattern() {
        return this._pattern;
    }

    public List<IPatternRole> getRolesOf(EObject element_p) {
        ArrayList<IPatternRole> result = new ArrayList<IPatternRole>();
        block0: for (IPatternRole iPatternRole : this.getPattern().getRoles()) {
            ILocation location = this.getLocation(iPatternRole);
            if (location == null) continue;
            block1: for (IAtomicLocation iAtomicLocation : location.getAtomicContents()) {
                if (iAtomicLocation instanceof IElementRelativeLocation) {
                    EObject element = ((IElementRelativeLocation)iAtomicLocation).getElement();
                    if (element != element_p) continue;
                    result.add(iPatternRole);
                    continue block0;
                }
                if (!(iAtomicLocation instanceof IElementMappingLocation)) continue;
                IElementMappingLocation mappingLocation = (IElementMappingLocation)iAtomicLocation;
                for (EObject patternElement : mappingLocation.getPatternElements(this.getPattern())) {
                    EObject modelElement = mappingLocation.getElement(patternElement);
                    if (modelElement != element_p) continue;
                    result.add(iPatternRole);
                    continue block1;
                }
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Object getScopeElement() {
        if (this._scopeElement != null) {
            return this._scopeElement;
        }
        for (ILocation location : this.getLocations()) {
            for (IAtomicLocation iAtomicLocation : location.getAtomicContents()) {
                if (iAtomicLocation instanceof IElementRelativeLocation) {
                    return ((IElementRelativeLocation)iAtomicLocation).getElement();
                }
                if (!(iAtomicLocation instanceof IResourceLocation)) continue;
                return ((IResourceLocation)iAtomicLocation).getResource();
            }
        }
        return null;
    }

    @Override
    public boolean isComplete() {
        for (IPatternRole iPatternRole : this.getPattern().getRoles()) {
            if (iPatternRole.checkCompleteApplicability(this.getLocation(iPatternRole), this).isOk()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCompleteOn(IPatternRole role_p) {
        return role_p.checkCompleteApplicability(this.getLocation(role_p), this).isOk();
    }

    @Override
    public boolean isEmpty() {
        if (this.getPattern() == null) {
            return true;
        }
        for (IPatternRole iPatternRole : this.getPattern().getRoles()) {
            if (!this.isCompleteOn(iPatternRole)) continue;
            return false;
        }
        return true;
    }

    public void removeLocation(IPatternRole role_p, ILocation location_p) {
        ILocation existing = this._roleToLocation.get(role_p);
        if (existing == location_p) {
            this.setLocation(role_p, null);
        } else if (existing instanceof ICompositeLocation) {
            ICompositeLocation composite = (ICompositeLocation)existing;
            composite.getOwnedLocations().remove(location_p);
            if (composite.getOwnedLocations().isEmpty()) {
                this.setLocation(role_p, null);
            }
        }
    }

    public void setLocation(IPatternRole role_p, ILocation location_p) {
        this._roleToLocation.put(role_p, location_p);
    }
}

