/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.impl.scopes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.api.scopes.IFragmentedModelScope;
import org.eclipse.emf.diffmerge.impl.scopes.AbstractEditableModelScope;
import org.eclipse.emf.diffmerge.impl.scopes.DynamicUniqueListIterator;
import org.eclipse.emf.diffmerge.impl.scopes.MultiResourceTreeIterator;
import org.eclipse.emf.diffmerge.util.ModelImplUtil;
import org.eclipse.emf.diffmerge.util.structures.FArrayList;
import org.eclipse.emf.diffmerge.util.structures.FOrderedSet;
import org.eclipse.emf.diffmerge.util.structures.HashBinaryRelation;
import org.eclipse.emf.diffmerge.util.structures.IBinaryRelation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FragmentedModelScope
extends AbstractEditableModelScope
implements IFragmentedModelScope.Editable {
    private final boolean _isReadOnly;
    protected EditingDomain _editingDomain;
    protected final ResourceSet _resourceSet;
    protected final List<Resource> _resources;
    protected final List<Resource> _rootResources;
    protected final Set<Resource> _initiallyPresentResources;
    protected final Set<Resource> _loadedResources;
    protected final IBinaryRelation.Editable<Resource, Resource> _includedResources;
    protected final IBinaryRelation.Editable<Resource, Resource> _referencedResources;
    protected ScopeState _state = ScopeState.INITIALIZED;

    public FragmentedModelScope(Resource resource_p, boolean readOnly_p) {
        this(resource_p.getURI(), resource_p.getResourceSet(), readOnly_p);
    }

    public FragmentedModelScope(URI uri_p, EditingDomain editingDomain_p, boolean readOnly_p) {
        this(Collections.singleton(uri_p), editingDomain_p, readOnly_p);
    }

    public FragmentedModelScope(URI uri_p, ResourceSet resourceSet_p, boolean readOnly_p) {
        this(Collections.singleton(uri_p), resourceSet_p, readOnly_p);
    }

    public FragmentedModelScope(Collection<URI> uris_p, EditingDomain editingDomain_p, boolean readOnly_p) {
        this(uris_p, editingDomain_p.getResourceSet(), readOnly_p);
        this._editingDomain = editingDomain_p;
    }

    public FragmentedModelScope(Collection<URI> uris_p, ResourceSet resourceSet_p, boolean readOnly_p) {
        this(resourceSet_p, readOnly_p);
        for (URI uri : uris_p) {
            Resource rootResource = this._resourceSet.getResource(uri, false);
            if (rootResource == null) {
                rootResource = this._resourceSet.createResource(uri);
            }
            this._rootResources.add(rootResource);
            this.addNewResource(rootResource);
        }
    }

    protected FragmentedModelScope(ResourceSet resourceSet_p, boolean readOnly_p) {
        this._isReadOnly = readOnly_p;
        this._resourceSet = resourceSet_p;
        this._resources = new ArrayList<Resource>();
        this._rootResources = new ArrayList<Resource>();
        this._includedResources = new HashBinaryRelation<Resource, Resource>();
        this._referencedResources = new HashBinaryRelation<Resource, Resource>();
        this._initiallyPresentResources = new HashSet<Resource>();
        this._initiallyPresentResources.addAll((Collection<Resource>)this._resourceSet.getResources());
        this._loadedResources = new HashSet<Resource>();
        if (this._resourceSet instanceof IEditingDomainProvider) {
            this._editingDomain = ((IEditingDomainProvider)this._resourceSet).getEditingDomain();
        }
    }

    @Override
    public boolean add(EObject element_p) {
        boolean result = false;
        Resource defaultResource = this.getResourceForNewRoot(element_p);
        if (defaultResource != null) {
            defaultResource.getContents().add((Object)element_p);
            result = true;
        }
        return result;
    }

    @Override
    public boolean add(EObject source_p, EReference reference_p, EObject value_p) {
        Resource oldResource = value_p.eResource();
        boolean wasRoot = oldResource != null && oldResource.getContents().contains((Object)value_p);
        Object formerId = this.getExtrinsicID(value_p);
        boolean result = super.add(source_p, reference_p, value_p);
        if (wasRoot && reference_p.isContainment()) {
            oldResource.getContents().remove((Object)value_p);
        }
        if (formerId != null) {
            this.setExtrinsicID(value_p, formerId);
        }
        return result;
    }

    protected void addNewResource(Resource resource_p) {
        this._resources.add(resource_p);
    }

    protected boolean containsUnnecessaryProxies(Collection<EObject> collection_p, EObject source_p) {
        for (EObject current : collection_p) {
            if (!current.eIsProxy() || current == ModelImplUtil.resolveIfLoaded(current, source_p)) continue;
            return true;
        }
        return false;
    }

    protected void explorationFinished() {
        AdapterFactoryEditingDomain afEditingDomain;
        Map readOnlyMap;
        this._state = ScopeState.FULLY_EXPLORED;
        this._loadedResources.addAll((Collection<Resource>)this._resourceSet.getResources());
        this._loadedResources.removeAll(this._initiallyPresentResources);
        this._initiallyPresentResources.clear();
        if (this.isReadOnly() && this._editingDomain instanceof AdapterFactoryEditingDomain && (readOnlyMap = (afEditingDomain = (AdapterFactoryEditingDomain)this._editingDomain).getResourceToReadOnlyMap()) != null) {
            for (Resource loadedResource : this._loadedResources) {
                readOnlyMap.put(loadedResource, Boolean.TRUE);
            }
        }
    }

    @Override
    public List<EObject> get(EObject source_p, EReference reference_p) {
        List<EObject> result = super.get(source_p, reference_p);
        boolean requiresResolution = this.containsUnnecessaryProxies(result, source_p);
        if (requiresResolution) {
            result = this.get(source_p, reference_p, true);
        }
        return result;
    }

    @Override
    public TreeIterator<EObject> getAllContents() {
        return new ExpandingMultiResourceTreeIterator();
    }

    @Override
    public List<EObject> getContents() {
        FArrayList result = new FArrayList();
        for (Resource resource : this._rootResources) {
            result.addAll(resource.getContents());
        }
        return Collections.unmodifiableList(result);
    }

    protected Collection<EReference> getCrossReferencesInScope(EObject element_p) {
        return new ArrayList<EReference>();
    }

    @Override
    public Object getExtrinsicID(EObject element_p) {
        return super.getExtrinsicID(element_p);
    }

    @Override
    public Resource getHoldingResource() {
        return this._rootResources.isEmpty() ? null : this._rootResources.get(0);
    }

    public List<Resource> getIncludedResources(Resource resource_p) {
        return this._includedResources.get(resource_p);
    }

    protected Map<Object, Object> getLoadOptions(Resource resource_p) {
        return new HashMap<Object, Object>();
    }

    @Override
    public Object getOriginator() {
        return this.getHoldingResource();
    }

    public List<Resource> getReferencedResources(Resource resource_p) {
        return this._referencedResources.get(resource_p);
    }

    public List<Resource> getRootResources() {
        return Collections.unmodifiableList(this._rootResources);
    }

    protected List<Resource> getRelevantReferencedResources(EObject element_p) {
        FOrderedSet<Resource> result = new FOrderedSet<Resource>();
        Collection<EReference> refsInScope = this.getCrossReferencesInScope(element_p);
        for (EReference ref : refsInScope) {
            if (ref.isContainment() || ref.isContainer() || !element_p.eIsSet((EStructuralFeature)ref)) continue;
            List<EObject> values = this.get(element_p, ref, true);
            for (EObject value : values) {
                Resource valueResource = value.eResource();
                if (valueResource == null) continue;
                result.add(valueResource);
            }
        }
        return result;
    }

    protected Resource getResourceForNewRoot(EObject newRoot_p) {
        for (Resource resource : this._resources) {
            if (!this.isSuitableFor(resource, newRoot_p)) continue;
            return resource;
        }
        return null;
    }

    public List<Resource> getResources() {
        return Collections.unmodifiableList(this._resources);
    }

    public boolean isFullyExplored() {
        return this._state == ScopeState.FULLY_EXPLORED;
    }

    @Override
    public boolean isLoaded() {
        return this._state != ScopeState.INITIALIZED && this._state != ScopeState.UNLOADED;
    }

    @Override
    public boolean isReadOnly() {
        return this._isReadOnly;
    }

    protected boolean isSuitableFor(Resource resource_p, EObject root_p) {
        return true;
    }

    @Override
    public boolean load() throws Exception {
        boolean result = false;
        if (this._state == ScopeState.INITIALIZED || this._state == ScopeState.LOADED) {
            for (Resource rootResource : this._rootResources) {
                Map<Object, Object> options = this.getLoadOptions(rootResource);
                rootResource.load(options);
            }
            this._state = ScopeState.LOADED;
            result = true;
        }
        return result;
    }

    protected final void notifyInclusion(Resource including_p, Resource included_p) {
        if (!this._resources.contains(included_p)) {
            this.addNewResource(included_p);
        }
        this._includedResources.add(including_p, included_p);
        this._rootResources.remove(included_p);
        this._referencedResources.remove(including_p, included_p);
    }

    protected final void notifyReference(Resource source_p, Resource target_p) {
        if (!this._resources.contains(target_p)) {
            this.addNewResource(target_p);
            this._rootResources.add(target_p);
            this._referencedResources.add(source_p, target_p);
        }
    }

    @Override
    public boolean save() throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        for (Resource resource : this.getResources()) {
            resource.save(options);
        }
        return true;
    }

    @Override
    public boolean setExtrinsicID(EObject element_p, Object id_p) {
        return super.setExtrinsicID(element_p, id_p);
    }

    @Override
    public List<Resource> unload() {
        for (Resource loadedResource : this._loadedResources) {
            for (Adapter adapter : new ArrayList(loadedResource.eAdapters())) {
                if (!(adapter instanceof ECrossReferenceAdapter)) continue;
                loadedResource.eAdapters().remove((Object)adapter);
            }
        }
        for (Resource loadedResource : this._loadedResources) {
            this.unloadResource(loadedResource);
        }
        ArrayList<Resource> result = new ArrayList<Resource>(this._loadedResources);
        this._loadedResources.clear();
        if (!result.isEmpty()) {
            this._state = ScopeState.UNLOADED;
        }
        return result;
    }

    protected void unloadResource(Resource resource_p) {
        try {
            if (resource_p.isLoaded()) {
                resource_p.unload();
            }
            this._resourceSet.getResources().remove((Object)resource_p);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected class ExpandingMultiResourceTreeIterator
    extends MultiResourceTreeIterator {
        protected final Set<Resource> _exploredResources;
        protected EObject _next;
        protected Resource _currentResource;
        protected boolean _finished;

        public ExpandingMultiResourceTreeIterator() {
            super(new DynamicUniqueListIterator<Resource>(FragmentedModelScope.this._resources));
            this._exploredResources = new LinkedHashSet<Resource>();
            this._next = null;
            this._currentResource = null;
            this._finished = false;
        }

        protected boolean checkNextResource() {
            boolean result = false;
            while ((this._contentIterator == null || !this._contentIterator.hasNext()) && this._resourceIterator.hasNext()) {
                result = true;
                Resource nextResource = (Resource)this._resourceIterator.next();
                if (this._exploredResources.contains(nextResource)) continue;
                this._contentIterator = nextResource.getAllContents();
            }
            return result;
        }

        public boolean hasNext() {
            this.update();
            return this._next != null;
        }

        public EObject next() {
            if (this.hasNext()) {
                EObject result = this._next;
                this._currentResource = this._next.eResource();
                this._next = null;
                return result;
            }
            throw new NoSuchElementException();
        }

        protected void update() {
            while (this._next == null && !this._finished) {
                boolean firstExploration;
                boolean resourceChangedInList = this.checkNextResource();
                boolean bl = firstExploration = FragmentedModelScope.this._state != ScopeState.FULLY_EXPLORED;
                if (this._contentIterator == null || !this._contentIterator.hasNext()) {
                    this._finished = true;
                    this._exploredResources.clear();
                    this._currentResource = null;
                    if (!firstExploration) continue;
                    FragmentedModelScope.this.explorationFinished();
                    continue;
                }
                EObject candidate = (EObject)this._contentIterator.next();
                boolean candidateOK = true;
                Resource candidateResource = candidate.eResource();
                if (candidateResource != null) {
                    boolean resourceAlreadyExplored = !this._exploredResources.add(candidateResource);
                    boolean resourceChangedByInclusion = false;
                    boolean bl2 = resourceChangedByInclusion = !resourceChangedInList && this._currentResource != null && this._currentResource != candidateResource;
                    if (resourceChangedByInclusion && firstExploration) {
                        FragmentedModelScope.this.notifyInclusion(this._currentResource, candidateResource);
                    }
                    if (resourceAlreadyExplored && resourceChangedByInclusion) {
                        this._contentIterator.prune();
                        candidateOK = false;
                    }
                }
                if (!candidateOK) continue;
                this._next = candidate;
                if (!firstExploration || candidateResource == null) continue;
                for (Resource additionalResource : FragmentedModelScope.this.getRelevantReferencedResources(this._next)) {
                    FragmentedModelScope.this.notifyReference(candidateResource, additionalResource);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ScopeState {
        INITIALIZED,
        LOADED,
        FULLY_EXPLORED,
        UNLOADED;

    }
}

