/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.specification.ext;

import org.eclipse.emf.diffmerge.api.IDiffPolicy;
import org.eclipse.emf.diffmerge.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.impl.policies.ConfigurableDiffPolicy;
import org.eclipse.emf.diffmerge.impl.policies.ConfigurableMatchPolicy;
import org.eclipse.emf.diffmerge.impl.policies.DefaultMatchPolicy;
import org.eclipse.emf.diffmerge.ui.specification.IModelScopeDefinition;
import org.eclipse.emf.diffmerge.ui.specification.ext.ConfigureComparisonDialog;
import org.eclipse.emf.diffmerge.ui.specification.ext.DefaultComparisonMethod;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ConfigurableComparisonMethod
extends DefaultComparisonMethod {
    protected static ConfigureComparisonDialog.ComparisonMethodConfigurationData __lastConfiguration = null;

    public ConfigurableComparisonMethod(IModelScopeDefinition leftScopeSpec_p, IModelScopeDefinition rightScopeSpec_p, IModelScopeDefinition ancestorScopeSpec_p) {
        super(leftScopeSpec_p, rightScopeSpec_p, ancestorScopeSpec_p);
        this.update(__lastConfiguration);
    }

    public void configure() {
        ConfigureComparisonDialog.ComparisonMethodConfigurationData data;
        int confirmed;
        Shell shell = this.getShell();
        if (shell != null && (confirmed = new ConfigureComparisonDialog(shell, data = new ConfigureComparisonDialog.ComparisonMethodConfigurationData(this)).open()) == 0) {
            this.configurationConfirmed(data);
        }
    }

    protected void configurationConfirmed(ConfigureComparisonDialog.ComparisonMethodConfigurationData data_p) {
        this.update(data_p);
        __lastConfiguration = data_p;
    }

    protected IDiffPolicy createDiffPolicy() {
        return new ConfigurableDiffPolicy();
    }

    protected IMatchPolicy createMatchPolicy() {
        return new ConfigurableMatchPolicy();
    }

    public Shell getShell() {
        Shell result;
        try {
            result = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public boolean isConfigurable() {
        return true;
    }

    protected void update(ConfigureComparisonDialog.ComparisonMethodConfigurationData data_p) {
        IDiffPolicy diffPolicy;
        if (data_p == null) {
            return;
        }
        IMatchPolicy matchPolicy = this.getMatchPolicy();
        if (matchPolicy instanceof DefaultMatchPolicy) {
            ((DefaultMatchPolicy)matchPolicy).setKeepMatchIDs(data_p.isKeepMatchIDs());
        }
        if (matchPolicy instanceof ConfigurableMatchPolicy) {
            ConfigurableMatchPolicy cMatchPolicy = (ConfigurableMatchPolicy)matchPolicy;
            for (ConfigurableMatchPolicy.MatchCriterionKind criterion : cMatchPolicy.getApplicableCriteria()) {
                cMatchPolicy.setUseMatchCriterion(criterion, data_p.useMatchCriterion(criterion));
            }
        }
        if ((diffPolicy = this.getDiffPolicy()) instanceof ConfigurableDiffPolicy) {
            ConfigurableDiffPolicy cDiffPolicy = (ConfigurableDiffPolicy)diffPolicy;
            cDiffPolicy.setIgnoreOrders(data_p.isIgnoreOrders());
        }
    }
}

