/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.diagrams.sirius.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.diffmerge.patterns.diagrams.sirius.util.ColorUtil;
import org.eclipse.emf.diffmerge.patterns.diagrams.sirius.util.SiriusLayersUtil;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.EdgeBendpoint;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.EdgeLayout;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.NodeLayout;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.NodeStyle;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplateFontStyle;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatepatternsFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.ConnectorStyle;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.FillStyle;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.ShapeStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.BeginLabelStyle;
import org.eclipse.sirius.diagram.BorderedStyle;
import org.eclipse.sirius.diagram.BundledImage;
import org.eclipse.sirius.diagram.CenterLabelStyle;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.Dot;
import org.eclipse.sirius.diagram.EdgeArrows;
import org.eclipse.sirius.diagram.EdgeRouting;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.Ellipse;
import org.eclipse.sirius.diagram.EndLabelStyle;
import org.eclipse.sirius.diagram.FlatContainerStyle;
import org.eclipse.sirius.diagram.LineStyle;
import org.eclipse.sirius.diagram.Lozenge;
import org.eclipse.sirius.diagram.Note;
import org.eclipse.sirius.diagram.Square;
import org.eclipse.sirius.viewpoint.BasicLabelStyle;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.DStylizable;
import org.eclipse.sirius.viewpoint.FontFormat;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.swt.graphics.Point;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LayoutUtil {
    public static final String COLOR_CUSTOM_FEATURE = "color";
    private static final String DEFAULT_FONT_STYLE_NAME = "default";

    private LayoutUtil() {
    }

    public static void applyEdgeLayout(Edge edge_p, EdgeLayout edgeLayout_p) {
        if (!edgeLayout_p.getBendpoints().isEmpty()) {
            RelativeBendpoints gmfBendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
            LayoutUtil.edgeLayoutToBendpoints(edgeLayout_p, (Bendpoints)gmfBendpoints);
            edge_p.setBendpoints((Bendpoints)gmfBendpoints);
        }
    }

    public static void applyEdgeStyle(Edge edge_p, EdgeLayout edgeLayout_p) {
        EObject doremiElement;
        ConnectorStyle connectorstyle = null;
        if (edge_p.getElement() != null && (doremiElement = edge_p.getElement()) instanceof DStylizable) {
            Iterator style = ((DStylizable)doremiElement).getStyle();
            if (style != null) {
                style.refresh();
            }
            if (style instanceof EdgeStyle) {
                EdgeStyle edgestyle = (EdgeStyle)style;
                if (edgeLayout_p.getLinecolor() != -1) {
                    edgestyle.setStrokeColor(ColorUtil.convertIntColorToRGBValues(edgeLayout_p.getLinecolor()));
                    style.getCustomFeatures().add((Object)DiagramPackage.eINSTANCE.getEdgeStyle_StrokeColor().getName());
                }
            }
        }
        if (edgeLayout_p.getFontStyle() != null) {
            for (Object style : edge_p.getStyles()) {
                if (style instanceof FontStyle) {
                    FontStyle fontstyle = (FontStyle)style;
                    LayoutUtil.applyFontStyleToEdge(fontstyle, edgeLayout_p, edge_p.getElement());
                    continue;
                }
                if (!(style instanceof ConnectorStyle)) continue;
                connectorstyle = (ConnectorStyle)style;
                if (edgeLayout_p.getLinecolor() != -1) {
                    connectorstyle.setLineColor(edgeLayout_p.getLinecolor());
                }
                if (edgeLayout_p.getLinewidth() == -1) continue;
                connectorstyle.setLineWidth(edgeLayout_p.getLinewidth());
            }
        }
        if (edgeLayout_p.getOwnedStyle() != null) {
            EObject element = edge_p.getElement();
            org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.EdgeStyle edgestyle = edgeLayout_p.getOwnedStyle();
            if (element instanceof DEdge) {
                DEdge dedge = (DEdge)element;
                EdgeStyle ownedstyle = dedge.getOwnedStyle();
                if (edgeLayout_p.getLinewidth() != -1) {
                    ownedstyle.setSize(Integer.valueOf(edgeLayout_p.getLinewidth()));
                    ownedstyle.getCustomFeatures().add((Object)DiagramPackage.eINSTANCE.getEdgeStyle_Size().getName());
                }
                if (edgestyle.getLinestyle() != null) {
                    LayoutUtil.setEdgeLineStyle(edgestyle.getLinestyle(), ownedstyle);
                    ownedstyle.getCustomFeatures().add((Object)DiagramPackage.eINSTANCE.getEdgeStyle_LineStyle().getName());
                }
                if (edgestyle.getRoutingstyle() != null) {
                    LayoutUtil.setEdgeRoutingStyle(edgestyle.getRoutingstyle(), ownedstyle);
                    ownedstyle.getCustomFeatures().add((Object)DiagramPackage.eINSTANCE.getEdgeStyle_RoutingStyle().getName());
                    if (connectorstyle != null) {
                        if ("straight".equals(edgestyle.getRoutingstyle())) {
                            connectorstyle.setRouting(Routing.MANUAL_LITERAL);
                        } else if ("manhattan".equals(edgestyle.getRoutingstyle())) {
                            connectorstyle.setRouting(Routing.RECTILINEAR_LITERAL);
                        } else if ("tree".equals(edgestyle.getRoutingstyle())) {
                            connectorstyle.setRouting(Routing.TREE_LITERAL);
                        }
                    }
                }
                if (edgestyle.getSourcearrow() != null) {
                    LayoutUtil.setEdgeSourceArrowStyle(edgestyle.getSourcearrow(), ownedstyle);
                    ownedstyle.getCustomFeatures().add((Object)DiagramPackage.eINSTANCE.getEdgeStyle_SourceArrow().getName());
                }
                if (edgestyle.getTargetarrow() != null) {
                    LayoutUtil.setEdgeTargetArrowStyle(edgestyle.getTargetarrow(), ownedstyle);
                    ownedstyle.getCustomFeatures().add((Object)DiagramPackage.eINSTANCE.getEdgeStyle_TargetArrow().getName());
                }
            }
        }
    }

    public static void applyFontStyleToEdge(FontStyle fontstyle_p, EdgeLayout edgelayout_p, EObject element_p) {
        TemplateFontStyle edgefontstyle;
        EdgeStyle edgestyle;
        DEdge edge;
        CenterLabelStyle centerlabelstyle = null;
        EndLabelStyle endlabelstyle = null;
        BeginLabelStyle beginlabelstyle = null;
        ArrayList<String> customfeatures = new ArrayList<String>();
        if (element_p instanceof DEdge && (edge = (DEdge)element_p).getOwnedStyle() != null) {
            edgestyle = edge.getOwnedStyle();
            if (edgelayout_p.getCenterFontStyle() != null) {
                CenterLabelStyle newcenterstyle = DiagramFactory.eINSTANCE.createCenterLabelStyle();
                edgestyle.setCenterLabelStyle(newcenterstyle);
                centerlabelstyle = edgestyle.getCenterLabelStyle();
                LayoutUtil.applyLabelStyleToEdge(edgelayout_p.getCenterFontStyle(), (BasicLabelStyle)centerlabelstyle);
            }
            if (edgelayout_p.getEndFontStyle() != null) {
                EndLabelStyle newendstyle = DiagramFactory.eINSTANCE.createEndLabelStyle();
                edgestyle.setEndLabelStyle(newendstyle);
                endlabelstyle = edgestyle.getEndLabelStyle();
                LayoutUtil.applyLabelStyleToEdge(edgelayout_p.getEndFontStyle(), (BasicLabelStyle)endlabelstyle);
            }
            if (edgelayout_p.getBeginFontStyle() != null) {
                BeginLabelStyle newbeginstyle = DiagramFactory.eINSTANCE.createBeginLabelStyle();
                edgestyle.setBeginLabelStyle(newbeginstyle);
                beginlabelstyle = edgestyle.getBeginLabelStyle();
                LayoutUtil.applyLabelStyleToEdge(edgelayout_p.getBeginFontStyle(), (BasicLabelStyle)beginlabelstyle);
            }
        }
        if (!DEFAULT_FONT_STYLE_NAME.equals((edgefontstyle = edgelayout_p.getFontStyle()).getName())) {
            fontstyle_p.setFontName(edgefontstyle.getName());
        }
        if (edgefontstyle.isStrikethrough()) {
            fontstyle_p.setStrikeThrough(edgefontstyle.isStrikethrough());
        }
        if (edgefontstyle.isUnderline()) {
            fontstyle_p.setUnderline(edgefontstyle.isUnderline());
        }
        if (edgefontstyle.isBold()) {
            fontstyle_p.setBold(edgefontstyle.isBold());
            customfeatures.add(ViewpointPackage.eINSTANCE.getBasicLabelStyle_LabelFormat().getName());
        }
        if (edgefontstyle.isItalic()) {
            fontstyle_p.setItalic(edgefontstyle.isItalic());
            customfeatures.add(ViewpointPackage.eINSTANCE.getBasicLabelStyle_LabelFormat().getName());
        }
        if (edgefontstyle.getColor() != -1) {
            fontstyle_p.setFontColor(edgefontstyle.getColor());
            customfeatures.add(ViewpointPackage.eINSTANCE.getBasicLabelStyle_LabelColor().getName());
        }
        if (edgefontstyle.getHeight() != -1) {
            fontstyle_p.setFontHeight(edgefontstyle.getHeight());
            customfeatures.add(ViewpointPackage.eINSTANCE.getBasicLabelStyle_LabelSize().getName());
        }
        if (element_p instanceof EdgeStyle) {
            edgestyle = (EdgeStyle)element_p;
            edgestyle.getCustomFeatures().add((Object)DiagramPackage.eINSTANCE.getEdgeStyle_StrokeColor().getName());
            edgestyle.setStrokeColor(null);
            edgestyle.getCenterLabelStyle().setLabelColor(ColorUtil.convertIntColorToRGBValues(edgefontstyle.getColor()));
            edgestyle.getCenterLabelStyle().setLabelSize(edgefontstyle.getHeight());
            if (edgefontstyle.isItalic() && edgefontstyle.isBold()) {
                edgestyle.getCenterLabelStyle().setLabelFormat(FontFormat.BOLD_ITALIC_LITERAL);
                customfeatures.add(ViewpointPackage.eINSTANCE.getBasicLabelStyle_LabelFormat().getName());
            } else if (edgefontstyle.isItalic()) {
                edgestyle.getCenterLabelStyle().setLabelFormat(FontFormat.ITALIC_LITERAL);
                customfeatures.add(ViewpointPackage.eINSTANCE.getBasicLabelStyle_LabelFormat().getName());
            } else if (edgefontstyle.isBold()) {
                edgestyle.getCenterLabelStyle().setLabelFormat(FontFormat.BOLD_LITERAL);
                customfeatures.add(ViewpointPackage.eINSTANCE.getBasicLabelStyle_LabelFormat().getName());
            }
        }
    }

    public static void applyLabelStyleToEdge(TemplateFontStyle fontStyle_p, BasicLabelStyle basicLabelStyle_p) {
        EList customFeatures = basicLabelStyle_p.getCustomFeatures();
        if (fontStyle_p.getColor() != -1) {
            basicLabelStyle_p.setLabelColor(ColorUtil.convertIntColorToRGBValues(fontStyle_p.getColor()));
            customFeatures.add(ViewpointPackage.eINSTANCE.getBasicLabelStyle_LabelColor().getName());
        }
        if (fontStyle_p.getHeight() != -1) {
            basicLabelStyle_p.setLabelSize(fontStyle_p.getHeight());
            customFeatures.add(ViewpointPackage.eINSTANCE.getBasicLabelStyle_LabelSize().getName());
        }
        if (fontStyle_p.isBold() && fontStyle_p.isItalic()) {
            basicLabelStyle_p.setLabelFormat(FontFormat.BOLD_ITALIC_LITERAL);
            customFeatures.add(ViewpointPackage.eINSTANCE.getBasicLabelStyle_LabelFormat().getName());
        } else if (fontStyle_p.isItalic()) {
            basicLabelStyle_p.setLabelFormat(FontFormat.ITALIC_LITERAL);
            customFeatures.add(ViewpointPackage.eINSTANCE.getBasicLabelStyle_LabelFormat().getName());
        } else if (fontStyle_p.isBold()) {
            basicLabelStyle_p.setLabelFormat(FontFormat.BOLD_LITERAL);
            customFeatures.add(ViewpointPackage.eINSTANCE.getBasicLabelStyle_LabelFormat().getName());
        }
    }

    public static void setEdgeLineStyle(String edgeLineStyle_p, EdgeStyle edgeStyle_p) {
        if (LineStyle.DASH_LITERAL.getLiteral().equals(edgeLineStyle_p)) {
            edgeStyle_p.setLineStyle(LineStyle.DASH_LITERAL);
        } else if (LineStyle.DASH_DOT_LITERAL.getLiteral().equals(edgeLineStyle_p)) {
            edgeStyle_p.setLineStyle(LineStyle.DASH_DOT_LITERAL);
        } else if (LineStyle.DOT_LITERAL.getLiteral().equals(edgeLineStyle_p)) {
            edgeStyle_p.setLineStyle(LineStyle.DOT_LITERAL);
        } else if (LineStyle.SOLID_LITERAL.getLiteral().equals(edgeLineStyle_p)) {
            edgeStyle_p.setLineStyle(LineStyle.SOLID_LITERAL);
        }
    }

    public static void setEdgeRoutingStyle(String edgeRouting_p, EdgeStyle edgeStyle_p) {
        if (EdgeRouting.MANHATTAN_LITERAL.getLiteral().equals(edgeRouting_p)) {
            edgeStyle_p.setRoutingStyle(EdgeRouting.MANHATTAN_LITERAL);
        } else if (EdgeRouting.STRAIGHT_LITERAL.getLiteral().equals(edgeRouting_p)) {
            edgeStyle_p.setRoutingStyle(EdgeRouting.STRAIGHT_LITERAL);
        } else if (EdgeRouting.TREE_LITERAL.getLiteral().equals(edgeRouting_p)) {
            edgeStyle_p.setRoutingStyle(EdgeRouting.TREE_LITERAL);
        }
    }

    public static void setEdgeTargetArrowStyle(String arrowType, EdgeStyle edgeStyle_p) {
        if (EdgeArrows.FILL_DIAMOND_LITERAL.getLiteral().equals(arrowType)) {
            edgeStyle_p.setTargetArrow(EdgeArrows.FILL_DIAMOND_LITERAL);
        } else if (EdgeArrows.DIAMOND_LITERAL.getLiteral().equals(arrowType)) {
            edgeStyle_p.setTargetArrow(EdgeArrows.DIAMOND_LITERAL);
        } else if (EdgeArrows.INPUT_ARROW_LITERAL.getLiteral().equals(arrowType)) {
            edgeStyle_p.setTargetArrow(EdgeArrows.INPUT_ARROW_LITERAL);
        } else if (EdgeArrows.INPUT_ARROW_WITH_DIAMOND_LITERAL.getLiteral().equals(arrowType)) {
            edgeStyle_p.setTargetArrow(EdgeArrows.INPUT_ARROW_WITH_DIAMOND_LITERAL);
        } else if (EdgeArrows.INPUT_ARROW_WITH_FILL_DIAMOND_LITERAL.getLiteral().equals(arrowType)) {
            edgeStyle_p.setTargetArrow(EdgeArrows.INPUT_ARROW_WITH_FILL_DIAMOND_LITERAL);
        } else if (EdgeArrows.INPUT_CLOSED_ARROW_LITERAL.getLiteral().equals(arrowType)) {
            edgeStyle_p.setTargetArrow(EdgeArrows.INPUT_CLOSED_ARROW_LITERAL);
        } else if (EdgeArrows.INPUT_FILL_CLOSED_ARROW_LITERAL.getLiteral().equals(arrowType)) {
            edgeStyle_p.setTargetArrow(EdgeArrows.INPUT_FILL_CLOSED_ARROW_LITERAL);
        } else if (EdgeArrows.NO_DECORATION_LITERAL.getLiteral().equals(arrowType)) {
            edgeStyle_p.setTargetArrow(EdgeArrows.NO_DECORATION_LITERAL);
        } else if (EdgeArrows.OUTPUT_ARROW_LITERAL.getLiteral().equals(arrowType)) {
            edgeStyle_p.setTargetArrow(EdgeArrows.OUTPUT_ARROW_LITERAL);
        } else if (EdgeArrows.OUTPUT_CLOSED_ARROW_LITERAL.getLiteral().equals(arrowType)) {
            edgeStyle_p.setTargetArrow(EdgeArrows.OUTPUT_CLOSED_ARROW_LITERAL);
        } else if (EdgeArrows.OUTPUT_FILL_CLOSED_ARROW_LITERAL.getLiteral().equals(arrowType)) {
            edgeStyle_p.setTargetArrow(EdgeArrows.OUTPUT_FILL_CLOSED_ARROW_LITERAL);
        }
    }

    public static void setEdgeSourceArrowStyle(String arrowType, EdgeStyle edgeStyle_p) {
        if (EdgeArrows.FILL_DIAMOND_LITERAL.getLiteral().equals(arrowType)) {
            edgeStyle_p.setSourceArrow(EdgeArrows.FILL_DIAMOND_LITERAL);
        } else if (EdgeArrows.DIAMOND_LITERAL.getLiteral().equals(arrowType)) {
            edgeStyle_p.setSourceArrow(EdgeArrows.DIAMOND_LITERAL);
        } else if (EdgeArrows.INPUT_ARROW_LITERAL.getLiteral().equals(arrowType)) {
            edgeStyle_p.setSourceArrow(EdgeArrows.INPUT_ARROW_LITERAL);
        } else if (EdgeArrows.INPUT_ARROW_WITH_DIAMOND_LITERAL.getLiteral().equals(arrowType)) {
            edgeStyle_p.setSourceArrow(EdgeArrows.INPUT_ARROW_WITH_DIAMOND_LITERAL);
        } else if (EdgeArrows.INPUT_ARROW_WITH_FILL_DIAMOND_LITERAL.getLiteral().equals(arrowType)) {
            edgeStyle_p.setSourceArrow(EdgeArrows.INPUT_ARROW_WITH_FILL_DIAMOND_LITERAL);
        } else if (EdgeArrows.INPUT_CLOSED_ARROW_LITERAL.getLiteral().equals(arrowType)) {
            edgeStyle_p.setSourceArrow(EdgeArrows.INPUT_CLOSED_ARROW_LITERAL);
        } else if (EdgeArrows.INPUT_FILL_CLOSED_ARROW_LITERAL.getLiteral().equals(arrowType)) {
            edgeStyle_p.setSourceArrow(EdgeArrows.INPUT_FILL_CLOSED_ARROW_LITERAL);
        } else if (EdgeArrows.NO_DECORATION_LITERAL.getLiteral().equals(arrowType)) {
            edgeStyle_p.setSourceArrow(EdgeArrows.NO_DECORATION_LITERAL);
        } else if (EdgeArrows.OUTPUT_ARROW_LITERAL.getLiteral().equals(arrowType)) {
            edgeStyle_p.setSourceArrow(EdgeArrows.OUTPUT_ARROW_LITERAL);
        } else if (EdgeArrows.OUTPUT_CLOSED_ARROW_LITERAL.getLiteral().equals(arrowType)) {
            edgeStyle_p.setSourceArrow(EdgeArrows.OUTPUT_CLOSED_ARROW_LITERAL);
        } else if (EdgeArrows.OUTPUT_FILL_CLOSED_ARROW_LITERAL.getLiteral().equals(arrowType)) {
            edgeStyle_p.setSourceArrow(EdgeArrows.OUTPUT_FILL_CLOSED_ARROW_LITERAL);
        }
    }

    public static void applyVector(Location location_p, int vx_p, int vy_p) {
        location_p.setX(location_p.getX() + vx_p);
        location_p.setY(location_p.getY() + vy_p);
    }

    public static void edgeLayoutToBendpoints(EdgeLayout edgeLayout_p, Bendpoints bendpoints_p) {
        if (!edgeLayout_p.getBendpoints().isEmpty() && bendpoints_p instanceof RelativeBendpoints) {
            RelativeBendpoints target = (RelativeBendpoints)bendpoints_p;
            ArrayList<RelativeBendpoint> newBendpoints = new ArrayList<RelativeBendpoint>(edgeLayout_p.getBendpoints().size());
            for (EdgeBendpoint neutralBendpoint : edgeLayout_p.getBendpoints()) {
                RelativeBendpoint targetBendpoint = LayoutUtil.toGMFBendpoint(neutralBendpoint);
                newBendpoints.add(targetBendpoint);
            }
            target.setPoints(newBendpoints);
        }
    }

    public static void nodeLayoutToBounds(NodeLayout nodeLayout_p, Bounds bounds_p) {
        bounds_p.setX(nodeLayout_p.getX());
        bounds_p.setY(nodeLayout_p.getY());
        bounds_p.setHeight(nodeLayout_p.getHeight());
        bounds_p.setWidth(nodeLayout_p.getWidth());
    }

    public static EdgeBendpoint toEdgeBendpoint(RelativeBendpoint gmfBendpoint_p) {
        EdgeBendpoint result = TemplatepatternsFactory.eINSTANCE.createEdgeBendpoint();
        result.setSourceX(gmfBendpoint_p.getSourceX());
        result.setSourceY(gmfBendpoint_p.getSourceY());
        result.setTargetX(gmfBendpoint_p.getTargetX());
        result.setTargetY(gmfBendpoint_p.getTargetY());
        return result;
    }

    public static EdgeLayout toEdgeLayout(Bendpoints bendpoints_p, int selectedLineColor_p, int selectedLineWidth_p, LineStyle selectedLineStyle_p, EdgeRouting selectedEdgeRouting_p, EdgeArrows selectedTargetArrow_p, EdgeArrows selectedSourceArrow_p) {
        EdgeLayout result = TemplatepatternsFactory.eINSTANCE.createEdgeLayout();
        if (bendpoints_p instanceof RelativeBendpoints) {
            List gmfBendpoints = ((RelativeBendpoints)bendpoints_p).getPoints();
            for (RelativeBendpoint gmfBendpoint : gmfBendpoints) {
                EdgeBendpoint resultPoint = LayoutUtil.toEdgeBendpoint(gmfBendpoint);
                result.getBendpoints().add((Object)resultPoint);
            }
        }
        result.setLinecolor(selectedLineColor_p);
        result.setLinewidth(selectedLineWidth_p);
        org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.EdgeStyle edgestyle = TemplatepatternsFactory.eINSTANCE.createEdgeStyle();
        if (selectedLineStyle_p != null) {
            edgestyle.setLinestyle(selectedLineStyle_p.toString());
        }
        if (selectedEdgeRouting_p != null) {
            edgestyle.setRoutingstyle(selectedEdgeRouting_p.toString());
        }
        if (selectedSourceArrow_p != null) {
            edgestyle.setSourcearrow(selectedSourceArrow_p.toString());
        }
        if (selectedTargetArrow_p != null) {
            edgestyle.setTargetarrow(selectedTargetArrow_p.toString());
        }
        result.setOwnedStyle(edgestyle);
        return result;
    }

    public static TemplateFontStyle toTemplateFontStyle(int selectedFontColor_p, String selectedFontName_p, int selectedFontHeight_p, boolean isBold_p, boolean isItalic_p, boolean isUnderline_p, boolean isStrikeThrough_p) {
        TemplateFontStyle result = TemplatepatternsFactory.eINSTANCE.createTemplateFontStyle();
        result.setColor(selectedFontColor_p);
        result.setName(selectedFontName_p);
        result.setHeight(selectedFontHeight_p);
        result.setBold(isBold_p);
        result.setItalic(isItalic_p);
        result.setUnderline(isUnderline_p);
        result.setStrikethrough(isStrikeThrough_p);
        return result;
    }

    public static RelativeBendpoint toGMFBendpoint(EdgeBendpoint bendpoint_p) {
        RelativeBendpoint result = new RelativeBendpoint(bendpoint_p.getSourceX(), bendpoint_p.getSourceY(), bendpoint_p.getTargetX(), bendpoint_p.getTargetY());
        return result;
    }

    public static NodeLayout toNodeLayout(Bounds bounds_p, NodeStyle nodestyle_p, TemplateFontStyle templatefontstyle_p) {
        NodeLayout result = TemplatepatternsFactory.eINSTANCE.createNodeLayout();
        result.setX(bounds_p.getX());
        result.setY(bounds_p.getY());
        result.setHeight(bounds_p.getHeight());
        result.setWidth(bounds_p.getWidth());
        result.setFontStyle(templatefontstyle_p);
        result.setOwnedStyle(nodestyle_p);
        return result;
    }

    public static NodeStyle toTemplateNodeStyle(int borderColor_p, int borderSize_p, int shapeColor_p, int transparency_p, int foregroundColor_p, int backgroundColor_p) {
        NodeStyle nodestyle = TemplatepatternsFactory.eINSTANCE.createNodeStyle();
        nodestyle.setBackgroundcolor(backgroundColor_p);
        nodestyle.setBordercolor(borderColor_p);
        nodestyle.setBordersize(borderSize_p);
        nodestyle.setForegroundcolor(foregroundColor_p);
        nodestyle.setTransparency(transparency_p);
        nodestyle.setShapecolor(shapeColor_p);
        return nodestyle;
    }

    public static List<String> getNodeCustomSpecification(Node node) {
        if (node.getElement() instanceof DNode) {
            DNode dnode = (DNode)node.getElement();
            return new ArrayList<String>((Collection<String>)dnode.getOwnedStyle().getCustomFeatures());
        }
        if (node.getElement() instanceof DNodeContainer) {
            DNodeContainer dnodecontainer = (DNodeContainer)node.getElement();
            return new ArrayList<String>((Collection<String>)dnodecontainer.getOwnedStyle().getCustomFeatures());
        }
        if (node.getElement() instanceof DNodeList) {
            DNodeList dnodelist = (DNodeList)node.getElement();
            return new ArrayList<String>((Collection<String>)dnodelist.getOwnedStyle().getCustomFeatures());
        }
        return new ArrayList<String>();
    }

    public static List<String> getEdgeCustomSpecification(Edge edge) {
        if (edge.getElement() instanceof DEdge) {
            DEdge dedge = (DEdge)edge.getElement();
            return new ArrayList<String>((Collection<String>)dedge.getOwnedStyle().getCustomFeatures());
        }
        return new ArrayList<String>();
    }

    public static void applyNodePatternStyleToDNode(NodeStyle sourcenodestyle_p, Node dnode_p) {
        EList customfeatures = new ArrayList();
        if (!dnode_p.getStyles().isEmpty()) {
            Object targetstyle = dnode_p.getStyles().get(0);
            if (targetstyle instanceof ShapeStyle) {
                ShapeStyle targetshapestyle = (ShapeStyle)targetstyle;
                if (sourcenodestyle_p.getBordercolor() != -1) {
                    targetshapestyle.setLineColor(sourcenodestyle_p.getBordercolor());
                    customfeatures.add(DiagramPackage.eINSTANCE.getBorderedStyle_BorderColor().getName());
                }
                if (sourcenodestyle_p.getBordersize() != -1) {
                    targetshapestyle.setLineWidth(sourcenodestyle_p.getBordersize());
                }
                if (sourcenodestyle_p.getShapecolor() != -1) {
                    targetshapestyle.setFillColor(sourcenodestyle_p.getShapecolor());
                    customfeatures.add(COLOR_CUSTOM_FEATURE);
                }
                sourcenodestyle_p.getTransparency();
            }
            if (dnode_p.getElement() instanceof DStylizable) {
                DStylizable dstylizable = (DStylizable)dnode_p.getElement();
                Style targetelementstyle = dstylizable.getStyle();
                customfeatures = targetelementstyle.getCustomFeatures();
                if (targetelementstyle instanceof BorderedStyle) {
                    BorderedStyle targetborderedstyle = (BorderedStyle)targetelementstyle;
                    if (sourcenodestyle_p.getBordercolor() != -1) {
                        targetborderedstyle.setBorderColor(ColorUtil.convertIntColorToRGBValues(sourcenodestyle_p.getBordercolor()));
                        customfeatures.add(DiagramPackage.eINSTANCE.getBorderedStyle_BorderColor().getName());
                    }
                    if (sourcenodestyle_p.getBordersize() != -1) {
                        targetborderedstyle.setBorderSize(Integer.valueOf(sourcenodestyle_p.getBordersize()));
                        customfeatures.add("borderSizeComputationExpression");
                    }
                }
                if (targetelementstyle instanceof FillStyle) {
                    FillStyle targetfillstyle = (FillStyle)targetelementstyle;
                    if (sourcenodestyle_p.getShapecolor() != -1) {
                        targetfillstyle.setFillColor(sourcenodestyle_p.getShapecolor());
                        customfeatures.add(DiagramPackage.eINSTANCE.getFlatContainerStyle_ForegroundColor().getName());
                        customfeatures.add(DiagramPackage.eINSTANCE.getFlatContainerStyle_BackgroundColor().getName());
                    }
                    if (sourcenodestyle_p.getTransparency() != -1) {
                        targetfillstyle.setTransparency(sourcenodestyle_p.getTransparency());
                    }
                }
                if (targetelementstyle instanceof Square) {
                    Square targetsquare = (Square)targetelementstyle;
                    if (sourcenodestyle_p.getShapecolor() != -1) {
                        targetsquare.setColor(ColorUtil.convertIntColorToRGBValues(sourcenodestyle_p.getShapecolor()));
                        customfeatures.add(DiagramPackage.eINSTANCE.getSquare_Color().getName());
                    }
                }
                if (targetelementstyle instanceof Ellipse) {
                    Ellipse targetellipse = (Ellipse)targetelementstyle;
                    if (sourcenodestyle_p.getShapecolor() != -1) {
                        targetellipse.setColor(ColorUtil.convertIntColorToRGBValues(sourcenodestyle_p.getShapecolor()));
                        customfeatures.add(DiagramPackage.eINSTANCE.getEllipse_Color().getName());
                    }
                }
                if (targetelementstyle instanceof Note) {
                    Note targetnote = (Note)targetelementstyle;
                    if (sourcenodestyle_p.getShapecolor() != -1) {
                        targetnote.setColor(ColorUtil.convertIntColorToRGBValues(sourcenodestyle_p.getShapecolor()));
                        customfeatures.add(DiagramPackage.eINSTANCE.getNote_Color().getName());
                    }
                }
                if (targetelementstyle instanceof Lozenge) {
                    Lozenge targetlozange = (Lozenge)targetelementstyle;
                    if (sourcenodestyle_p.getShapecolor() != -1) {
                        targetlozange.setColor(ColorUtil.convertIntColorToRGBValues(sourcenodestyle_p.getShapecolor()));
                        customfeatures.add(DiagramPackage.eINSTANCE.getLozenge_Color().getName());
                    }
                }
                if (targetelementstyle instanceof BundledImage) {
                    BundledImage targetimage = (BundledImage)targetelementstyle;
                    if (sourcenodestyle_p.getShapecolor() != -1) {
                        targetimage.setColor(ColorUtil.convertIntColorToRGBValues(sourcenodestyle_p.getShapecolor()));
                        customfeatures.add(DiagramPackage.eINSTANCE.getBundledImage_Color().getName());
                    }
                }
                if (targetelementstyle instanceof Dot) {
                    Dot targetdot = (Dot)targetelementstyle;
                    if (sourcenodestyle_p.getShapecolor() != -1) {
                        targetdot.setBackgroundColor(ColorUtil.convertIntColorToRGBValues(sourcenodestyle_p.getShapecolor()));
                        customfeatures.add(DiagramPackage.eINSTANCE.getDot_BackgroundColor().getName());
                    }
                }
                if (targetelementstyle instanceof FlatContainerStyle) {
                    FlatContainerStyle targetflatcontainerstyle = (FlatContainerStyle)targetelementstyle;
                    if (sourcenodestyle_p.getBackgroundcolor() != -1) {
                        targetflatcontainerstyle.setBackgroundColor(ColorUtil.convertIntColorToRGBValues(sourcenodestyle_p.getBackgroundcolor()));
                        customfeatures.add(DiagramPackage.eINSTANCE.getFlatContainerStyle_BackgroundColor().getName());
                    } else {
                        targetflatcontainerstyle.setBackgroundColor(null);
                    }
                    if (sourcenodestyle_p.getForegroundcolor() != -1) {
                        targetflatcontainerstyle.setForegroundColor(ColorUtil.convertIntColorToRGBValues(sourcenodestyle_p.getForegroundcolor()));
                        customfeatures.add(DiagramPackage.eINSTANCE.getFlatContainerStyle_ForegroundColor().getName());
                        customfeatures.add(DiagramPackage.eINSTANCE.getFlatContainerStyle_BackgroundColor().getName());
                    }
                }
                targetelementstyle.refresh();
            }
        }
    }

    public static void applyAbstractDNodePatternFontStyle(TemplateFontStyle sourcefontstyle_p, Node dnode_p) {
        Object mystyleobject;
        DNode nodeelement;
        org.eclipse.sirius.diagram.NodeStyle ownedstyle = null;
        FontStyle style = null;
        EList customfeatures = new ArrayList();
        if (dnode_p.getElement() instanceof DNode) {
            nodeelement = (DNode)dnode_p.getElement();
            ownedstyle = nodeelement.getOwnedStyle();
            customfeatures = ownedstyle.getCustomFeatures();
        } else if (dnode_p.getElement() instanceof DNodeContainer) {
            nodeelement = (DNodeContainer)dnode_p.getElement();
            ownedstyle = nodeelement.getOwnedStyle();
            customfeatures = ownedstyle.getCustomFeatures();
        } else if (dnode_p.getElement() instanceof DNodeList) {
            nodeelement = (DNodeList)dnode_p.getElement();
            ownedstyle = nodeelement.getOwnedStyle();
            customfeatures = ownedstyle.getCustomFeatures();
        }
        if (!dnode_p.getStyles().isEmpty() && (mystyleobject = dnode_p.getStyles().get(0)) instanceof FontStyle) {
            style = (FontStyle)mystyleobject;
        }
        if (ownedstyle != null && ownedstyle instanceof BasicLabelStyle) {
            BasicLabelStyle basiclabelownedstyle = (BasicLabelStyle)ownedstyle;
            if (sourcefontstyle_p != null) {
                if (sourcefontstyle_p.isBold() && sourcefontstyle_p.isItalic()) {
                    customfeatures.add(ViewpointPackage.eINSTANCE.getBasicLabelStyle_LabelFormat().getName());
                    basiclabelownedstyle.setLabelFormat(FontFormat.BOLD_ITALIC_LITERAL);
                } else if (sourcefontstyle_p.isItalic()) {
                    customfeatures.add(ViewpointPackage.eINSTANCE.getBasicLabelStyle_LabelFormat().getName());
                    basiclabelownedstyle.setLabelFormat(FontFormat.ITALIC_LITERAL);
                } else if (sourcefontstyle_p.isBold()) {
                    customfeatures.add(ViewpointPackage.eINSTANCE.getBasicLabelStyle_LabelFormat().getName());
                    basiclabelownedstyle.setLabelFormat(FontFormat.BOLD_LITERAL);
                } else {
                    basiclabelownedstyle.setLabelFormat(FontFormat.NORMAL_LITERAL);
                }
                if (sourcefontstyle_p.getColor() != -1) {
                    basiclabelownedstyle.setLabelColor(ColorUtil.convertIntColorToRGBValues(sourcefontstyle_p.getColor()));
                    customfeatures.add(ViewpointPackage.eINSTANCE.getBasicLabelStyle_LabelColor().getName());
                }
                if (sourcefontstyle_p.getHeight() != -1) {
                    basiclabelownedstyle.setLabelSize(sourcefontstyle_p.getHeight());
                    customfeatures.add(ViewpointPackage.eINSTANCE.getBasicLabelStyle_LabelSize().getName());
                }
            }
        }
        if (style != null) {
            FontStyle fontstyle = style;
            if (sourcefontstyle_p != null) {
                if (sourcefontstyle_p.isBold()) {
                    customfeatures.add(ViewpointPackage.eINSTANCE.getBasicLabelStyle_LabelFormat().getName());
                    fontstyle.setBold(true);
                }
                if (sourcefontstyle_p.isItalic()) {
                    customfeatures.add(ViewpointPackage.eINSTANCE.getBasicLabelStyle_LabelFormat().getName());
                    fontstyle.setItalic(true);
                }
                if (sourcefontstyle_p.isStrikethrough()) {
                    fontstyle.setStrikeThrough(true);
                }
                if (sourcefontstyle_p.isUnderline()) {
                    fontstyle.setUnderline(true);
                }
                if (sourcefontstyle_p.getColor() != -1) {
                    fontstyle.setFontColor(sourcefontstyle_p.getColor());
                    customfeatures.add(ViewpointPackage.eINSTANCE.getBasicLabelStyle_LabelColor().getName());
                }
                if (sourcefontstyle_p.getHeight() != -1) {
                    fontstyle.setFontHeight(sourcefontstyle_p.getHeight());
                    customfeatures.add(ViewpointPackage.eINSTANCE.getBasicLabelStyle_LabelSize().getName());
                }
                if (sourcefontstyle_p.getName() != DEFAULT_FONT_STYLE_NAME) {
                    fontstyle.setFontName(sourcefontstyle_p.getName());
                }
            }
        }
    }

    public static void adjustTemplateFontStyleWithDoremiElement(TemplateFontStyle templateFontStyle_p, DSemanticDecorator doremiElement_p) {
        DEdge edge;
        EdgeStyle edgeStyle;
        CenterLabelStyle centerLabelStyle;
        if (doremiElement_p instanceof DEdge && (centerLabelStyle = (edgeStyle = (edge = (DEdge)doremiElement_p).getOwnedStyle()).getCenterLabelStyle()) != null) {
            templateFontStyle_p.setColor(ColorUtil.convertRGBValuesToIntColor(centerLabelStyle.getLabelColor()));
            templateFontStyle_p.setHeight(centerLabelStyle.getLabelSize());
            if (centerLabelStyle.getLabelFormat() == FontFormat.BOLD_ITALIC_LITERAL) {
                templateFontStyle_p.setItalic(true);
                templateFontStyle_p.setBold(true);
            } else if (centerLabelStyle.getLabelFormat() == FontFormat.BOLD_LITERAL) {
                templateFontStyle_p.setBold(true);
            } else if (centerLabelStyle.getLabelFormat() == FontFormat.ITALIC_LITERAL) {
                templateFontStyle_p.setItalic(true);
            }
        }
    }

    public static void setLocation(DDiagramElement diagramElement_p, Point location) {
        Node node;
        LayoutConstraint constraint;
        List<View> views;
        if (diagramElement_p != null && location != null && !(views = SiriusLayersUtil.upViewpointToGmf((DSemanticDecorator)diagramElement_p)).isEmpty() && views.get(0) instanceof Node && (constraint = (node = (Node)views.get(0)).getLayoutConstraint()) instanceof Bounds) {
            Bounds bounds = (Bounds)constraint;
            bounds.setX(location.x);
            bounds.setY(location.y);
        }
    }

    public static int getHierarchyLevel(DDiagramElement diagramElement_p) {
        int level = 100;
        if (diagramElement_p != null) {
            DDiagram myDiagram = diagramElement_p.getParentDiagram();
            EList directDiagramElements = myDiagram.getOwnedDiagramElements();
            if (directDiagramElements.contains(diagramElement_p)) {
                return 1;
            }
            for (DDiagramElement element : directDiagramElements) {
                int found = -1;
                if (element instanceof DNodeContainer) {
                    DNodeContainer container = (DNodeContainer)element;
                    found = 1 + LayoutUtil.getRelativeHierarchyLevel(diagramElement_p, container);
                }
                if (found <= 0) continue;
                return found;
            }
        }
        return level;
    }

    public static int getRelativeHierarchyLevel(DDiagramElement diagramElement_p, DNodeContainer container_p) {
        int level = -1;
        if (diagramElement_p != null) {
            if (container_p != null) {
                EList directDiagramElements = container_p.getOwnedDiagramElements();
                if (directDiagramElements.contains(diagramElement_p)) {
                    return 1;
                }
                int found = 0;
                for (DDiagramElement element : directDiagramElements) {
                    if (element instanceof DNodeContainer) {
                        DNodeContainer container = (DNodeContainer)element;
                        found = LayoutUtil.getRelativeHierarchyLevel(diagramElement_p, container);
                    }
                    if (found != 0) break;
                }
                if (found > 0) {
                    level = 1 + found;
                }
            } else {
                return 0;
            }
        }
        return level;
    }

    public static boolean isInstanceParticipant(DDiagramElement diagramElement_p, Collection<EObject> elements_p) {
        return diagramElement_p != null && elements_p != null && diagramElement_p.getTarget() != null && elements_p.contains(diagramElement_p.getTarget());
    }

    public static boolean isHigherLevelNode(DDiagramElement diagramElement_p, Collection<? extends DDiagramElement> elementsList_p, Collection<EObject> instanceElementsList_p) {
        if (diagramElement_p != null && elementsList_p != null && instanceElementsList_p != null && diagramElement_p instanceof AbstractDNode) {
            for (DDiagramElement dDiagramElement : elementsList_p) {
                if (!LayoutUtil.isInstanceParticipant(dDiagramElement, instanceElementsList_p) || !(dDiagramElement instanceof DNodeContainer)) continue;
                DNodeContainer dnode = (DNodeContainer)dDiagramElement;
                if (diagramElement_p.eContainer() != dnode) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isHigherLevelDiagramElementInList(DDiagramElement diagramElement_p, Collection<? extends DDiagramElement> elementsList_p) {
        return diagramElement_p != null && elementsList_p != null && !elementsList_p.contains(diagramElement_p.eContainer());
    }

    public static DDiagramElement getLocalReferenceLocation(DDiagramElement diagramElement_p, List<DDiagramElement> mergedElementsList_p) {
        if (diagramElement_p != null && mergedElementsList_p != null && diagramElement_p instanceof DNodeContainer) {
            DNodeContainer container = (DNodeContainer)diagramElement_p;
            for (DDiagramElement element : mergedElementsList_p) {
                if (!container.getElements().contains((Object)element)) continue;
                return element;
            }
        }
        return null;
    }
}

