/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.util.structures;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StructuresUtil {
    public static final String NULL = "null";

    public static String toCollectionString(Collection<?> collection_p) {
        if (collection_p == null) {
            return NULL;
        }
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        Iterator<?> it = collection_p.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            String segment = element == collection_p ? "(this collection)" : (element == null ? NULL : element.toString());
            builder.append(segment);
            if (!it.hasNext()) continue;
            builder.append('.');
        }
        builder.append(']');
        return builder.toString();
    }

    public static String toMapEntryString(Map.Entry<?, ?> entry_p) {
        if (entry_p == null) {
            return NULL;
        }
        StringBuilder builder = new StringBuilder();
        Object key = entry_p.getKey();
        String keySegment = key == entry_p ? "(this entry)" : (key == null ? NULL : key.toString());
        Object value = entry_p.getValue();
        String valueSegment = value == entry_p ? "(this entry)" : (value == null ? NULL : value.toString());
        builder.append(keySegment);
        builder.append(':');
        builder.append(valueSegment);
        return builder.toString();
    }

    public static String toMapString(Map map_p) {
        if (map_p == null) {
            return NULL;
        }
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        Iterator it = map_p.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String segment = entry == map_p ? "(this)" : (entry == null ? NULL : entry.toString());
            builder.append(segment);
            if (!it.hasNext()) continue;
            builder.append(',');
        }
        builder.append(']');
        return builder.toString();
    }
}

