/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.compare.IPropertyChangeNotifier;
import org.eclipse.compare.contentmergeviewer.IFlushable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.api.scopes.IFeaturedModelScope;
import org.eclipse.emf.diffmerge.api.scopes.IPersistentModelScope;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.diffuidata.ComparisonSelection;
import org.eclipse.emf.diffmerge.ui.diffuidata.UIComparison;
import org.eclipse.emf.diffmerge.ui.util.DiffMergeLabelProvider;
import org.eclipse.emf.diffmerge.ui.util.MiscUtil;
import org.eclipse.emf.diffmerge.ui.viewers.ComparisonResourceManager;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.RedoAction;
import org.eclipse.emf.edit.ui.action.UndoAction;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public abstract class AbstractComparisonViewer
extends Viewer
implements IFlushable,
IPropertyChangeNotifier {
    protected static final String PROPERTY_CURRENT_INPUT = "PROPERTY_CURRENT_INPUT";
    private IActionBars _actionBars;
    private final Set<IPropertyChangeListener> _changeListeners;
    private Composite _control;
    private EMFDiffNode _input;
    private Command _lastCommandBeforeSave;
    private UndoAction _undoAction;
    private RedoAction _redoAction;

    public AbstractComparisonViewer(Composite parent_p, IActionBars actionBars_p) {
        this._actionBars = actionBars_p;
        this._changeListeners = new HashSet<IPropertyChangeListener>(1);
        this._input = null;
        this._lastCommandBeforeSave = null;
        this.setupUndoRedo();
        this._control = this.createControls(parent_p);
        this.hookControl((Control)this._control);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener_p) {
        this._changeListeners.add(listener_p);
    }

    protected abstract Composite createControls(Composite var1);

    protected void executeOnModel(final Runnable runnable_p, final boolean onLeft_p, boolean busyIndicator_p) {
        Runnable finalRunnable = new Runnable(){

            public void run() {
                Resource resource;
                IEditableModelScope impactedScope;
                EditingDomain domain;
                EMFDiffNode input = AbstractComparisonViewer.this.getInput();
                EditingDomain editingDomain = domain = input == null ? null : input.getEditingDomain();
                if (domain == null && input != null && (impactedScope = input.getActualComparison().getScope(input.getRoleForSide(onLeft_p))) instanceof IPersistentModelScope && (resource = ((IPersistentModelScope)impactedScope).getHoldingResource()) != null) {
                    domain = TransactionUtil.getEditingDomain((Resource)resource);
                }
                if (input != null && input.isUndoRedoSupported()) {
                    MiscUtil.executeOnDomain(domain, null, runnable_p);
                } else {
                    MiscUtil.executeAndForget(domain, runnable_p);
                }
            }
        };
        if (busyIndicator_p) {
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)finalRunnable);
        } else {
            finalRunnable.run();
        }
    }

    protected void firePropertyChangeEvent(String propertyName_p, Object newValue_p) {
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, propertyName_p, null, newValue_p);
        for (IPropertyChangeListener listener : this._changeListeners) {
            listener.propertyChange(event);
        }
    }

    public void flush(IProgressMonitor monitor_p) {
        EComparison comparison = this.getComparison();
        if (comparison != null) {
            try {
                IFeaturedModelScope rightScope;
                IFeaturedModelScope leftScope;
                if (this.getInput().isModified(true) && (leftScope = comparison.getScope(this.getInput().getRoleForSide(true))) instanceof IPersistentModelScope.Editable) {
                    ((IPersistentModelScope.Editable)leftScope).save();
                }
                if (this.getInput().isModified(false) && (rightScope = comparison.getScope(this.getInput().getRoleForSide(false))) instanceof IPersistentModelScope.Editable) {
                    ((IPersistentModelScope.Editable)rightScope).save();
                }
                this.firePropertyChangeEvent("DIRTY_STATE", new Boolean(false));
                if (this.getEditingDomain() != null) {
                    this._lastCommandBeforeSave = this.getEditingDomain().getCommandStack().getUndoCommand();
                }
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.getShell(), (String)EMFDiffMergeUIPlugin.LABEL, (String)(String.valueOf(Messages.ComparisonViewer_SaveFailed) + e));
            }
        }
    }

    protected EComparison getComparison() {
        UIComparison uiComparison = this.getUIComparison();
        return uiComparison == null ? null : uiComparison.getActualComparison();
    }

    public Composite getControl() {
        return this._control;
    }

    protected EditingDomain getEditingDomain() {
        return this.getInput() == null ? null : this.getInput().getEditingDomain();
    }

    protected Command getLastCommandBeforeSave() {
        return this._lastCommandBeforeSave;
    }

    protected String getModelName(boolean onLeft_p) {
        IEditableModelScope scope = this.getComparison().getScope(this.getInput().getRoleForSide(onLeft_p));
        return DiffMergeLabelProvider.getInstance().getText(scope);
    }

    public ISelectionProvider getMultiViewerSelectionProvider() {
        return this;
    }

    protected ComparisonResourceManager getResourceManager() {
        return this.getInput() == null ? null : this.getInput().getResourceManager();
    }

    protected Shell getShell() {
        return this.getControl().getShell();
    }

    protected IWorkbenchPartSite getSite() {
        IWorkbenchPartSite result = null;
        try {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPartSite site = window.getActivePage().getActiveEditor().getSite();
            if (site instanceof IWorkbenchPartSite) {
                result = site;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected UIComparison getUIComparison() {
        return this.getInput() == null ? null : this.getInput().getUIComparison();
    }

    public EMFDiffNode getInput() {
        return this._input;
    }

    protected void handleDispose() {
        if (this._actionBars != null) {
            this._actionBars.clearGlobalActionHandlers();
        }
        this._actionBars = null;
        this._changeListeners.clear();
        this._input = null;
        this._control = null;
        this._lastCommandBeforeSave = null;
        this._undoAction = null;
        this._redoAction = null;
    }

    private void hookControl(Control control_p) {
        control_p.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                AbstractComparisonViewer.this.handleDispose();
            }
        });
    }

    protected void inputChanged(Object input_p, Object oldInput_p) {
        if (this._undoAction != null) {
            this._undoAction.setEditingDomain(this.getEditingDomain());
            this._undoAction.update();
        }
        if (this._redoAction != null) {
            this._redoAction.setEditingDomain(this.getEditingDomain());
            this._redoAction.update();
        }
        if (this._actionBars != null) {
            this._actionBars.updateActionBars();
        }
        this.firePropertyChangeEvent(PROPERTY_CURRENT_INPUT, null);
    }

    public void refresh() {
        this.refreshTools();
    }

    protected void refreshTools() {
        if (this._undoAction != null) {
            this._undoAction.update();
        }
        if (this._redoAction != null) {
            this._redoAction.update();
        }
        if (this._actionBars != null) {
            this._actionBars.updateActionBars();
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener_p) {
        this._changeListeners.remove(listener_p);
    }

    public void setInput(Object input_p) {
        if (input_p == null || input_p instanceof EMFDiffNode) {
            EMFDiffNode oldInput = this.getInput();
            this._input = (EMFDiffNode)((Object)input_p);
            this.inputChanged((Object)this._input, (Object)oldInput);
        }
    }

    protected void setupUndoRedo() {
        this._undoAction = new UndoAction(null){

            public void run() {
                AbstractComparisonViewer.this.undoRedo(true);
            }

            public void update() {
                if (this.getEditingDomain() != null) {
                    super.update();
                }
            }
        };
        this._undoAction.setImageDescriptor(EMFDiffMergeUIPlugin.getDefault().getImageDescriptor(EMFDiffMergeUIPlugin.ImageID.UNDO));
        this._redoAction = new RedoAction(){

            public void run() {
                AbstractComparisonViewer.this.undoRedo(false);
            }

            public void update() {
                if (this.getEditingDomain() != null) {
                    super.update();
                }
            }
        };
        this._redoAction.setImageDescriptor(EMFDiffMergeUIPlugin.getDefault().getImageDescriptor(EMFDiffMergeUIPlugin.ImageID.REDO));
        if (this._actionBars != null) {
            this._actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this._undoAction);
            this._actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this._redoAction);
        }
    }

    protected void undoRedo(final boolean undo_p) {
        final EditingDomain editingDomain = this.getEditingDomain();
        if (editingDomain != null) {
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    CommandStack stack = editingDomain.getCommandStack();
                    ComparisonSelection lastActionSelection = AbstractComparisonViewer.this.getUIComparison().getLastActionSelection();
                    if (undo_p && stack.canUndo()) {
                        stack.undo();
                    } else if (!undo_p && stack.canRedo()) {
                        stack.redo();
                    }
                    boolean dirty = stack.getUndoCommand() != AbstractComparisonViewer.this.getLastCommandBeforeSave();
                    AbstractComparisonViewer.this.firePropertyChangeEvent("DIRTY_STATE", new Boolean(dirty));
                    AbstractComparisonViewer.this.undoRedoPerformed(undo_p);
                    if (lastActionSelection != null) {
                        AbstractComparisonViewer.this.setSelection((ISelection)lastActionSelection, true);
                    }
                }
            });
        }
    }

    protected void undoRedoPerformed(boolean undo_p) {
    }
}

