/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.diff.IElementPresence;
import org.eclipse.emf.diffmerge.api.diff.IPresenceDifference;
import org.eclipse.emf.diffmerge.api.diff.IValuePresence;
import org.eclipse.emf.diffmerge.api.scopes.IPersistentModelScope;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.util.UIUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class DiffMergeLabelProvider
extends LabelProvider {
    private static DiffMergeLabelProvider __instance = null;

    public static DiffMergeLabelProvider getInstance() {
        if (__instance == null) {
            __instance = new DiffMergeLabelProvider();
        }
        return __instance;
    }

    protected DiffMergeLabelProvider() {
    }

    public Image getDifferenceImage(IDifference difference_p, Role destination_p) {
        Image result = null;
        if (difference_p instanceof IPresenceDifference) {
            Role presenceSide;
            EMFDiffMergeUIPlugin.ImageID imageId = difference_p instanceof IValuePresence && ((IValuePresence)difference_p).isOrder() ? EMFDiffMergeUIPlugin.ImageID.SORT : ((presenceSide = ((IPresenceDifference)difference_p).getPresenceRole()) == destination_p ? EMFDiffMergeUIPlugin.ImageID.DELETE : EMFDiffMergeUIPlugin.ImageID.PLUS);
            result = EMFDiffMergeUIPlugin.getDefault().getImage(imageId);
        }
        return result;
    }

    public String getDifferenceText(IDifference difference_p, Role destination_p, EditingDomain domain_p) {
        String result = difference_p.toString();
        if (difference_p instanceof IPresenceDifference) {
            boolean added;
            Role presenceSide = ((IPresenceDifference)difference_p).getPresenceRole();
            boolean bl = added = presenceSide != destination_p;
            if (difference_p instanceof IElementPresence) {
                if (added) {
                    IElementPresence presence = (IElementPresence)difference_p;
                    IMatch ownerMatch = presence.getOwnerMatch();
                    if (ownerMatch != null) {
                        String featureName = presence.getElement().eContainmentFeature().getName();
                        String containerText = this.getMatchText(ownerMatch, destination_p, domain_p);
                        result = String.format(Messages.EMFDiffMergeLabelProvider_AdditionInto, containerText, featureName);
                    } else {
                        result = Messages.EMFDiffMergeLabelProvider_Addition;
                    }
                } else {
                    result = Messages.EMFDiffMergeLabelProvider_Deletion;
                }
            } else if (difference_p instanceof IValuePresence) {
                String featureName;
                IValuePresence valuePresence = (IValuePresence)difference_p;
                EStructuralFeature feature = valuePresence.getFeature();
                String QUOTE = "'";
                String SPACE = " ";
                String string = featureName = feature != null ? "'" + feature.getName() + "'" : Messages.EMFDiffMergeLabelProvider_RootContainment;
                if (feature instanceof EReference && ((EReference)feature).isContainment() && !valuePresence.isOrder()) {
                    String containerText = this.getMatchText(valuePresence.getElementMatch(), destination_p, domain_p);
                    result = added ? String.format(Messages.EMFDiffMergeLabelProvider_MoveInto, containerText, featureName) : String.format(Messages.EMFDiffMergeLabelProvider_MoveFrom, containerText, featureName);
                } else {
                    String operationKind;
                    String featureKind;
                    String string2 = featureKind = feature instanceof EAttribute ? Messages.EMFDiffMergeLabelProvider_Attribute : Messages.EMFDiffMergeLabelProvider_Reference;
                    if (valuePresence.isOrder()) {
                        operationKind = added ? Messages.EMFDiffMergeLabelProvider_OrderAdd : Messages.EMFDiffMergeLabelProvider_OrderDel;
                    } else {
                        Object value = valuePresence.getValue();
                        String valueText = value instanceof IMatch ? this.getMatchText((IMatch)value, destination_p, domain_p) : this.getText(value);
                        operationKind = String.valueOf(added ? Messages.EMFDiffMergeLabelProvider_ValueAddition : Messages.EMFDiffMergeLabelProvider_ValueDeletion) + " " + valueText;
                    }
                    result = String.valueOf(featureKind) + " " + featureName + ": " + operationKind;
                }
            }
        }
        return result;
    }

    private EObject getElementToRepresent(IMatch match_p, Role destination_p) {
        EObject result = match_p.getUncoveredRole() == destination_p ? match_p.get(destination_p.opposite()) : match_p.get(destination_p);
        return result;
    }

    public Image getImage(Object element_p) {
        Image result;
        Object element = element_p;
        if (element instanceof IPersistentModelScope) {
            element = ((IPersistentModelScope)element).getHoldingResource();
        }
        if ((result = UIUtil.getImage(element)) == null) {
            result = EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.EMPTY);
        }
        return result;
    }

    public String getMatchText(IMatch match_p, Role destination_p, EditingDomain domain_p) {
        EObject toRepresent = this.getElementToRepresent(match_p, destination_p);
        return this.getText(toRepresent, domain_p);
    }

    public Image getMatchImage(IMatch match_p, Role destination_p) {
        return this.getImage(this.getElementToRepresent(match_p, destination_p));
    }

    public String getText(Object element_p) {
        String result;
        Object element = element_p;
        if (element instanceof IPersistentModelScope) {
            element = ((IPersistentModelScope)element).getHoldingResource();
        }
        if (element instanceof EObject) {
            result = UIUtil.getText(element);
        } else if (element instanceof Resource) {
            result = UIUtil.simplifyURI(((Resource)element).getURI().toString());
        } else if (element instanceof IFile) {
            result = ((IFile)element).getFullPath().toPortableString();
        } else {
            result = super.getText(element);
            if (element_p instanceof String) {
                result = "\"" + result + "\"";
            }
        }
        if (result == null && element_p != null) {
            result = element_p.toString();
        }
        return result;
    }

    protected String getText(EObject element_p, EditingDomain domain_p) {
        AdapterFactoryEditingDomain domain;
        IItemLabelProvider provider;
        String result = null;
        if (domain_p instanceof AdapterFactoryEditingDomain && (provider = (IItemLabelProvider)(domain = (AdapterFactoryEditingDomain)domain_p).getAdapterFactory().adapt((Notifier)element_p, IItemLabelProvider.class)) != null) {
            result = provider.getText((Object)element_p);
        }
        if (result == null) {
            result = this.getText(element_p);
        }
        return result;
    }
}

