/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.connector.git.ext;

import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.info.GitInfo;
import org.eclipse.egit.core.util.RevCommitUtils;
import org.eclipse.emf.diffmerge.connector.git.EMFDiffMergeGitConnectorPlugin;
import org.eclipse.emf.diffmerge.connector.git.ext.AbstractGitURIConverter;
import org.eclipse.emf.diffmerge.connector.git.ext.GitHelper;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.team.core.history.IFileRevision;

public abstract class AbstractGitConflictURIConverter
extends AbstractGitURIConverter {
    protected final int _conflictRole;
    protected final String _holdingResourcePath;

    public AbstractGitConflictURIConverter(Repository repository_p, int conflictRole_p, String holdingResourcePath_p) {
        super(repository_p);
        this._conflictRole = conflictRole_p;
        this._holdingResourcePath = holdingResourcePath_p;
    }

    @Override
    protected IFileRevision getGitFileRevision(String gitPath_p) {
        GitHelper helper = GitHelper.INSTANCE;
        Repository repository = this.getRepository();
        try {
            RevCommit commit;
            RevWalk revWalk;
            Throwable throwable = null;
            Object var5_8 = null;
            try {
                revWalk = helper.getRevWalk(repository, gitPath_p);
                try {
                    commit = helper.getOurs(repository, revWalk);
                    GitInfo gitInfo = helper.getGitInfo(commit);
                    if (gitInfo != null && gitInfo.getGitState() != null && gitInfo.getGitState().hasConflicts()) {
                        return this.inIndex(repository, gitPath_p, this._conflictRole);
                    }
                }
                finally {
                    if (revWalk != null) {
                        revWalk.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            throwable = null;
            var5_8 = null;
            try {
                revWalk = helper.getRevWalk(repository, this._holdingResourcePath);
                try {
                    if (2 == this._conflictRole) {
                        RevCommit ourCommit = helper.getOurs(repository, revWalk);
                        return this.inCommit(repository, ourCommit, gitPath_p);
                    }
                    if (3 == this._conflictRole) {
                        commit = RevCommitUtils.getTheirs((Repository)repository, (RevWalk)revWalk);
                        if (commit == null) {
                            revWalk.reset();
                            commit = helper.getOurs(repository, revWalk);
                        }
                        return this.inCommit(repository, commit, gitPath_p);
                    }
                }
                finally {
                    if (revWalk != null) {
                        revWalk.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            EMFDiffMergeGitConnectorPlugin.getDefault().getLog().log((IStatus)new Status(4, EMFDiffMergeGitConnectorPlugin.getDefault().getPluginId(), e.getMessage(), (Throwable)e));
        }
        return this.inIndex(repository, gitPath_p);
    }
}

