/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.diffmerge.generic.api.IMatch;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.api.diff.IDifference;
import org.eclipse.emf.diffmerge.generic.api.diff.IElementPresence;
import org.eclipse.emf.diffmerge.generic.api.diff.IPresenceDifference;
import org.eclipse.emf.diffmerge.generic.api.diff.IReferenceValuePresence;
import org.eclipse.emf.diffmerge.generic.api.diff.IValuePresence;
import org.eclipse.emf.diffmerge.generic.api.scopes.IRawDataScope;
import org.eclipse.emf.diffmerge.generic.api.scopes.ITreeDataScope;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.util.UIUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class DiffMergeLabelProvider
extends LabelProvider {
    private static DiffMergeLabelProvider __instance = null;

    public static DiffMergeLabelProvider getInstance() {
        if (__instance == null) {
            __instance = new DiffMergeLabelProvider();
        }
        return __instance;
    }

    protected DiffMergeLabelProvider() {
    }

    public Image getDifferenceImage(IDifference<?> difference_p, Role destination_p) {
        Image result = null;
        if (difference_p instanceof IPresenceDifference) {
            Role presenceSide;
            EMFDiffMergeUIPlugin.ImageID imageId = difference_p instanceof IValuePresence && ((IValuePresence)difference_p).isOrder() ? EMFDiffMergeUIPlugin.ImageID.SORT : ((presenceSide = ((IPresenceDifference)difference_p).getPresenceRole()) == destination_p ? EMFDiffMergeUIPlugin.ImageID.DELETE : EMFDiffMergeUIPlugin.ImageID.PLUS);
            result = EMFDiffMergeUIPlugin.getDefault().getImage(imageId);
        }
        return result;
    }

    public String getDifferenceText(IDifference<?> difference_p, Role destination_p, EditingDomain domain_p) {
        String result = difference_p.toString();
        if (difference_p instanceof IPresenceDifference) {
            if (difference_p instanceof IElementPresence) {
                boolean added;
                Role presenceSide = ((IPresenceDifference)difference_p).getPresenceRole();
                boolean bl = added = presenceSide != destination_p;
                result = added ? this.getElementAdditionText((IElementPresence)difference_p, destination_p, domain_p) : this.getElementRemovalText((IElementPresence)difference_p, destination_p, domain_p);
            } else if (difference_p instanceof IValuePresence) {
                result = this.getValuePresenceText((IValuePresence)difference_p, destination_p, domain_p);
            }
        }
        return result;
    }

    protected String getValuePresenceText(IValuePresence<?> presence_p, Role destination_p, EditingDomain domain_p) {
        String result;
        boolean added = presence_p.getPresenceRole() != destination_p;
        Object feature = presence_p.getFeature();
        String SPACE = " ";
        String featureName = this.getModifiedFeatureText(feature);
        if (presence_p instanceof IReferenceValuePresence && ((IReferenceValuePresence)presence_p).isOwnership()) {
            String containerText = this.getMatchText(presence_p.getElementMatch(), destination_p, domain_p);
            result = added ? String.format(Messages.EMFDiffMergeLabelProvider_MoveInto, containerText, featureName) : String.format(Messages.EMFDiffMergeLabelProvider_MoveFrom, containerText, featureName);
        } else {
            String operationKind;
            String featureKind;
            String string = featureKind = feature instanceof EAttribute ? Messages.EMFDiffMergeLabelProvider_Attribute : Messages.EMFDiffMergeLabelProvider_Reference;
            if (presence_p.isOrder()) {
                operationKind = added ? Messages.EMFDiffMergeLabelProvider_OrderAdd : Messages.EMFDiffMergeLabelProvider_OrderDel;
            } else {
                IMatch matchValue = presence_p instanceof IReferenceValuePresence ? ((IReferenceValuePresence)presence_p).getValueMatch() : null;
                String valueText = matchValue != null ? this.getMatchText(matchValue, destination_p, domain_p) : this.getText(presence_p.getValue());
                operationKind = String.valueOf(added ? Messages.EMFDiffMergeLabelProvider_ValueAddition : Messages.EMFDiffMergeLabelProvider_ValueDeletion) + " " + valueText;
            }
            result = String.valueOf(featureKind) + " " + featureName + ": " + operationKind;
        }
        return result;
    }

    protected String getElementAdditionText(IElementPresence<?> presence_p, Role destination_p, EditingDomain domain_p) {
        IReferenceValuePresence rvp;
        String featureName = null;
        String containerText = null;
        IMatch elementMatch = presence_p.getElementMatch();
        if (elementMatch != null && (rvp = elementMatch.getOwnershipDifference(presence_p.getPresenceRole())) != null) {
            Object feature = rvp.getFeature();
            featureName = this.getModifiedFeatureText(feature);
            containerText = this.getMatchText(rvp.getElementMatch(), destination_p, domain_p);
        }
        if (featureName == null) {
            ITreeDataScope scope = presence_p.getComparison().getScope(destination_p.opposite());
            Object containment = scope == null ? null : scope.getContainment(presence_p.getElement());
            IMatch ownerMatch = presence_p.getOwnerMatch();
            if (containment != null && ownerMatch != null) {
                featureName = this.getModifiedFeatureText(containment);
                containerText = this.getMatchText(ownerMatch, destination_p, domain_p);
            }
        }
        String result = featureName != null && containerText != null ? String.format(Messages.EMFDiffMergeLabelProvider_AdditionInto, containerText, featureName) : Messages.EMFDiffMergeLabelProvider_Addition;
        return result;
    }

    protected String getElementRemovalText(IElementPresence<?> presence_p, Role destination_p, EditingDomain domain_p) {
        return Messages.EMFDiffMergeLabelProvider_Deletion;
    }

    protected Object getElementToRepresent(IMatch<?> match_p, Role destination_p) {
        Object result = match_p.getUncoveredRole() == destination_p ? match_p.get(destination_p.opposite()) : match_p.get(destination_p);
        return result;
    }

    public Image getImage(Object element_p) {
        Image result;
        Object element = element_p;
        if (element instanceof IRawDataScope) {
            element = ((IRawDataScope)element).getOriginator();
        }
        if ((result = UIUtil.getEMFImage(element)) == null) {
            result = EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.EMPTY);
        }
        return result;
    }

    public String getMatchText(IMatch<?> match_p, Role destination_p, EditingDomain domain_p) {
        Object toRepresent = this.getElementToRepresent(match_p, destination_p);
        return toRepresent instanceof EObject ? this.getText((EObject)toRepresent, domain_p) : this.getText(toRepresent);
    }

    public Image getMatchImage(IMatch<?> match_p, Role destination_p) {
        return this.getImage(this.getElementToRepresent(match_p, destination_p));
    }

    protected String getModifiedFeatureText(Object feature_p) {
        String result = feature_p == null ? Messages.EMFDiffMergeLabelProvider_RootContainment : (feature_p instanceof EStructuralFeature ? ((EStructuralFeature)feature_p).getName() : this.getText(feature_p));
        return String.valueOf('\'') + result + '\'';
    }

    public String getText(Object element_p) {
        String result;
        Object element = element_p;
        if (element instanceof IRawDataScope) {
            element = ((IRawDataScope)element).getOriginator();
        }
        if (element instanceof EObject) {
            result = UIUtil.getEMFText(element);
        } else if (element instanceof Resource) {
            result = UIUtil.simplifyURI(((Resource)element).getURI());
        } else if (element instanceof IFile) {
            result = ((IFile)element).getFullPath().toPortableString();
        } else {
            result = super.getText(element);
            if (element_p instanceof String) {
                result = "\"" + result + "\"";
            }
        }
        if (result == null && element_p != null) {
            result = element_p.toString();
        }
        return result;
    }

    protected String getText(EObject element_p, EditingDomain domain_p) {
        AdapterFactoryEditingDomain domain;
        IItemLabelProvider provider;
        String result = null;
        if (domain_p instanceof AdapterFactoryEditingDomain && (provider = (IItemLabelProvider)(domain = (AdapterFactoryEditingDomain)domain_p).getAdapterFactory().adapt((Notifier)element_p, IItemLabelProvider.class)) != null) {
            result = provider.getText((Object)element_p);
        }
        if (result == null) {
            result = this.getText(element_p);
        }
        return result;
    }
}

