/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.diffmerge.api.IComparison;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.diff.IElementPresence;
import org.eclipse.emf.diffmerge.api.diff.IElementRelativeDifference;
import org.eclipse.emf.diffmerge.api.diff.IElementRelativePresence;
import org.eclipse.emf.diffmerge.api.diff.IMergeableDifference;
import org.eclipse.emf.diffmerge.api.diff.IPresenceDifference;
import org.eclipse.emf.diffmerge.api.diff.IReferenceValuePresence;
import org.eclipse.emf.diffmerge.api.diff.IValuePresence;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.diffdata.EMatch;
import org.eclipse.emf.diffmerge.structures.common.FHashMap;
import org.eclipse.emf.diffmerge.structures.common.FOrderedSet;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.diffuidata.MatchAndFeature;
import org.eclipse.emf.diffmerge.ui.util.DifferenceKind;
import org.eclipse.emf.diffmerge.ui.viewers.DefaultUserProperties;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.IDifferenceCategory;
import org.eclipse.emf.diffmerge.ui.viewers.IDifferenceCategoryItem;
import org.eclipse.emf.diffmerge.ui.viewers.IDifferenceCategorySet;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.TreePath;

public class CategoryManager {
    protected final EMFDiffNode _node;
    private final Map<String, IDifferenceCategory> _categories;
    protected final Set<IDifferenceCategory> _activeCategories;
    protected final Set<IDifferenceCategory> _defaultConfiguration;
    protected final List<IDifferenceCategoryItem> _uiRootItems;
    protected final Map<IDifferenceCategorySet, Collection<IDifferenceCategoryItem>> _uiChildrenItems;
    private final EMap<EMatch, Integer> _matchToNb;

    public CategoryManager(EMFDiffNode node_p) {
        this._node = node_p;
        this._categories = new LinkedHashMap<String, IDifferenceCategory>();
        this._activeCategories = new HashSet<IDifferenceCategory>();
        this._defaultConfiguration = new HashSet<IDifferenceCategory>();
        this._uiRootItems = new ArrayList<IDifferenceCategoryItem>();
        this._uiChildrenItems = new HashMap<IDifferenceCategorySet, Collection<IDifferenceCategoryItem>>();
        this._matchToNb = new FHashMap();
    }

    public boolean addCategories(IDifferenceCategorySet categorySet_p) {
        boolean result = true;
        for (IDifferenceCategoryItem categoryItem : categorySet_p.getChildren()) {
            boolean bl = result = this.addCategoryItem(categoryItem) && result;
        }
        return result;
    }

    public boolean addCategory(IDifferenceCategory category_p) {
        IDifferenceCategory squatter = this._categories.put(category_p.getID(), category_p);
        return squatter == null || squatter == category_p;
    }

    protected boolean addCategoryItem(IDifferenceCategoryItem categoryItem_p) {
        boolean result = true;
        if (categoryItem_p instanceof IDifferenceCategory) {
            result = this.addCategory((IDifferenceCategory)categoryItem_p);
        } else if (categoryItem_p instanceof IDifferenceCategorySet) {
            result = this.addCategories((IDifferenceCategorySet)categoryItem_p);
        }
        return result;
    }

    protected int countDifferences(IMatch match_p, boolean withFilters_p) {
        int result = this.countNonContainmentDifferences(match_p, withFilters_p);
        if (this.isMove(match_p, withFilters_p)) {
            ++result;
        }
        if (this.isUnmatched(match_p, withFilters_p)) {
            ++result;
        }
        return result;
    }

    protected int countNonContainmentDifferences(IMatch match_p, boolean withFilters_p) {
        int result = 0;
        if (!match_p.isPartial()) {
            HashSet<EStructuralFeature> uniFeatures = new HashSet<EStructuralFeature>();
            for (IDifference difference : match_p.getRelatedDifferences()) {
                IElementRelativeDifference eltDiff;
                if (!(difference instanceof IElementRelativeDifference) || withFilters_p && this.isFiltered(difference) || !(eltDiff = (IElementRelativeDifference)difference).isUnrelatedToContainmentTree()) continue;
                if (eltDiff instanceof IValuePresence) {
                    EStructuralFeature feature = ((IValuePresence)eltDiff).getFeature();
                    if (feature != null && (!feature.isMany() || ((IValuePresence)eltDiff).isOrder())) {
                        if (uniFeatures.contains(feature)) continue;
                        ++result;
                        uniFeatures.add(feature);
                        continue;
                    }
                    ++result;
                    continue;
                }
                ++result;
            }
        }
        return result;
    }

    public Collection<IDifferenceCategory> getCategories() {
        return this._categories.values();
    }

    public IDifferenceCategory getCategory(String categoryID_p) {
        IDifferenceCategory result = this._categories.get(categoryID_p);
        return result;
    }

    public List<IMatch> getChildrenForMerge(IMatch match_p) {
        FOrderedSet result = new FOrderedSet();
        IComparison comparison = match_p.getMapping().getComparison();
        List candidates = comparison.getContentsOf(match_p);
        for (IMatch candidate : candidates) {
            if (this.isMoveOrigin(candidate) || this.getDifferenceNumber(candidate) <= 0) continue;
            result.add(candidate);
        }
        return Collections.unmodifiableList(result);
    }

    public Collection<IDifferenceCategory> getDefaultConfiguration() {
        return Collections.unmodifiableSet(this._defaultConfiguration);
    }

    public DifferenceKind getDifferenceKind(EObject element_p, Role side_p) {
        DifferenceKind result = DifferenceKind.NONE;
        IMatch match = this._node.getActualComparison().getMapping().getMatchFor(element_p, side_p);
        if (match != null) {
            result = this.getDifferenceKind(match);
        }
        return result;
    }

    public DifferenceKind getDifferenceKind(IDifference difference_p) {
        DifferenceKind result = DifferenceKind.NONE;
        if (this.representAsUserDifference(difference_p)) {
            if (difference_p.isConflicting()) {
                result = DifferenceKind.CONFLICT;
            } else if (difference_p instanceof IPresenceDifference) {
                IPresenceDifference presence = (IPresenceDifference)difference_p;
                boolean isMany = this.isMany((IDifference)presence);
                result = presence.getPresenceRole() == this._node.getRoleForSide(true) ? (this.isAlignedWithReference(presence) ? DifferenceKind.FROM_RIGHT_DEL : (isMany || this._node.getReferenceRole() != null ? DifferenceKind.FROM_LEFT_ADD : DifferenceKind.MODIFIED)) : (this.isAlignedWithReference(presence) ? DifferenceKind.FROM_LEFT_DEL : (isMany || this._node.getReferenceRole() != null ? DifferenceKind.FROM_RIGHT_ADD : DifferenceKind.MODIFIED));
            }
        }
        return result;
    }

    public DifferenceKind getDifferenceKind(IMatch match_p) {
        DifferenceKind result = DifferenceKind.NONE;
        if (this.isComparisonPart(match_p)) {
            boolean considerReference;
            IElementPresence presence = match_p.getElementPresenceDifference();
            boolean bl = considerReference = this._node.getReferenceRole() != null;
            if (presence != null) {
                result = this.getDifferenceKind((IDifference)presence);
            } else {
                result = this.getModificationKind(match_p);
                result = result.with(this.getOwnershipDifferenceKind(match_p), considerReference);
                result = result.keepOnlyDirection(considerReference);
            }
            if (result == DifferenceKind.NONE && this.getDifferenceNumber(match_p) > 0) {
                result = DifferenceKind.COUNTED;
            }
        }
        return result;
    }

    public DifferenceKind getDifferenceKind(IMatch match_p, EStructuralFeature feature_p) {
        DifferenceKind result = DifferenceKind.NONE;
        if (this.isComparisonPart(match_p)) {
            if (feature_p == EMFDiffMergeUIPlugin.getDefault().getOwnershipFeature()) {
                result = this.getOwnershipDifferenceKind(match_p);
            } else {
                ArrayList<IValuePresence> presences;
                if (feature_p instanceof EReference) {
                    if (this._node.isContainment(feature_p)) {
                        ArrayList<IValuePresence> vPresences = new ArrayList<IValuePresence>();
                        IValuePresence orderDiff = match_p.getOrderDifference(feature_p, this._node.getDrivingRole());
                        if (orderDiff != null) {
                            vPresences.add(orderDiff);
                        }
                        if ((orderDiff = match_p.getOrderDifference(feature_p, this._node.getDrivingRole().opposite())) != null) {
                            vPresences.add(orderDiff);
                        }
                        presences = vPresences;
                    } else {
                        presences = match_p.getReferenceDifferences((EReference)feature_p);
                    }
                } else {
                    presences = match_p.getAttributeDifferences((EAttribute)feature_p);
                }
                Iterator it = presences.iterator();
                while (it.hasNext() && result != DifferenceKind.CONFLICT && result != DifferenceKind.FROM_BOTH && result != DifferenceKind.MODIFIED) {
                    DifferenceKind current = this.getDifferenceKind((IDifference)it.next());
                    result = result.with(current, true);
                }
            }
        }
        return result;
    }

    public DifferenceKind getDifferenceKind(MatchAndFeature maf_p) {
        return this.getDifferenceKind((IMatch)maf_p.getMatch(), maf_p.getFeature());
    }

    public int getDifferenceNumber(IMatch match_p) {
        Integer currentNb = (Integer)this.getMatchToNb().get((Object)match_p);
        if (currentNb == null) {
            currentNb = 0;
        }
        return currentNb;
    }

    protected EMap<EMatch, Integer> getMatchToNb() {
        return this._matchToNb;
    }

    protected DifferenceKind getModificationKind(IMatch match_p) {
        DifferenceKind result = DifferenceKind.NONE;
        boolean considerReference = this._node.getReferenceRole() != null;
        IElementPresence eltPresence = match_p.getElementPresenceDifference();
        if (eltPresence == null || this.isFiltered((IDifference)eltPresence)) {
            for (IDifference diff : match_p.getRelatedDifferences()) {
                DifferenceKind diffKind;
                if (diff instanceof IElementRelativeDifference && ((IElementRelativeDifference)diff).isUnrelatedToContainmentTree() && (result = result.with(diffKind = this.getDifferenceKind(diff), considerReference)) == DifferenceKind.CONFLICT) break;
            }
        }
        return result;
    }

    protected DifferenceKind getOwnershipDifferenceKind(IMatch match_p) {
        DifferenceKind result = DifferenceKind.NONE;
        if (this.representAsMove(match_p)) {
            result = DifferenceKind.MODIFIED;
            if (this._node.getReferenceRole() != null) {
                boolean fromRight;
                IReferenceValuePresence onLeft = match_p.getOwnershipDifference(this._node.getRoleForSide(true));
                boolean fromLeft = onLeft != null && !this.isAlignedWithReference((IPresenceDifference)onLeft);
                IReferenceValuePresence onRight = match_p.getOwnershipDifference(this._node.getRoleForSide(false));
                boolean bl = fromRight = onRight != null && !this.isAlignedWithReference((IPresenceDifference)onRight);
                if (fromLeft && fromRight) {
                    result = DifferenceKind.CONFLICT;
                } else if (fromLeft) {
                    result = DifferenceKind.FROM_LEFT;
                } else if (fromRight) {
                    result = DifferenceKind.FROM_RIGHT;
                }
            }
        }
        return result;
    }

    public List<IDifference> getPendingDifferencesFiltered(Iterable<? extends IDifference> differences_p) {
        ArrayList<IDifference> result = new ArrayList<IDifference>();
        for (IDifference iDifference : differences_p) {
            if (!this.isPending(iDifference) || this.isFiltered(iDifference)) continue;
            result.add(iDifference);
        }
        return Collections.unmodifiableList(result);
    }

    public List<IDifferenceCategoryItem> getUIChildrenItems(IDifferenceCategorySet categorySet_p) {
        List<IDifferenceCategoryItem> result = new ArrayList<IDifferenceCategoryItem>((Collection<IDifferenceCategoryItem>)categorySet_p.getChildren());
        Collection<IDifferenceCategoryItem> visibleChildren = this._uiChildrenItems.get(categorySet_p);
        if (visibleChildren != null) {
            result.retainAll(visibleChildren);
            result = Collections.unmodifiableList(result);
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    public int getUIDifferenceNumber(IMatch match_p) {
        if (!this._node.isUserPropertyTrue(DefaultUserProperties.P_SHOW_DIFFERENCE_NUMBERS)) {
            return 0;
        }
        int result = this.getDifferenceNumber(match_p);
        IElementPresence eltPresence = match_p.getElementPresenceDifference();
        if (eltPresence != null && !this.isFiltered((IDifference)eltPresence)) {
            --result;
        }
        return result;
    }

    public List<IDifferenceCategoryItem> getUIRootItems() {
        return Collections.unmodifiableList(this._uiRootItems);
    }

    public boolean hasChildrenForMergeFiltered(IMatch match_p) {
        IComparison comparison = match_p.getMapping().getComparison();
        Role role = match_p.isPartial() ? match_p.getUncoveredRole().opposite() : this._node.getDrivingRole();
        List candidates = comparison.getContentsOf(match_p, role);
        for (IMatch candidate : candidates) {
            if (this.getDifferenceNumber(candidate) <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasNonContainmentDifferencesForMergeFiltered(IMatch match_p) {
        if (!match_p.isPartial()) {
            for (IDifference difference : match_p.getRelatedDifferences()) {
                IElementRelativeDifference eltDiff;
                if (!(difference instanceof IElementRelativeDifference) || this.isFiltered(difference) || !(eltDiff = (IElementRelativeDifference)difference).isUnrelatedToContainmentTree()) continue;
                return true;
            }
        }
        return false;
    }

    protected void incrementDifferenceNumbers(EMatch match_p, int increment_p) {
        int currentNb = this.getDifferenceNumber((IMatch)match_p);
        Integer newNb = increment_p + currentNb;
        this.getMatchToNb().put((Object)match_p, (Object)newNb);
    }

    protected void incrementDifferenceNumbersInHierarchy(EMatch match_p, int increment_p) {
        if (increment_p > 0) {
            this.incrementDifferenceNumbers(match_p, increment_p);
            EMatch current = this._node.getContainerOf(match_p);
            while (current != null) {
                this.incrementDifferenceNumbers(current, increment_p);
                current = this._node.getContainerOf(current);
            }
        }
    }

    protected boolean isAlignedWithReference(IPresenceDifference presence_p) {
        boolean result = this._node.isThreeWay() ? presence_p.isAlignedWithAncestor() : presence_p.getPresenceRole() == this._node.getReferenceRole();
        return result;
    }

    public boolean isComparisonPart(IDifference difference_p) {
        IComparison comparison = difference_p.getComparison();
        boolean result = comparison != null && comparison == this._node.getActualComparison();
        return result;
    }

    public boolean isComparisonPart(IMatch match_p) {
        IComparison comparison = match_p.getMapping() == null ? null : match_p.getMapping().getComparison();
        boolean result = comparison != null && comparison == this._node.getActualComparison();
        return result;
    }

    public boolean isEmpty() {
        EComparison comparison = this._node.getActualComparison();
        if (comparison != null) {
            for (IMatch match : comparison.getMapping().getContents()) {
                for (IDifference difference : match.getAllDifferences()) {
                    if (!this.isPending(difference) || this.isFiltered(difference)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isFiltered(IDifference difference_p) {
        boolean globalFocus = false;
        boolean diffFocus = false;
        for (IDifferenceCategory category : this._activeCategories) {
            boolean catFocus = category.isInFocusMode();
            globalFocus = globalFocus || catFocus;
            boolean covered = category.covers(difference_p, this._node);
            if (!covered) continue;
            if (!catFocus) {
                return true;
            }
            diffFocus = true;
        }
        return globalFocus && !diffFocus;
    }

    public boolean isMany(IDifference difference_p) {
        IValuePresence valuePresence;
        boolean result = true;
        if (difference_p instanceof IValuePresence && !(valuePresence = (IValuePresence)difference_p).isOrder()) {
            EStructuralFeature feature = valuePresence.getFeature();
            result = feature == null || feature.isMany();
        }
        return result;
    }

    public boolean isMergeable(IDifference difference_p) {
        boolean result = false;
        if (difference_p instanceof IMergeableDifference) {
            IMergeableDifference casted = (IMergeableDifference)difference_p;
            result = casted.canMergeTo(this._node.getRoleForSide(true)) && this._node.isEditable(true) || casted.canMergeTo(this._node.getRoleForSide(false)) && this._node.isEditable(false);
        }
        return result;
    }

    public boolean isMove(IDifference difference_p) {
        boolean result = false;
        if (this.isOwnership(difference_p)) {
            IMatch valueMatch = ((IReferenceValuePresence)difference_p).getValueMatch();
            result = valueMatch != null && !valueMatch.isPartial();
        }
        return result;
    }

    public boolean isMove(IMatch match_p, boolean withFilters_p) {
        boolean result = false;
        if (!match_p.isPartial() && match_p.getElementPresenceDifference() == null) {
            IReferenceValuePresence onTarget = match_p.getOwnershipDifference(Role.TARGET);
            IReferenceValuePresence onReference = match_p.getOwnershipDifference(Role.REFERENCE);
            result = onTarget != null && (!withFilters_p || !this.isFiltered((IDifference)onTarget)) || onReference != null && (!withFilters_p || !this.isFiltered((IDifference)onReference));
        }
        return result;
    }

    public boolean isMoveOrigin(IMatch match_p) {
        IComparison comparison = match_p.getMapping().getComparison();
        IMatch parent = comparison.getContainerOf(match_p, this._node.getDrivingRole());
        return this.isMoveOrigin(parent, match_p);
    }

    public boolean isMoveOrigin(IMatch parent_p, IMatch child_p) {
        boolean result = false;
        if (this.isMove(child_p, false)) {
            Role drivingRole;
            IComparison comparison = child_p.getMapping().getComparison();
            result = comparison.getContainerOf(child_p, (drivingRole = this._node.getDrivingRole()).opposite()) == parent_p && comparison.getContainerOf(child_p, drivingRole) != parent_p;
        }
        return result;
    }

    public boolean isMoveOrigin(TreePath path_p) {
        boolean result = false;
        IMatch end = (IMatch)path_p.getLastSegment();
        if (end != null) {
            TreePath parentPath = path_p.getParentPath();
            IMatch father = parentPath == null ? null : (IMatch)parentPath.getLastSegment();
            result = this.isMoveOrigin(father, end);
        }
        return result;
    }

    public boolean isOrder(IDifference difference_p) {
        return difference_p instanceof IValuePresence && ((IValuePresence)difference_p).isOrder();
    }

    public boolean isOwnership(IDifference difference_p) {
        boolean result = false;
        if (difference_p instanceof IReferenceValuePresence) {
            IReferenceValuePresence presence = (IReferenceValuePresence)difference_p;
            result = presence.isOwnership();
        }
        return result;
    }

    public boolean isPending(IDifference difference_p) {
        return this.isMergeable(difference_p) && !difference_p.isIgnored();
    }

    public boolean isUIFiltering() {
        for (IDifferenceCategory category : this._activeCategories) {
            if (!this.isUIFiltering(category)) continue;
            return true;
        }
        return false;
    }

    public boolean isUIFiltering(IDifferenceCategory category_p) {
        return category_p.isVisible() && category_p.isModifiable() && category_p.isActive() && (category_p.mayCoverPendingDifferences() || category_p.isInFocusMode());
    }

    public boolean isUIMoreFilteringThanDefault() {
        Collection<IDifferenceCategory> defaultConfig = this.getDefaultConfiguration();
        for (IDifferenceCategory defaultCat : defaultConfig) {
            String id = defaultCat.getID();
            IDifferenceCategory actualCat = this.getCategory(id);
            if (actualCat == null || !this._activeCategories.contains(actualCat) || !this.isUIFiltering(actualCat) || this.isUIFiltering(defaultCat) && defaultCat.isInFocusMode() == actualCat.isInFocusMode()) continue;
            return true;
        }
        return false;
    }

    public boolean isUnmatched(IMatch match_p, boolean withFilters_p) {
        IElementPresence presence = match_p.getElementPresenceDifference();
        return presence != null && (!withFilters_p || !this.isFiltered((IDifference)presence));
    }

    public boolean removeCategory(String categoryID_p) {
        IDifferenceCategory category = this._categories.remove(categoryID_p);
        return category != null;
    }

    public boolean representAsModification(IMatch match_p) {
        IElementPresence eltPresence = match_p.getElementPresenceDifference();
        if (eltPresence != null && !this.isFiltered((IDifference)eltPresence)) {
            return false;
        }
        for (IDifference diff : match_p.getRelatedDifferences()) {
            if (!this.representAsModificationDifference(diff)) continue;
            return true;
        }
        return false;
    }

    protected boolean representAsModificationDifference(IDifference difference_p) {
        boolean result = false;
        if (difference_p instanceof IElementRelativePresence) {
            IElementRelativePresence presence = (IElementRelativePresence)difference_p;
            return presence.isUnrelatedToContainmentTree() && !this.isFiltered(difference_p);
        }
        return result;
    }

    public boolean representAsMove(IMatch match_p) {
        return this.isMove(match_p, true);
    }

    public boolean representAsMoveOrigin(TreePath path_p) {
        IMatch end = (IMatch)path_p.getLastSegment();
        return this.representAsMove(end) && this.isMoveOrigin(path_p);
    }

    public boolean representAsUserDifference(IDifference difference_p) {
        return this.isComparisonPart(difference_p) && !this.isFiltered(difference_p);
    }

    public boolean representAsUserDifference(IMatch match_p) {
        DifferenceKind kind = this.getDifferenceKind(match_p);
        return !kind.isNeutral();
    }

    public boolean representAsUserDifference(MatchAndFeature maf_p) {
        DifferenceKind kind = this.getDifferenceKind(maf_p);
        return !kind.isNeutral();
    }

    public boolean representAsUserDifference(TreePath path_p) {
        boolean result = false;
        IMatch end = (IMatch)path_p.getLastSegment();
        if (end != null) {
            result = this.representAsUserDifference(end) && !this.representAsMoveOrigin(path_p);
        }
        return result;
    }

    public void resetToDefault() {
        for (IDifferenceCategory defaultCat : this._defaultConfiguration) {
            String id = defaultCat.getID();
            IDifferenceCategory actualCat = this.getCategory(id);
            if (actualCat == null) continue;
            actualCat.copyState(defaultCat);
        }
    }

    public void setDefaultConfiguration() {
        this._defaultConfiguration.clear();
        for (IDifferenceCategory category : this.getCategories()) {
            try {
                IDifferenceCategory clone = category.clone();
                this._defaultConfiguration.add(clone);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
    }

    public void update() {
        this.updateActiveCategories();
        this.updateUIItems();
        this.updateDifferenceNumbers();
    }

    protected void updateActiveCategories() {
        this._activeCategories.clear();
        for (IDifferenceCategory category : this.getCategories()) {
            if (!category.isApplicable(this._node) || !category.isActive()) continue;
            this._activeCategories.add(category);
        }
    }

    protected void updateDifferenceNumbers() {
        this.getMatchToNb().clear();
        EComparison comparison = this._node.getActualComparison();
        if (comparison != null) {
            for (IMatch match : comparison.getMapping().getContents()) {
                int nb = this.countDifferences(match, true);
                this.incrementDifferenceNumbersInHierarchy((EMatch)match, nb);
            }
        }
    }

    protected void updateUIItems() {
        this._uiRootItems.clear();
        this._uiChildrenItems.clear();
        LinkedList<IDifferenceCategoryItem> visibleItems = new LinkedList<IDifferenceCategoryItem>();
        for (IDifferenceCategory category : this.getCategories()) {
            if (!category.isVisible() || !category.isApplicable(this._node)) continue;
            visibleItems.add(category);
        }
        while (!visibleItems.isEmpty()) {
            IDifferenceCategoryItem visibleItem = (IDifferenceCategoryItem)visibleItems.get(0);
            IDifferenceCategorySet parent = visibleItem.getParent();
            if (parent == null) {
                if (!this._uiRootItems.contains(visibleItem)) {
                    this._uiRootItems.add(visibleItem);
                }
            } else {
                Collection<IDifferenceCategoryItem> children = this._uiChildrenItems.get(parent);
                if (children == null) {
                    children = new HashSet<IDifferenceCategoryItem>();
                    this._uiChildrenItems.put(parent, children);
                }
                children.add(visibleItem);
                visibleItems.add(parent);
            }
            visibleItems.remove(visibleItem);
        }
    }
}

