/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.util;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.compare.IPropertyChangeNotifier;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class UserProperty<T>
implements IPropertyChangeNotifier,
IDisposable {
    private final Identifier<T> _id;
    private T _value;
    private final Set<IPropertyChangeListener> _changeListeners;

    protected UserProperty(Identifier<T> id_p, T initialValue_p) {
        assert (initialValue_p != null);
        this._id = id_p;
        this._value = initialValue_p;
        this._changeListeners = new HashSet<IPropertyChangeListener>(1);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener_p) {
        this._changeListeners.add(listener_p);
    }

    public void dispose() {
        this._value = null;
        this._changeListeners.clear();
    }

    protected void firePropertyChangeEvent(T oldValue_p) {
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, this.getID().getPropertyName(), oldValue_p, this.getValue());
        for (IPropertyChangeListener listener : this._changeListeners) {
            listener.propertyChange(event);
        }
    }

    public Identifier<T> getID() {
        return this._id;
    }

    public T getValue() {
        return this._value;
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener_p) {
        this._changeListeners.remove(listener_p);
    }

    public void setValue(T newValue_p) {
        assert (newValue_p != null);
        T oldValue = this.getValue();
        if (!oldValue.equals(newValue_p)) {
            this._value = newValue_p;
            this.firePropertyChangeEvent(oldValue);
        }
    }

    public static class Identifier<T> {
        private final String _propertyName;

        public Identifier() {
            this(EcoreUtil.generateUUID());
        }

        public Identifier(String propertyName_p) {
            this._propertyName = propertyName_p;
        }

        public UserProperty<T> createProperty(T initialValue_p) {
            return new UserProperty<T>(this, initialValue_p);
        }

        public boolean equals(Object obj_p) {
            boolean result = false;
            if (obj_p instanceof Identifier) {
                String peerPropertyName = ((Identifier)obj_p).getPropertyName();
                result = this.getPropertyName().equals(peerPropertyName);
            }
            return result;
        }

        public String getPropertyName() {
            return this._propertyName;
        }

        public int hashCode() {
            return this._propertyName.hashCode();
        }

        public boolean matches(PropertyChangeEvent event_p) {
            return this.getPropertyName().equals(event_p.getProperty());
        }
    }
}

