/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.diffdata.EMatch;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.diffuidata.MatchAndFeature;
import org.eclipse.emf.diffmerge.ui.diffuidata.impl.MatchAndFeatureImpl;
import org.eclipse.emf.diffmerge.ui.util.DiffDecoratingLabelProvider;
import org.eclipse.emf.diffmerge.ui.viewers.DefaultUserProperties;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.IDifferenceRelatedViewer;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class FeaturesViewer
extends TableViewer
implements IDifferenceRelatedViewer {
    private boolean _showAllFeatures;
    protected final IPropertyChangeListener _inputPropertyChangeListener;

    public FeaturesViewer(Composite parent_p) {
        this(parent_p, 770);
    }

    public FeaturesViewer(Composite parent_p, int style_p) {
        super(parent_p, style_p);
        this.setContentProvider((IContentProvider)new ContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this._showAllFeatures = false;
        this._inputPropertyChangeListener = this.createInputPropertyChangeListener();
        this.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.setComparator(new ViewerComparator());
    }

    protected IPropertyChangeListener createInputPropertyChangeListener() {
        return new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                if (DefaultUserProperties.P_TECHNICAL_LABELS.matches(event_p)) {
                    FeaturesViewer.this.refresh(true);
                }
            }
        };
    }

    public MatchAndFeature getFirstIn(FeaturesInput input_p) {
        Object firstElement;
        Object[] elements;
        MatchAndFeature result = null;
        if (input_p != null && (elements = this.getSortedChildren(input_p)) != null && elements.length > 0 && (firstElement = elements[0]) instanceof MatchAndFeature) {
            result = (MatchAndFeature)firstElement;
        }
        return result;
    }

    public FeaturesInput getInput() {
        return (FeaturesInput)super.getInput();
    }

    protected void inputChanged(Object input_p, Object oldInput_p) {
        if (oldInput_p instanceof FeaturesInput) {
            ((FeaturesInput)oldInput_p).getContext().removeUserPropertyChangeListener(DefaultUserProperties.P_TECHNICAL_LABELS, this._inputPropertyChangeListener);
        }
        if (input_p instanceof FeaturesInput) {
            ((FeaturesInput)input_p).getContext().addUserPropertyChangeListener(DefaultUserProperties.P_TECHNICAL_LABELS, this._inputPropertyChangeListener);
        }
        super.inputChanged(input_p, oldInput_p);
    }

    @Override
    public boolean isDifferenceAgnostic() {
        return this._showAllFeatures;
    }

    protected boolean isOwnershipFeature(Object object_p) {
        return EMFDiffMergeUIPlugin.getDefault().getOwnershipFeature().equals(object_p);
    }

    @Override
    public void setDifferenceAgnostic(boolean agnostic_p) {
        if (agnostic_p != this.isDifferenceAgnostic()) {
            this._showAllFeatures = agnostic_p;
            this.refresh(false);
        }
    }

    protected class ContentProvider
    implements IStructuredContentProvider {
        protected ContentProvider() {
        }

        private List<EStructuralFeature> getAllFeatures(IMatch match_p) {
            Role drivingRole = FeaturesViewer.this.getInput().getContext().getDrivingRole();
            EObject element = match_p.get(drivingRole);
            if (element == null) {
                element = match_p.get(drivingRole.opposite());
            }
            assert (element != null);
            EClass eClass = element.eClass();
            ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>();
            result.addAll((Collection<EStructuralFeature>)eClass.getEAllAttributes());
            for (EReference ref : eClass.getEAllReferences()) {
                if (!this.qualifies(ref) && match_p.getOrderDifference((EStructuralFeature)ref, drivingRole) == null) continue;
                result.add((EStructuralFeature)ref);
            }
            return result;
        }

        public Object[] getElements(Object inputElement_p) {
            List result = Collections.emptyList();
            FeaturesInput input = FeaturesViewer.this.getInput();
            if (input != null) {
                List<EStructuralFeature> features;
                EMFDiffNode context = input.getContext();
                Role drivingRole = context.getDrivingRole();
                IMatch match = ((FeaturesInput)inputElement_p).getMatch();
                if (FeaturesViewer.this.isDifferenceAgnostic()) {
                    features = this.getAllFeatures(match);
                } else {
                    features = new ArrayList<EStructuralFeature>(match.getAttributesWithDifferences());
                    for (EReference ref : match.getReferencesWithDifferences()) {
                        if (context.isContainment((EStructuralFeature)ref) && match.getOrderDifference((EStructuralFeature)ref, drivingRole) == null) continue;
                        features.add((EStructuralFeature)ref);
                    }
                }
                if (FeaturesViewer.this.getInput().getContext().getCategoryManager().representAsMove(match)) {
                    features.add((EStructuralFeature)EMFDiffMergeUIPlugin.getDefault().getOwnershipFeature());
                }
                result = new ArrayList();
                for (EStructuralFeature feature : features) {
                    MatchAndFeatureImpl maf = new MatchAndFeatureImpl((EMatch)match, feature);
                    result.add(maf);
                }
            }
            return result.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer_p, Object oldInput_p, Object newInput_p) {
        }

        private boolean qualifies(EReference reference_p) {
            return FeaturesViewer.this.isOwnershipFeature(reference_p) || !FeaturesViewer.this.getInput().getContext().isContainment((EStructuralFeature)reference_p) && !reference_p.isContainer();
        }
    }

    public static class FeaturesInput {
        private final EMFDiffNode _context;
        private final IMatch _match;

        public FeaturesInput(EMFDiffNode context_p, IMatch match_p) {
            this._context = context_p;
            this._match = match_p;
        }

        public boolean equals(Object object_p) {
            boolean result = false;
            if (object_p instanceof FeaturesInput) {
                FeaturesInput peer = (FeaturesInput)object_p;
                result = this._context == peer.getContext() && this._match.equals((Object)peer.getMatch());
            }
            return result;
        }

        public EMFDiffNode getContext() {
            return this._context;
        }

        public IMatch getMatch() {
            return this._match;
        }

        public int hashCode() {
            return this._context.hashCode() + this._match.hashCode();
        }
    }

    protected class LabelProvider
    extends DiffDecoratingLabelProvider {
        protected LabelProvider() {
        }

        @Override
        protected EMFDiffNode getDiffNode() {
            return FeaturesViewer.this.getInput() == null ? null : FeaturesViewer.this.getInput().getContext();
        }

        @Override
        protected Role getSide() {
            return null;
        }

        @Override
        protected boolean isTextTechnicalForMeta() {
            return FeaturesViewer.this.getInput() == null ? false : FeaturesViewer.this.getInput().getContext().isUserPropertyTrue(DefaultUserProperties.P_TECHNICAL_LABELS);
        }
    }
}

