/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.connector.git.ext;

import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.RevUtils;
import org.eclipse.emf.diffmerge.connector.git.EMFDiffMergeGitConnectorPlugin;
import org.eclipse.emf.diffmerge.connector.git.ext.AbstractGitURIConverter;
import org.eclipse.emf.diffmerge.connector.git.ext.GitHelper;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.team.core.history.IFileRevision;

public abstract class AbstractGitConflictURIConverter
extends AbstractGitURIConverter {
    protected final int _conflictRole;
    protected final String _holdingResourcePath;

    public AbstractGitConflictURIConverter(Repository repository_p, int conflictRole_p, String holdingResourcePath_p) {
        super(repository_p);
        this._conflictRole = conflictRole_p;
        this._holdingResourcePath = holdingResourcePath_p;
    }

    @Override
    protected IFileRevision getGitFileRevision(String gitPath) {
        try {
            if (GitHelper.INSTANCE.isConflicting(this.getRepository(), gitPath)) {
                return this.inIndex(this.getRepository(), gitPath, this._conflictRole);
            }
            RevUtils.ConflictCommits conflictCommits = RevUtils.getConflictCommits((Repository)this.getRepository(), (String)this._holdingResourcePath);
            if (2 == this._conflictRole) {
                return this.inCommit(this.getRepository(), conflictCommits.getOurCommit(), gitPath, null);
            }
            if (3 == this._conflictRole) {
                RevCommit commit = conflictCommits.getTheirCommit();
                if (commit == null) {
                    commit = conflictCommits.getOurCommit();
                }
                return this.inCommit(this.getRepository(), commit, gitPath, null);
            }
        }
        catch (IOException e) {
            EMFDiffMergeGitConnectorPlugin.getDefault().getLog().log((IStatus)new Status(4, EMFDiffMergeGitConnectorPlugin.getDefault().getPluginId(), e.getMessage(), (Throwable)e));
        }
        return this.inIndex(this.getRepository(), gitPath);
    }
}

