/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.scopes.IFeaturedModelScope;
import org.eclipse.emf.diffmerge.api.scopes.IPhysicalModelScope;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.diffdata.impl.EComparisonImpl;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.diffuidata.UIComparison;
import org.eclipse.emf.diffmerge.ui.diffuidata.impl.UIComparisonImpl;
import org.eclipse.emf.diffmerge.ui.diffuidata.util.UidiffdataResourceFactoryImpl;
import org.eclipse.emf.diffmerge.ui.specification.IComparisonSpecification;
import org.eclipse.emf.diffmerge.ui.specification.IScopeSpecification;
import org.eclipse.emf.diffmerge.ui.util.DiffMergeLabelProvider;
import org.eclipse.emf.diffmerge.ui.util.MiscUtil;
import org.eclipse.emf.diffmerge.ui.viewers.ComparisonViewer;
import org.eclipse.emf.diffmerge.ui.viewers.ModelComparisonDiffNode;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.xmi.PackageNotFoundException;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.ResourceUndoContext;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class EMFDiffMergeEditorInput
extends CompareEditorInput
implements IEditingDomainProvider {
    protected IComparisonSpecification _specification;
    protected Resource _comparisonResource;
    protected final Collection<Resource> _initialResources;
    protected IFeaturedModelScope _leftScope;
    protected IFeaturedModelScope _rightScope;
    protected IFeaturedModelScope _ancestorScope;
    protected ComparisonViewer _viewer;
    private boolean _foundDifferences;
    private boolean _isDirty;

    public EMFDiffMergeEditorInput(IComparisonSpecification specification_p) {
        super(new CompareConfiguration());
        this._specification = specification_p;
        this._leftScope = null;
        this._rightScope = null;
        this._ancestorScope = null;
        this._comparisonResource = null;
        this._initialResources = new ArrayList<Resource>();
        this._foundDifferences = true;
        this._isDirty = false;
        this.initializeCompareConfiguration();
    }

    public boolean canRunAsJob() {
        return true;
    }

    protected void contentsCreated() {
        this._viewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent ev) {
                EMFDiffMergeEditorInput.this.handleDispose();
            }
        });
    }

    public void contributeToToolBar(ToolBarManager toolBarManager) {
    }

    public Control createContents(Composite parent_p) {
        this._viewer = new ComparisonViewer(parent_p, this.getActionBars());
        this._viewer.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                String propertyName = event_p.getProperty();
                if ("DIRTY_STATE".equals(propertyName)) {
                    boolean dirty = (Boolean)event_p.getNewValue();
                    EMFDiffMergeEditorInput.this.setDirty(dirty);
                }
            }
        });
        IWorkbenchSite site = this.getSite();
        if (site != null) {
            site.setSelectionProvider((ISelectionProvider)this._viewer);
        }
        this._viewer.setInput((Object)this.getCompareResult());
        this.contentsCreated();
        return this._viewer.getControl();
    }

    protected void disposeResources() {
        final EditingDomain domain = this.getEditingDomain();
        final HashSet addedResources = new HashSet(domain.getResourceSet().getResources());
        addedResources.removeAll(this._initialResources);
        MiscUtil.executeAndForget(domain, new Runnable(){

            public void run() {
                if (EMFDiffMergeEditorInput.this._comparisonResource != null) {
                    for (EObject root : EMFDiffMergeEditorInput.this._comparisonResource.getContents()) {
                        if (!(root instanceof UIComparison)) continue;
                        UIComparison uiComparison = (UIComparison)root;
                        uiComparison.dispose();
                    }
                }
                for (Resource resource : addedResources) {
                    for (Adapter adapter : new ArrayList(resource.eAdapters())) {
                        if (!(adapter instanceof ECrossReferenceAdapter)) continue;
                        resource.eAdapters().remove((Object)adapter);
                    }
                }
                for (Resource resource : addedResources) {
                    resource.unload();
                }
                domain.getResourceSet().getResources().removeAll((Collection)addedResources);
            }
        });
        domain.getCommandStack().flush();
        if (domain instanceof TransactionalEditingDomain) {
            for (Resource resource : addedResources) {
                TransactionUtil.disconnectFromEditingDomain((Resource)resource);
                try {
                    ResourceUndoContext context = new ResourceUndoContext((TransactionalEditingDomain)domain, resource);
                    PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().dispose((IUndoContext)context, true, true, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected void flushViewers(IProgressMonitor monitor_p) {
        this._viewer.flush(monitor_p);
    }

    public boolean foundDifferences() {
        return this._foundDifferences;
    }

    public ModelComparisonDiffNode getCompareResult() {
        return (ModelComparisonDiffNode)((Object)super.getCompareResult());
    }

    public EditingDomain getEditingDomain() {
        return this._specification.getEditingDomain();
    }

    protected IWorkbenchSite getSite() {
        IWorkbenchPartSite result = null;
        ICompareContainer container = this.getCompareConfiguration().getContainer();
        IWorkbenchPart part = container.getWorkbenchPart();
        if (part != null) {
            result = part.getSite();
        }
        return result;
    }

    protected void handleDispose() {
        boolean inUIThread;
        IWorkbenchSite site = this.getSite();
        if (site != null) {
            site.setSelectionProvider(null);
        }
        super.handleDispose();
        Runnable disposeBehavior = new Runnable(){

            public void run() {
                if (EMFDiffMergeEditorInput.this.getCompareResult() != null) {
                    EMFDiffMergeEditorInput.this.getCompareResult().dispose();
                }
                EMFDiffMergeEditorInput.this.disposeResources();
                EMFDiffMergeEditorInput.this._specification.dispose();
                EMFDiffMergeEditorInput.this._specification = null;
                EMFDiffMergeEditorInput.this._ancestorScope = null;
                EMFDiffMergeEditorInput.this._leftScope = null;
                EMFDiffMergeEditorInput.this._rightScope = null;
                EMFDiffMergeEditorInput.this._viewer = null;
                EMFDiffMergeEditorInput.this._comparisonResource = null;
                EMFDiffMergeEditorInput.this._initialResources.clear();
            }
        };
        Display display = Display.getDefault();
        boolean bl = inUIThread = display.getThread() == Thread.currentThread();
        if (inUIThread) {
            BusyIndicator.showWhile((Display)display, (Runnable)disposeBehavior);
        } else {
            disposeBehavior.run();
        }
        try {
            super.run(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void handleExecutionProblem(Throwable problem_p) {
        String message;
        Throwable diagnostic = problem_p;
        if (diagnostic instanceof WrappedException) {
            diagnostic = ((WrappedException)diagnostic).exception();
        }
        if (diagnostic instanceof PackageNotFoundException) {
            PackageNotFoundException pnfe = (PackageNotFoundException)diagnostic;
            message = MiscUtil.buildString(Messages.EMFDiffMergeEditorInput_WrongMetamodel, "\n", pnfe.getLocation(), ".\n", Messages.EMFDiffMergeEditorInput_MigrationNeeded);
        } else {
            String msg = diagnostic.getLocalizedMessage();
            if (msg == null) {
                msg = diagnostic.toString();
            }
            message = MiscUtil.buildString(Messages.EMFDiffMergeEditorInput_Failure, "\n", msg);
        }
        Shell shell = null;
        if (this.getWorkbenchPart() != null && this.getWorkbenchPart().getSite() != null) {
            shell = this.getWorkbenchPart().getSite().getShell();
        }
        if (shell != null) {
            final String finalMessage = message;
            final Shell finalShell = shell;
            shell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)finalShell, (String)EMFDiffMergeUIPlugin.LABEL, (String)finalMessage);
                }
            });
        }
    }

    protected void initializeCompareConfiguration() {
        CompareConfiguration cc = this.getCompareConfiguration();
        cc.setLeftLabel(this._specification.getScopeSpecification(Role.TARGET).getLabel());
        cc.setRightLabel(this._specification.getScopeSpecification(Role.REFERENCE).getLabel());
        IScopeSpecification ancestorSpecification = this._specification.getScopeSpecification(Role.ANCESTOR);
        cc.setAncestorLabel(ancestorSpecification == null ? "" : ancestorSpecification.getLabel());
        cc.setLeftEditable(this._specification.getScopeSpecification(Role.TARGET).isEditable());
        cc.setRightEditable(this._specification.getScopeSpecification(Role.REFERENCE).isEditable());
    }

    protected ModelComparisonDiffNode initializeDiffNode(EComparison comparison_p) {
        UIComparisonImpl uiComparison = new UIComparisonImpl(comparison_p);
        EditingDomain domain = this.getEditingDomain();
        domain.getResourceSet().getResourceFactoryRegistry().getExtensionToFactoryMap().put("diffuidata", new UidiffdataResourceFactoryImpl());
        this._comparisonResource = this.getEditingDomain().createResource("platform:/resource/comparison/comparison.diffuidata");
        ModelComparisonDiffNode result = new ModelComparisonDiffNode(uiComparison, domain);
        result.updateDifferenceNumbers();
        return result;
    }

    public boolean isSaveNeeded() {
        return this._isDirty;
    }

    protected void loadScopes(IProgressMonitor monitor_p) {
        EditingDomain domain = this.getEditingDomain();
        this._initialResources.addAll((Collection<Resource>)domain.getResourceSet().getResources());
        boolean threeWay = this._specification.isThreeWay();
        String mainTaskName = Messages.EMFDiffMergeEditorInput_Loading;
        SubMonitor loadingMonitor = SubMonitor.convert((IProgressMonitor)monitor_p, (String)mainTaskName, (int)(threeWay ? 4 : 3));
        loadingMonitor.worked(1);
        loadingMonitor.subTask(Messages.EMFDiffMergeEditorInput_LoadingLeft);
        this._leftScope = this._specification.getScopeSpecification(Role.TARGET).createScope(domain);
        if (this._leftScope instanceof IPhysicalModelScope) {
            try {
                ((IPhysicalModelScope)this._leftScope).load();
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
        }
        loadingMonitor.worked(1);
        if (loadingMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        loadingMonitor.subTask(Messages.EMFDiffMergeEditorInput_LoadingRight);
        this._rightScope = this._specification.getScopeSpecification(Role.REFERENCE).createScope(domain);
        if (this._rightScope instanceof IPhysicalModelScope) {
            try {
                ((IPhysicalModelScope)this._rightScope).load();
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
        }
        loadingMonitor.worked(1);
        if (loadingMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (threeWay) {
            loadingMonitor.subTask(Messages.EMFDiffMergeEditorInput_LoadingAncestor);
            this._ancestorScope = this._specification.getScopeSpecification(Role.ANCESTOR).createScope(domain);
            if (this._ancestorScope instanceof IPhysicalModelScope) {
                try {
                    ((IPhysicalModelScope)this._ancestorScope).load();
                }
                catch (Exception e) {
                    throw new WrappedException(e);
                }
            }
            loadingMonitor.worked(1);
            if (loadingMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
        }
    }

    public boolean mergeIsComplete() {
        return !this.isDirty() && (this._viewer.getInput() == null || this._viewer.getInput().isEmpty());
    }

    protected Object prepareInput(IProgressMonitor monitor_p) throws InvocationTargetException, InterruptedException {
        if (monitor_p == null) {
            return null;
        }
        boolean scopesReady = this._leftScope != null;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)monitor_p, (String)EMFDiffMergeUIPlugin.LABEL, (int)2);
        ModelComparisonDiffNode result = null;
        try {
            if (!scopesReady) {
                this.loadScopes((IProgressMonitor)monitor.newChild(1));
            }
            EComparisonImpl comparison = new EComparisonImpl(this._leftScope, this._rightScope, this._ancestorScope);
            comparison.compute(this._specification.getMatchPolicy(), this._specification.getDiffPolicy(), this._specification.getMergePolicy(), (IProgressMonitor)monitor.newChild(scopesReady ? 2 : 1));
            this._foundDifferences = comparison.hasRemainingDifferences();
            if (this._foundDifferences) {
                result = this.initializeDiffNode((EComparison)comparison);
            } else {
                this.handleDispose();
            }
        }
        catch (OperationCanceledException e) {
            this.handleDispose();
        }
        catch (Throwable t) {
            this.handleExecutionProblem(t);
            this.handleDispose();
        }
        return result;
    }

    public void run(IProgressMonitor monitor_p) throws InterruptedException, InvocationTargetException {
        if (this.getCompareResult() != null) {
            this.getCompareResult().dispose();
        }
        super.run(monitor_p);
        if (this.getCompareResult() != null && this.foundDifferences()) {
            MiscUtil.executeAndForget(this.getEditingDomain(), new Runnable(){

                public void run() {
                    EMFDiffMergeEditorInput.this._comparisonResource.getContents().add((Object)EMFDiffMergeEditorInput.this.getCompareResult().getUIComparison());
                }
            });
            this.getEditingDomain().getCommandStack().flush();
        }
    }

    public void setDirty(boolean dirty_p) {
        boolean oldDirty = this.isDirty();
        if (dirty_p != oldDirty) {
            this._isDirty = dirty_p;
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "DIRTY_STATE", (Object)oldDirty, (Object)this._isDirty);
            this.firePropertyChange(event);
        }
    }

    public static class ScopeTypedElementWrapper
    implements ITypedElement {
        private final IFeaturedModelScope _scope;

        public ScopeTypedElementWrapper(IFeaturedModelScope scope_p) {
            this._scope = scope_p;
        }

        public Image getImage() {
            EObject root;
            Image result = null;
            if (!this._scope.getContents().isEmpty() && (root = (EObject)this._scope.getContents().get(0)).eResource() != null) {
                result = DiffMergeLabelProvider.getInstance().getImage(root.eResource());
            }
            return result;
        }

        public String getName() {
            EObject root;
            String result = null;
            if (!this._scope.getContents().isEmpty() && (root = (EObject)this._scope.getContents().get(0)).eResource() != null) {
                result = DiffMergeLabelProvider.getInstance().getText(root.eResource());
            }
            return result;
        }

        public String getType() {
            return "???";
        }
    }
}

