/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.actions;

import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.actions.ComparisonSetup;
import org.eclipse.emf.diffmerge.ui.specification.IComparisonSpecification;
import org.eclipse.emf.diffmerge.ui.specification.IComparisonSpecificationFactory;
import org.eclipse.emf.diffmerge.ui.specification.IScopeSpecification;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ComparisonSetupWizardPage
extends WizardPage {
    protected final ComparisonSetup _setup;

    public ComparisonSetupWizardPage(String name_p, ComparisonSetup setup_p) {
        super(name_p);
        this._setup = setup_p;
    }

    public void createControl(Composite parent_p) {
        this.setTitle(Messages.ComparisonSetupWizardPage_Title);
        this.setDescription(Messages.ComparisonSetupWizardPage_Description);
        Composite composite = new Composite(parent_p, 0);
        this.setControl((Control)composite);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createRolesSection(composite);
        this.createComparisonMethodSection(composite);
        this._setup.swapScopeSpecifications(Role.TARGET, Role.TARGET);
        Point size = composite.computeSize(-1, -1);
        ((GridData)parent_p.getLayoutData()).heightHint = size.y + 5;
    }

    protected void createComparisonMethodSection(Composite parent_p) {
        Group group = new Group(parent_p, 0);
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText(Messages.ComparisonSetupWizardPage_GroupMethod);
        ComboViewer methodViewer = this.createComparisonMethodViewer((Composite)group);
        this.createConfigureMethodButton((Composite)group);
        methodViewer.setInput((Object)this._setup);
        Object first = methodViewer.getElementAt(0);
        StructuredSelection viewerSelection = first != null ? new StructuredSelection(first) : new StructuredSelection();
        methodViewer.setSelection((ISelection)viewerSelection);
    }

    protected Button createConfigureMethodButton(Composite parent_p) {
        final Button result = new Button(parent_p, 8);
        result.setText(Messages.ComparisonSetupWizardPage_ConfigureButton);
        result.setLayoutData((Object)new GridData(16384, 128, false, false));
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                IComparisonSpecification specification = ComparisonSetupWizardPage.this._setup.getComparisonSpecification();
                if (specification != null) {
                    specification.configure();
                }
            }
        });
        this._setup.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                if ("ComparisonSetup.Property.ComparisonMethod".equals(event_p.getProperty())) {
                    IComparisonSpecification specification = ComparisonSetupWizardPage.this._setup.getComparisonSpecification();
                    result.setEnabled(specification != null && specification.isConfigurable());
                }
            }
        });
        return result;
    }

    protected ComboViewer createComparisonMethodViewer(Composite parent_p) {
        ComboViewer result = new ComboViewer(parent_p);
        result.getCombo().setLayoutData((Object)new GridData(4, 4, true, false));
        result.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement_p) {
                Object[] localResult = new Object[]{};
                if (inputElement_p instanceof ComparisonSetup) {
                    ComparisonSetup selection = (ComparisonSetup)inputElement_p;
                    localResult = selection.getCompatibleFactories().toArray();
                }
                return localResult;
            }
        });
        result.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element_p) {
                String localResult;
                if (element_p instanceof IComparisonSpecificationFactory) {
                    IComparisonSpecificationFactory factory = (IComparisonSpecificationFactory)element_p;
                    localResult = factory.getLabel();
                } else {
                    localResult = super.getText(element_p);
                }
                return localResult;
            }
        });
        result.setSorter(new ViewerSorter());
        result.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                Object selected;
                ISelection selection = event_p.getSelection();
                if (selection instanceof IStructuredSelection && (selected = ((IStructuredSelection)selection).getFirstElement()) instanceof IComparisonSpecificationFactory) {
                    ComparisonSetupWizardPage.this._setup.setSelectedFactory((IComparisonSpecificationFactory)selected);
                }
            }
        });
        return result;
    }

    protected void createRolesSection(Composite parent_p) {
        Group group = new Group(parent_p, 0);
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        group.setLayout((Layout)new GridLayout(2, false));
        group.setText(Messages.ComparisonSetupWizardPage_GroupRoles);
        this.createCheckRolesSubsection((Composite)group);
        this.createSwapRolesSubsection((Composite)group);
    }

    protected void createCheckRolesSubsection(Composite parent_p) {
        Composite subsection = new Composite(parent_p, 0);
        subsection.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout rolesLayout = new GridLayout(2, false);
        rolesLayout.marginHeight = 0;
        rolesLayout.marginWidth = 0;
        subsection.setLayout((Layout)rolesLayout);
        new Label(subsection, 0).setText(Messages.ComparisonSetupWizardPage_RoleLeft);
        final Text leftText = new Text(subsection, 2056);
        leftText.setLayoutData((Object)new GridData(4, 4, true, false));
        this._setup.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                if ("ComparisonSetup.Property.Roles".equals(event_p.getProperty())) {
                    IScopeSpecification scope = ComparisonSetupWizardPage.this._setup.getScopeSpecification(Role.TARGET);
                    leftText.setText(scope.getLabel());
                }
            }
        });
        new Label(subsection, 0).setText(Messages.ComparisonSetupWizardPage_RoleRight);
        final Text rightText = new Text(subsection, 2056);
        rightText.setLayoutData((Object)new GridData(4, 4, true, false));
        this._setup.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                if ("ComparisonSetup.Property.Roles".equals(event_p.getProperty())) {
                    IScopeSpecification scope = ComparisonSetupWizardPage.this._setup.getScopeSpecification(Role.REFERENCE);
                    rightText.setText(scope.getLabel());
                }
            }
        });
        if (this._setup.isThreeWay()) {
            new Label(subsection, 0).setText(Messages.ComparisonSetupWizardPage_RoleAncestor);
            final Text ancestorText = new Text(subsection, 2056);
            ancestorText.setLayoutData((Object)new GridData(4, 4, true, false));
            this._setup.addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event_p) {
                    if ("ComparisonSetup.Property.Roles".equals(event_p.getProperty())) {
                        IScopeSpecification scope = ComparisonSetupWizardPage.this._setup.getScopeSpecification(Role.ANCESTOR);
                        ancestorText.setText(scope.getLabel());
                    }
                }
            });
        }
    }

    protected void createSwapRolesSubsection(Composite parent_p) {
        Composite buttonSubsection = new Composite(parent_p, 0);
        buttonSubsection.setLayoutData((Object)new GridData(131072, 4, false, false));
        RowLayout buttonLayout = new RowLayout(512);
        buttonLayout.justify = true;
        buttonSubsection.setLayout((Layout)buttonLayout);
        Button leftRightSwap = new Button(buttonSubsection, 8);
        leftRightSwap.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.SWAP));
        leftRightSwap.setToolTipText(Messages.ComparisonSetupWizardPage_SwapLeftRight);
        leftRightSwap.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                ComparisonSetupWizardPage.this._setup.swapScopeSpecifications(Role.TARGET, Role.REFERENCE);
            }
        });
        if (this._setup.isThreeWay()) {
            Button rightAnSwap = new Button(buttonSubsection, 8);
            rightAnSwap.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.SWAP));
            rightAnSwap.setToolTipText(Messages.ComparisonSetupWizardPage_SwapRightAncestor);
            rightAnSwap.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event_p) {
                    ComparisonSetupWizardPage.this._setup.swapScopeSpecifications(Role.REFERENCE, Role.ANCESTOR);
                }
            });
        }
    }
}

